# Entrevista reversa

Este repositório é uma lista de perguntas que podem ser interessantes para uma pessoa candidata a uma vaga em uma empresa de tecnologia. As perguntas não estão ordenadas e muitas podem não se aplicar para uma dada posição ou tipo de trabalho. Começou como minha lista pessoal de perguntas, que cresceu ao longo do tempo para incluir as coisas que eu gostaria de ver mais e alertas que eu gostaria de evitar. Também notei como poucas perguntas foram feitas por pessoas que entrevistei e acho que essas oportunidades foram perdidas.

Se você perguntou algo não listado aqui, mande um PR.

Traduções: 

- Chinês [Simplificado](https://github.com/yifeikong/reverse-interview-zh) / [Tradicional](https://github.com/NeroCube/reverse-interview-zh-tw/blob/master/README.md)
- [Francês](https://github.com/viraptor/reverse-interview/blob/master/translations/FRENCH.md)
- [Coreano](https://github.com/JaeYeopHan/Interview_Question_for_Beginner/blob/master/Reverse_Interview/README.md)
- [Russo](https://github.com/kix/reverse-interview/blob/master/README.md)
- [Espanhol](https://github.com/felHR85/Entrevista-inversa/blob/master/README.md)

## Uso esperado

- Verifique quais perguntas são interessantes para você especificamente
- Verifique quais respostas você consegue achar online por conta própria
- Caso contrário, pergunte

Definitivamente não tente perguntar tudo da lista.

Lembre que as coisas tendem a serem fluidas, reorganizações acontecem com frequência.
Ter um sistema de monitoramento de bugs não traz necessariamente um melhor tratamento e correções de bug e ter CI/CD não significa que o seu tempo de entrega é curto. 

# O cargo

- Qual é a política para plantões? (Existe pagamento para estar disponível ou por chamadas?)
- Quais tarefas eu faria em um dia normal?
- Qual é média de desenvolvedores juniores e seniores? (E existe algum plano para mudar isso?)
- Como o período de adaptação funciona?
- Quanto de proatividade versus fazer o que foi pedido é esperado?
- Qual é a quantidade de horas de trabalho esperada?
- Qual é sua definição de sucesso para essa função?
- Existe um plano de carreira para subir de júnior a pleno e de pleno a sênior?

# Tecnologia

- Quais são as tecnologias utilizadas na empresa?
- Como vocês usam controle de versionamento?
- Como vocês testam o código?
- Como vocês monitoram bugs?
- Como vocês integram e implantam mudanças? Vocês usam CI/CD?
- A configuração de sua infraestrutura está versionada/disponível como código?
- Como é o fluxo de desenvolvimento, desde o planejamento até uma tarefa ser finalizada?
- Como vocês se preparam para recuperação de desastres?
- Existe algum ambiente de desenvolvimento padronizado? Ele é obrigatório?
- Quão rápido vocês conseguem configurar um novo ambiente de testes para o produto? (minutos / horas / dias)
- Quão rápido você consegue responder a problemas de segurança ou dependências no código?
- Todos os desenvolvedores tem permissão a acesso de administrador nos seus próprios computadores?

# O time

- Como o trabalho é organizado?
- Como a comunicação interna e externa dos times geralmente funciona?
- Como diferenças de opinião são resolvidas?
- Quem define prioridades / prazos?
- O que acontece quando existem atrasos? ("Isso não pode ser feito no prazo previsto")
- Que tipo de reuniões acontecem toda semana?
- Quais são os cronogramas para os produtos/serviços? (lançamento n-semanais / lançamento contínuo / múltiplas fontes de lançamento / ...)
- O que acontece quando acontece um incidente em produção? Existe alguma cultura de analisar quem foi o responsável?
- Quais são alguns desafios atuais que o time está experienciando e como vocês estão resolvendo?

# A empresa

- Existe algum orçamento para ir para conferências/viagens e quais são as regras para usá-lo?
- Como é o processo de promoção? Quais são os requisitos/expectativas transmitidas para os funcionários?
- Existem progressões diferentes para desenvolvimento e gerência?
- Qual é o estado/visão de diversidade na contratação?
- Existe algum recurso na empresa para aprender, como assinatura de e-books ou cursos online?
- Existe algum orçamento para adquirir certificações?
- Qual é o estágio de maturidade? (descobrindo o que desenvolver/trabalhando em novas funcionalidades/manutenção/...)
- Eu posso contribuir para projetos open source? É necessária alguma autorização?
- Existe algum acordo de não competição ou confidencialidade ou algo parecido que eu tenha que assinar?
- Quais você acha que sejam as falhas na cultura de empresa?
- Você poderia me contar uma história de uma situação tóxica na empresa e como vocês resolveram ela?

# O negócio

- Vocês estão lucrando?
- Se não, quanto tempo até o dinheiro em caixa acabar?
- De onde vem o dinheiro de investimento e quem tem influência nas decisões e direcionamento da empresa?
- Como vocês lucram?
- O que impede vocês de lucrarem ainda mais?
- O que vocês identificam como sua vantagem competitiva?

# Trabalho remoto

- Qual é a relação de trabalhadores remotos com os presenciais?
- A companhia fornece equipamentos como notebooks, se sim qual e de quanto em quanto tempo são renovados?
- Acessórios e mobílias extras são possíveis de comprar através da empresa? Existe algum orçamento planejado para eles?
- Existe algum orçamento para espaços de co-working ou acesso a internet?
- Quão frequente são esperadas visitas a empresa?
- As salas de reunião estão sempre prontas para videoconferência?

# Trabalho no escritório

- Qual é o leiaute do ambiente de trabalho? (Espaço aberto/cubículos/vários ambientes)
- Existe um time de suporte / marketing / ou outra função que esteja próximo ao o meu?

# Compensação

- Se você tem uma política de bônus, então como eles são determinados?
- Se você tem uma política de bônus, então quais foram as porcentagens típicas nos últimos anos?
- Vocês tem alguma política de aposentadoria?

# Folga remunerada

- Como funciona a folga remunerada?
- Faltas por férias ou por doenças são descontadas de um mesmo lugar. Os dias que ficar doente são descontados das minhas férias?
- Posso antecipar minhas folgas, isso afeta o valor a ser pago de alguma forma?
- Como funciona o rotacionamento de folgas remuneradas?
- Qual é a política para faltas por parentalidade?
- Qual é a política para licença não remunerada?

# Outros recursos

- Ache mais inspirações para perguntas em [Joel Test](https://www.joelonsoftware.com/2000/08/09/the-joel-test-12-steps-to-better-code/)
