# Umgedrehtes Bewerbungsgespräch

Dies ist eine Liste von Fragen, die für einen Bewerber im technischen Sektor interessant sein könnten.
Die einzelnen Punkte sind nicht sortiert und können unter Umständen nicht zu jeder Position oder Typ von Job passen.
Ich habe diese Liste als eine persönliche Liste von Fragen gestartet, die über Zeit angewachsen ist zu einer Sammlung von zwei Dingen, von denen ich gerne mehr lesen würde: Rote Flaggen und Dinge, die ich gerne vermeiden würde.
Mir ist ebenfalls aufgefallen, dass wenig Menschen, die ich interviewed habe einige der Fragen gestellt haben, und ich denke das sind verpasste Chancen.

Wenn du Fragen hast, die nicht hier gelistet sind, sende einen PR.

Übersetzungen:

- [Arabisch](https://github.com/sherifsaleh/reverse-interview/blob/master/translations/ARABIC.md)
- [Catalanisch](https://github.com/viraptor/reverse-interview/blob/master/translations/CATALAN.md)
- Chinesisch [Vereinfacht](https://github.com/yifeikong/reverse-interview-zh) / [Traditionell](https://github.com/NeroCube/reverse-interview-zh-tw/blob/master/README.md)
- [Englisch](https://github.com/viraptor/reverse-interview/blob/master/README.md)
- [Französisch](https://github.com/viraptor/reverse-interview/blob/master/translations/FRENCH.md)
- [Koreanisch](https://github.com/JaeYeopHan/Interview_Question_for_Beginner/blob/master/Reverse_Interview/README.md)
- [Portugiesisch (Brazilianisch)](https://github.com/viraptor/reverse-interview/blob/master/translations/pt-BR.md)
- [Russisch](https://github.com/kix/reverse-interview/blob/master/README.md)
- [Spanisch](https://github.com/felHR85/Entrevista-inversa/blob/master/README.md)

## Bevorzugte Anwendung

- Überprüfe welche Fragen speziell für dich interessent sind
- Überprüfe welche Antworten du online finden kannst
- In jedem anderen Fall: Stelle die Frage

Verhindere auf jeden Fall alle Fragen von der Liste zu stellen. (Respektiere die Zeit des Gegenübers und zeige Initiative indem du Antworten raussuchst, die öffentlich zugänglich sind)

Denke daran, dass Dinge sich oft im Wandel befinden. Neuorganisationen passieren oft.
Nur weil man ein Bugtrackingsystem besitzt, macht das einen nicht zwingend effizient darin bugs zu finden, und eine CI/CD zu einzusetzen heißt nicht dass die Entwicklungszeiten bis zur Auslieferung zwingend kurz sind.

# Die Stelle

- Wie sieht der Bereitschaftszeitplan aus? (Wie ist die Bezahlung bei Bereitschaftsdienst und Einsatz?)
- Was sind die Aufgaben, die ich an einem typischen Tag erledigen würde?
- Wie ist die Balance zwischen Junior und Senior Mitarbeitern im Team? (und gibt es Pläne diese zu ändern)
- Wie sieht das Onboarding aus?
- Wie viel Entscheidungsfreiheit hat ein individueller Entwickler?
- Was sind die Kernarbeitszeiten, falls vorhanden?
- Was ist Ihre definition von Erfolg für diese Stelle?
- Haben Sie irgendwelche Bedenken bezüglich meiner Bewerbung?
- Mit wem würde ich am engsten zusammenarbeiten?
- Was für einen Managementstil haben mein direkter und deren Manager? (von mikro- bis makro-)

# Tech

- Was sind die üblichen technologien, die im Unternehmen zum Einsatz kommen?
- Wie nutzen Sie Versionskontrolle?
- Wie testen sie Code?
- Wie verfolgen sie Bugs?
- Wie integrieren Sie Änderungen, und wie werden diese ausgeliefert? Ist es eine CI/CD?
- Ist ihre Infrastruktur unter Versionskontrolle / verfügbar als Code?
- Was ist der übliche Arbeitsablauf von der Planung bis zur fertigen Aufgabe?
- Wie bereiten Sie sich auf die Erholung von einem Disaster vor?
- Gibt es eine standardisierte Entwicklungsumgebung? Wird diese durchgesetzt?
- Wie schnell können Sie eine neue lokale Testumgebung für das Produkt aufsetzen? (Minuten / Stunden / Tage)
- Wie schnell können Sie auf eine Sicherheitslücke im Code oder in den Abhängigkeiten reagieren?
- Dürfen alle Entwickler lokalen Admin-Zugriff auf ihre Computer haben?
- Erzählen Sie mir etwas über ihre technischen Prinzipien oder Vision.
- Haben Sie eine Entwicklerdokumentation für Ihren Code? Haben Sie eine separate Dokumentation für Kunden?
- Nutzen Sie statische Codeanalyse?
- Wie gehen Sie mit internen oder externen Artefakten um?
- Wie verwalten Sie Abhängigkeiten?

# Das Team

- Wie ist die Arbeit organisiert?
- Wie funktioniert die Intra-/Interteamkommunikation üblicherweise?
- Nutzen Sie irgendwelche Werkzeuge für Projektorganisation? Was haben Sie für Erfahrungen damit gemacht?
- Wie werden Meinungsverschiedenheiten gelöst?
- Wer legt Prioritäten / einen Zeitplan fest?
- Was passiert, wenn etwas zeitlich verschoben werden muss? ("Das kann in der vorgesehenen Zeit nicht fertig gestellt werden")
- Was passiert, wenn ein Team ein Veröffentlichungsziel nicht einhält?
- Welche Arten von Meetings finden jede Woche statt?
- Was ist der Produkt-/Servicezeitplan? (n-wöchentliche Auslieferungen / Continuous Deployment / mehrere Auslieferungsszyklen / ...)
- Was passiert, nachdem etwas in Produktion schief läuft? Gibt es eine Kultur von nicht beschuldigender Analyse?
- Was sind andauernde Herausforderungen, die das Team erfährt und welche Sie noch nicht gelöst haben?
- Wie messen Sie Fortschritt?
- Wie werden Erwartungen und Ziele gesetzt, und wer setzt diese fest?
- Wie sieht hier ein Codereview aus?
- Wie funktioniert ein typischer Sprint in diesem Team Schritt für Schritt?
- Wie balancieren Sie zwischen technischen und Businesszielen?

# Deine potentiellen KollegInnen

- Von wem lernen die Entwickler typischerweise?
- Was gefällt Ihnen am meisten daran hier zu arbeiten?
- Was gefällt Ihnen am wenigsten?
- Was würden Sie ändern, wenn Sie könnten?
- Wie lange arbeitet das dienstälteste Teammitglied schon hier?

# Das Unternehmen

- Gibt es ein Konferenz- bzw. Reisebudget und wie sind die Nutzungsregeln?
- Wie sieht der Prozess bezüglich Beförderungen aus? Wie werden Anforderungen und Erwartungen kommuniziert?
- Wie sieht das Mitarbeitergespräch aus?
- Gibt es separate Technologie- und Managementbasierte Karrierepfade?
- Wie ist der Status von Gleichberechtigung im Unternehmen?
- Gibt es firmenweit bereitgestellte Ressourcen zur Weiterbildung wie Ebook-Abbonements oder Onlinekurse?
- Ist ein Budget für den Erwerb von Zertifizierungen vorgesehen?
- Was ist der aktuelle Reifegrad? (Frühe Findungsphase / Featureentwicklung / Wartungsphase / ...)
- Kann ich zu FOSS-Projekten beitragen? Muss man sich dazu Genehmigungen einholen?
- Muss ich irgenclwelche Wettbewerbsverbotsklauseln oder Vertraulichkeitsvereinbarungen unterschreiben?
- Wo sehen Sie das Unternehmen in den nächsten 5/10 Jahren?
- Wo denken Sie besteht noch Nachholbedarf in der Unternehmenskultur?
- Was bedeutet den meisten Entwicklern hier Clean Code?
- Wann ist Ihnen das letzte mal jemand aufgefallen der Wachstum gezeigt hat, und auf welche Weise?
- Was bedeutet es hier erfolgreich zu sein und wie wird Erfolg gemessen?
- Wie sieht die Work-Life Balance hier aus?

# Konflikt

- Wie werden Meinungsverschiedenheiten gelöst?
- Was passiert, wenn etwas zeitlich verschoben werden muss? ("Das kann in der vorgesehenen Zeit nicht fertig gestellt werden")
- Was passiert, wenn das Team unter Druck geräht und sich darauf einlässt über dessen Kapazität zu arbeiten?
- Was passiert, wenn jemand Verbesserungen im Prozessablauf / der Technologie / etc. identifiziert?
- Was passiert, wenn es eine Lücke zwischen den Erwartungen des Managements und der Leistung eines Engineurs oder Teams gibt?
- Können Sie mir von einem Beispiel berichten in dem eine toxische Situation statt fand? Wie ist das Unternehmen damit umgegangen?

# Das Business

- Ist das Unternehmen profitabel?
- Wenn nicht, wie lange kann das Unternehmen ohne Veränderungen weiter machen?
- Woher kommen Investments und wer beeinflusst die übergeordnete Zielsetzung?
- Wie verdient das Unternehmen Geld?
- Was hindert das Unternehmen daran mehr Geld zu verdienen?
- Wie sieht der Wachstumsplan des Unternehmens für die nächsten 1 bis 5 Jahre aus?
- Was sind die großen Herausfoderungen die Sie in der Zukunft sehen?
- Was haben Sie als Ihren Wettbewerbsvorteil ausgemacht?

# Heim- / Telearbeit

- Wie ist der Anteil von Telearbeitern zu Leuten vor Ort?
- Stellt das Unternehmen Hardware und wie oft wird diese aktualisiert?
- Wie ist die Stellung zu [BYOD](https://en.wikipedia.org/wiki/Bring_your_own_device)? Gibt es Richtlinien diesbezüglich?
- Ist es möglich weitere Accessoires oder Möbel durch die Firma anzuschaffen? Ist ein Budget dafür eingeplant?
- Gibt es Budget für einen Co-working Platz oder Internetzugang?
- Wie oft wird man im Büro erwartet?
- Gibt es dedizierte Räume für Videomeetings?

# Gebäudeaufteilung

- Wie sieht die Gebäudeaufteilung aus? (Offenes Büro / Kabinen / Büros)
- Sitzt ein Support- / Marketing- / oder anderes Telefonlastiges Team in der Nähe von meinem?

# Allgemeines

- Was ist der schlechteste und der beste Aspekt von Arbeit in dieser Rolle / diesem Team / diesem Unternehmen?

# Bezahlung

- Wenn Bonuszahlungen existieren, wie werden diese festgelegt?
- Wenn Bonuszahlungen existieren, wie sahen die letzten Jahre die typischen Auszahlungen in Prozent vom Jahresgehalt aus?
- Bieten Sie eine Altersvorsorge an? Wenn ja, leistet das Unternehmen einen Beitrag dazu?
- Bietet das Unternehmen besondere Krankenversicherungszusätze an?

# Auszeit

- Wie viele bezahlte Urlaubstage hat man?
- Sind Krankheitstage und Urlaubstage separat? (Diese Frage ist in Deutschland nicht relevant)
- Kann ich mehr Urlaubstage nutzen und diese mit Mehrarbeit ausgleichen?
- Wie viele Urlaubstage und bis wann kann ich ins nächste Jahr mitnehmen?
- Wie sieht es mit Elternzeit aus?
- Kann man sich unbezahlten Urlaub nehmen?

# Andere Ressourcen

- Mehr Inspiration und Fragen bei [Joel Test](https://www.joelonsoftware.com/2000/08/09/the-joel-test-12-steps-to-better-code/)

# Lizenz

[![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](https://creativecommons.org/licenses/by-sa/4.0/)

Diese Veröffentlichung steht unter [Creative Commons Attribution-ShareAlike 4.0 International License](https://creativecommons.org/licenses/by-sa/4.0/).
