# Reverse interview

This is a list of questions which may be interesting to a tech job applicant.
The points are not ordered and many may not apply to a given position, or work type.
It was started as my personal list of questions, which grew over time to include both things I'd like to see more of and red flags which I'd like to avoid.
I've also noticed how few questions were asked by people I interviewed and I think those were missed opportunities.

If you asked something not listed here, send in a PR.

Translations:

- [Arabic](https://github.com/sherifsaleh/reverse-interview/blob/master/translations/ARABIC.md)
- [Catalan](https://github.com/viraptor/reverse-interview/blob/master/translations/CATALAN.md)
- Chinese [Simplified](https://github.com/yifeikong/reverse-interview-zh) / [Traditional](https://github.com/NeroCube/reverse-interview-zh-tw/blob/master/README.md)
- [English](https://github.com/viraptor/reverse-interview/blob/master/README.md)
- [French](https://github.com/viraptor/reverse-interview/blob/master/translations/FRENCH.md)
- [German](https://github.com/viraptor/reverse-interview/blob/master/translations/GERMAN.md)
- [Hindi](https://github.com/hraverkar/reverse-interview/blob/master/translations/Hindi.md)
- [Italian](https://github.com/viraptor/reverse-interview/blob/master/translations/ITALIAN.md)
- [Korean](https://github.com/JaeYeopHan/Interview_Question_for_Beginner/blob/master/Reverse_Interview/README.md)
- [Portuguese (Brazilian)](https://github.com/viraptor/reverse-interview/blob/master/translations/pt-BR.md)
- [Russian](https://github.com/kix/reverse-interview/blob/master/README.md)
- [Spanish](https://github.com/felHR85/Entrevista-inversa/blob/master/README.md)
- [Turkish](https://github.com/viraptor/reverse-interview/blob/master/translations/TURKISH.md)
- [Vietnamese](https://github.com/tuannh99/reverse-interview/blob/master/README.md)

## Expected usage

- Check which questions are interesting for you specifically
- Check which answers you can find yourself online
- Otherwise ask

Definitely don't try to ask everything from the list. (Respect the interviewer's time and show initiative by finding answers on your own if they're already published)

Remember that things tend to be fluid, re-organizations happens often.
Having a bug tracking system doesn't make bug handling efficient and CI/CD doesn't mean your time to deliver is necessarily short.

# The Role

- What's the on-call plan/schedule? (what's the pay for standby and call-out)
- What are the tasks I would do on a usual day?
- Are there any specific goals for me?
- What's the junior/senior balance of the team? (and are there plans to change it)
- What does the onboarding look like?
- How much freedom for decision making do individual developers have?
- What are the expected/core work hours?
- What is your definition of success for this role?
- What do you expect me to accomplish in the first 1 month/3 months?
- How will you evaluate my performance at the end of the trial period?
- What does a typical day/week look like in this role?
- Do you have any concerns about my application?
- Tell me about who I would be working most closely with.
- What management style does my immediate manager and their manager have? (from micro- to macro-)
- How can I develop in my new role / what opportunities are offered?

# Tech

- What are the usual stacks used at the company?
- How do you use source control?
- How do you test code?
- How do you track bugs?
- How do you monitor projects?
- How do you integrate and deploy changes? Is it CI/CD?
- Is your infrastructure setup under version control / available as code?
- What's the workflow from the planning to the finished task?
- How do you prepare for disaster recovery?
- Is there a standardised development environment? Is it enforced?
- How quickly can you setup a new local test environment for the product? (minutes / hours / days)
- How quickly can you respond to security issues in the code or dependencies?
- Are all developers allowed to have local admin access of their computers?
- Tell me about your technical principles or vision.
- Do you have a developer documentation for your code? Do you have a separate documentation for customers?
- Do you have some higher level documentation? (ER diagrams, database schema)
- Do you employ static code analysis?
- How do you manage internal / external artifacts?
- How do you manage dependencies?

# The Team

- How is the work organised?
- How does the intra/inter-team communication typically work?
- Do you use any tools for project organization? What is your experience with them?
- How are differences of opinions resolved?
- Who sets the priorities / schedule?
- What happens after pushback? ("this can't be done in the projected time")
- What happens when the team misses a release target?
- What kind of meetings happen every week?
- Would there be a regular 1-on-1 with my manager?
- What's the product/service schedule? (n-weekly releases / continuous deployment / multiple release streams / ...)
- What happens after production incidents? Is there a culture of blameless analysis?
- What are some ongoing challenges the team is experiencing that you are yet to resolve?
- How do you track progress?
- How are expectations and goals set, and who does the setting?
- What does a code review look like here?
- Walk me through a typical sprint on this team
- How do you balance technical vs business goals?
- How do you share knowledge?
- How big are the teams?

# Your Potential Coworkers

- Who do developers tend to learn from?
- What do you like best about working there?
- What do you like least?
- What would you change if you could?
- How long has the longest team member been there?

# The Company

- Why is the company hiring? (product growth / new product / fluctuation / ...)
- Is there a conference/travel budget and what are the rules to use it?
- What's the promotion process? How are requirements / expectations communicated?
- What is the performance review process like?
- Is there a separate tech and management career path?
- Are there any company-wide resources for learning available, like ebooks subscriptions, or online courses?
- Is there a budget for getting certifications?
- What's the maturity stage? (early finding direction / feature work / maintenance / ...)
- Can I contribute to FOSS projects? Are there any approvals needed?
- Are there any non-compete or non-disclosure agreements I'll be asked to sign?
- Where do you see the company in the next 5/10 years? 
- What does clean code mean to the majority of developers here?
- When is the last time you noticed someone growing here, and in what way were they growing?
- What does it mean to be successful here, and how do you measure success?
- Is there a Sports / Team building Activity?
- Are there any Hackathons conducted internally?
- Does the company support open-source projects?

# Social issues

- What's the status of / view on diverse hiring?
- What do you think are the gaps in the company culture? (and what is the company culture?)
- What does work-life balance mean here?
- Does the company have a stance regarding climate change?

# Conflict

- How are differences of opinions resolved?
- What happens after pushback? ("this can't be done in the projected time")
- What happens when the team is under pressure and commits to work over their capacity / velocity?
- If someone identifies areas of improvement in process / technology / etc, what happens?
- When there is a gap between expectations from management and performance of an engineer or team, what happens?
- Could you tell me a story about a toxic situation and how the company dealt with it?

# The Business

- Are you profitable?
- If not, how long is your runway?
- Where does the funding come from and who influences the high level plan/direction?
- How do you make money?
- What's preventing you from making more money?
- What is the company's growth plan for the next 1 year? 5 years?
- What are the big challenges you see coming up?
- What have you identified as your competitive advantage?

# Remote Work

- What's the ratio of remote to office workers?
- Does the company provide hardware and what's the refresh schedule?
- How do you feel about [BYOD](https://en.wikipedia.org/wiki/Bring_your_own_device)? Are there any policies around it already?
- Are extra accessories/furniture possible to buy through the company? Is there a budget for them?
- Is there a budget for co-working space or internet access?
- How often are office visits expected?
- Are the office meeting rooms always prepared for video conferences?

# Building Layout

- What's the office layout? (open plan / cubicles / offices)
- Is there a support / marketing / other call-heavy team close to my new team?

# Catch all

- What's the best and what's the worst aspect of working in this role / team / company?
- What got you to choose to work for the company initially?
- What keeps you at the company?

# Compensation

- If you have a bonus scheme, then how are bonuses determined?
- If you have a bonus scheme, then what have been the typical bonus percentages over the past few years?
- Do you have a 401k or other retirement plan? If so, does the company match additional plan contributions?
- Are there medical benefits and if so, when do they start?
- Do you pay for relocation?

# Time Off

- How much Paid Time Off (PTO) is offered?
- Are sick time and vacation time separate or do they come from the same pool?
- Can I use vacation time before it's accrued, effectively going into a negative PTO balance?
- What is the roll over policy is there for PTO?
- What is the parental leave policy?
- What is the policy on unpaid leave?
- What is the policy for sabbatical leave?

# Other resources

Find more inspiration for questions in:

  - [The Joel Test: 12 Steps to Better Code](https://www.joelonsoftware.com/2000/08/09/the-joel-test-12-steps-to-better-code/) by Joel Spolsky
  - [Questions I'm asking in interviews](https://jvns.ca/blog/2013/12/30/questions-im-asking-in-interviews/) by Julia Evans

# License

[![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](https://creativecommons.org/licenses/by-sa/4.0/)

This work is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International License](https://creativecommons.org/licenses/by-sa/4.0/).
