# Classless CSS

This is a list of CSS themes and frameworks that do not require you to add their classes to your HTML elements.  It means you can quickly style a plain HTML page.  This is useful, for example, in prototyping.


## Contents

* [Classless](#classless)
  * [attriCSS](#attricss)
  * [axist](#axist)
  * [awsm.css](#awsmcss)
  * [Bahunya](#bahunya)
  * [BareCSS](#barecss)
  * [Basic.css](#basiccss)
  * [holiday.css](#holidaycss)
  * [LatexCSS](#latexcss)
  * [Markdown CSS](#markdown-css)
    * [Air](#air)
    * [Modest](#modest)
    * [Retro](#retro)
    * [Splendor](#splendor)
  * [Marx](#marx)
  * [MercuryCSS](#mercurycss)
  * [MVP.css](#mvpcss)
  * [new.css](#newcss)
  * [no-class.css](#no-classcss)
  * [ridge.css](#ridgecss)
  * [sakura](#sakura)
  * [SPCSS](#spcss)
  * [style.css](#stylecss)
  * [Stylize.css](#stylizecss)
  * [tacit](#tacit)
  * [Tufte CSS](#tufte-css)
  * [W3C Core Styles](#w3c-core-styles)
  * [water.css](#watercss)
  * [Writ](#writ)
  * [YoRHa](#yorha)
* [Class-light](#class-light)
  * [Chota](#chota)
  * [Classless.css](#classlesscss)
  * [concrete.css](#concretecss)
  * [Milligram](#milligram)
  * [mini.css](#minicss)
  * [Picnic CSS](#picnic-css)
  * [Wing](#wing)
* [See also](#see-also)
* [License](#license)


## Classless

### attriCSS

* [Repository](https://github.com/raj457036/attriCSS) ![GitHub stars](https://img.shields.io/github/stars/raj457036/attriCSS?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/raj457036/attriCSS?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/raj457036/attriCSS?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/raj457036/attriCSS?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/raj457036/attriCSS?style=flat-square)
* [Demo](https://raj457036.github.io/attriCSS/)

[![attricss-0-brightlight-green.png](thumbnail/attricss-0-brightlight-green.png)](screenshot/attricss-0-brightlight-green.png)
[![attricss-1-midnight-green.png](thumbnail/attricss-1-midnight-green.png)](screenshot/attricss-1-midnight-green.png)
[![attricss-2-darkforest-green.png](thumbnail/attricss-2-darkforest-green.png)](screenshot/attricss-2-darkforest-green.png)
[![attricss-3-darkfairy-pink.png](thumbnail/attricss-3-darkfairy-pink.png)](screenshot/attricss-3-darkfairy-pink.png)
[![attricss-4-lightfairy-pink.png](thumbnail/attricss-4-lightfairy-pink.png)](screenshot/attricss-4-lightfairy-pink.png)


### axist

* [Repository](https://github.com/ruanmartinelli/axist) ![GitHub stars](https://img.shields.io/github/stars/ruanmartinelli/axist?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/ruanmartinelli/axist?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/ruanmartinelli/axist?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/ruanmartinelli/axist?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/ruanmartinelli/axist?style=flat-square)
* [Demo](https://ruanmartinelli.github.io/axist/)

[![axist.png](thumbnail/axist.png)](screenshot/axist.png)


### awsm.css

* [Repository](https://github.com/igoradamenko/awsm.css) ![GitHub stars](https://img.shields.io/github/stars/igoradamenko/awsm.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/igoradamenko/awsm.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/igoradamenko/awsm.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/igoradamenko/awsm.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/igoradamenko/awsm.css?style=flat-square)
* [Demo](https://igoradamenko.github.io/awsm.css/elements.html)

[![awsm.css-0.png](thumbnail/awsm.css-0.png)](screenshot/awsm.css-0.png)
[![awsm.css-1-gondola.png](thumbnail/awsm.css-1-gondola.png)](screenshot/awsm.css-1-gondola.png)
[![awsm.css-2-mischka.png](thumbnail/awsm.css-2-mischka.png)](screenshot/awsm.css-2-mischka.png)
[![awsm.css-3-big-stone.png](thumbnail/awsm.css-3-big-stone.png)](screenshot/awsm.css-3-big-stone.png)
[![awsm.css-4-black.png](thumbnail/awsm.css-4-black.png)](screenshot/awsm.css-4-black.png)
[![awsm.css-5-tasman.png](thumbnail/awsm.css-5-tasman.png)](screenshot/awsm.css-5-tasman.png)
[![awsm.css-6-pastel-pink.png](thumbnail/awsm.css-6-pastel-pink.png)](screenshot/awsm.css-6-pastel-pink.png)
[![awsm.css-7-pearl-lusta.png](thumbnail/awsm.css-7-pearl-lusta.png)](screenshot/awsm.css-7-pearl-lusta.png)


### Bahunya

* [Repository](https://github.com/Kimeiga/bahunya) ![GitHub stars](https://img.shields.io/github/stars/Kimeiga/bahunya?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/Kimeiga/bahunya?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/Kimeiga/bahunya?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/Kimeiga/bahunya?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/Kimeiga/bahunya?style=flat-square)
* [Demo](https://kimeiga.github.io/bahunya/)

[![bahunya.png](thumbnail/bahunya.png)](screenshot/bahunya.png)


### BareCSS

* [Repository](https://github.com/longsien/BareCSS) ![GitHub stars](https://img.shields.io/github/stars/longsien/BareCSS?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/longsien/BareCSS?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/longsien/BareCSS?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/longsien/BareCSS?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/longsien/BareCSS?style=flat-square)
* [Demo (archived)](https://web.archive.org/web/20191010034508/http://barecss.com/)

[![barecss.png](thumbnail/barecss.png)](screenshot/barecss.png)


### Basic.css

* [Repository](https://github.com/vladocar/Basic.css) ![GitHub stars](https://img.shields.io/github/stars/vladocar/Basic.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/vladocar/Basic.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/vladocar/Basic.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/vladocar/Basic.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/vladocar/Basic.css?style=flat-square)
* [Demo](https://vladocar.github.io/Basic.css/)

[![basic.css.png](thumbnail/basic.css.png)](screenshot/basic.css.png)


### holiday.css

* [Repository](https://github.com/EvgenyOrekhov/holiday.css) ![GitHub stars](https://img.shields.io/github/stars/EvgenyOrekhov/holiday.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/EvgenyOrekhov/holiday.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/EvgenyOrekhov/holiday.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/EvgenyOrekhov/holiday.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/EvgenyOrekhov/holiday.css?style=flat-square)
* [Demo](https://holidaycss.js.org/)

[![holiday.css.png](thumbnail/holiday.css.png)](screenshot/holiday.css.png)


### LatexCSS

* [Repository](https://github.com/davidrzs/latexcss) ![GitHub stars](https://img.shields.io/github/stars/davidrzs/latexcss?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/davidrzs/latexcss?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/davidrzs/latexcss?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/davidrzs/latexcss?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/davidrzs/latexcss?style=flat-square)
* [Demo](https://davidrzs.github.io/latexcss/)

[![latex.png](thumbnail/latex.png)](screenshot/latex.png)


### Markdown CSS

#### Air

* [Repository](https://github.com/markdowncss/air) ![GitHub stars](https://img.shields.io/github/stars/markdowncss/air?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/markdowncss/air?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/markdowncss/air?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/markdowncss/air?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/markdowncss/air?style=flat-square)
* [Demo](https://markdowncss.github.io/air/)

[![markdowncss-air.png](thumbnail/markdowncss-air.png)](screenshot/markdowncss-air.png)


#### Modest

* [Repository](https://github.com/markdowncss/modest) ![GitHub stars](https://img.shields.io/github/stars/markdowncss/modest?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/markdowncss/modest?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/markdowncss/modest?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/markdowncss/modest?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/markdowncss/modest?style=flat-square)
* [Demo](https://markdowncss.github.io/modest/)

[![markdowncss-modest.png](thumbnail/markdowncss-modest.png)](screenshot/markdowncss-modest.png)


#### Retro

* [Repository](https://github.com/markdowncss/retro) ![GitHub stars](https://img.shields.io/github/stars/markdowncss/retro?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/markdowncss/retro?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/markdowncss/retro?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/markdowncss/retro?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/markdowncss/retro?style=flat-square)
* [Demo](https://markdowncss.github.io/retro/)

[![markdowncss-retro.png](thumbnail/markdowncss-retro.png)](screenshot/markdowncss-retro.png)


#### Splendor

* [Repository](https://github.com/markdowncss/splendor) ![GitHub stars](https://img.shields.io/github/stars/markdowncss/splendor?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/markdowncss/splendor?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/markdowncss/splendor?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/markdowncss/splendor?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/markdowncss/splendor?style=flat-square)
* [Demo](https://markdowncss.github.io/splendor/)

[![markdowncss-splendor.png](thumbnail/markdowncss-splendor.png)](screenshot/markdowncss-splendor.png)


### Marx

* [Repository](https://github.com/mblode/marx) ![GitHub stars](https://img.shields.io/github/stars/mblode/marx?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/mblode/marx?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/mblode/marx?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/mblode/marx?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/mblode/marx?style=flat-square)
* [Demo](https://codepen.io/mblode/details/JdYbJj)

[![marx.png](thumbnail/marx.png)](screenshot/marx.png)


### MercuryCSS

* [Repository](https://github.com/wmeredith/MercuryCSS) ![GitHub stars](https://img.shields.io/github/stars/wmeredith/MercuryCSS?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/wmeredith/MercuryCSS?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/wmeredith/MercuryCSS?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/wmeredith/MercuryCSS?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/wmeredith/MercuryCSS?style=flat-square)
* [Demo](https://wmeredith.github.io/MercuryCSS/)

[![mercurycss.png](thumbnail/mercurycss.png)](screenshot/mercurycss.png)


### MVP.css

* [Repository](https://github.com/andybrewer/mvp) ![GitHub stars](https://img.shields.io/github/stars/andybrewer/mvp?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/andybrewer/mvp?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/andybrewer/mvp?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/andybrewer/mvp?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/andybrewer/mvp?style=flat-square)
* [Demo](https://andybrewer.github.io/mvp/)

[![mvp.css.png](thumbnail/mvp.css.png)](screenshot/mvp.css.png)


### new.css

* [Repository](https://github.com/xz/new.css) ![GitHub stars](https://img.shields.io/github/stars/xz/new.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/xz/new.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/xz/new.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/xz/new.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/xz/new.css?style=flat-square)
* [Demo](https://newcss.net/demo/)

[![new.css.png](thumbnail/new.css.png)](screenshot/new.css.png)


### no-class.css

* [Repository](https://github.com/davidpaulsson/no-class) ![GitHub stars](https://img.shields.io/github/stars/davidpaulsson/no-class?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/davidpaulsson/no-class?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/davidpaulsson/no-class?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/davidpaulsson/no-class?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/davidpaulsson/no-class?style=flat-square)
* [Demo](https://davidpaulsson.se/no-class/)

[![no-class.css.png](thumbnail/no-class.css.png)](screenshot/no-class.css.png)


### ridge.css

* [Repository](https://github.com/swlkr/ridgecss) ![GitHub stars](https://img.shields.io/github/stars/swlkr/ridgecss?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/swlkr/ridgecss?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/swlkr/ridgecss?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/swlkr/ridgecss?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/swlkr/ridgecss?style=flat-square)
* [Demo](https://ridgecss.com/)

[![ridge.css-light.png](thumbnail/ridge.css-light.png)](screenshot/ridge.css-light.png)
[![ridge.css-dark.png](thumbnail/ridge.css-dark.png)](screenshot/ridge.css-dark.png)


### sakura

* [Repository](https://github.com/oxalorg/sakura) ![GitHub stars](https://img.shields.io/github/stars/oxalorg/sakura?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/oxalorg/sakura?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/oxalorg/sakura?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/oxalorg/sakura?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/oxalorg/sakura?style=flat-square)
* [Demo](https://oxal.org/projects/sakura/demo/)

[![sakura-normalize-0.png](thumbnail/sakura-normalize-0.png)](screenshot/sakura-normalize-0.png)
[![sakura-normalize-1-earthly.png](thumbnail/sakura-normalize-1-earthly.png)](screenshot/sakura-normalize-1-earthly.png)
[![sakura-normalize-2-vader.png](thumbnail/sakura-normalize-2-vader.png)](screenshot/sakura-normalize-2-vader.png)
[![sakura-normalize-3-dark.png](thumbnail/sakura-normalize-3-dark.png)](screenshot/sakura-normalize-3-dark.png)
[![sakura-normalize-4-dark-solarized.png](thumbnail/sakura-normalize-4-dark-solarized.png)](screenshot/sakura-normalize-4-dark-solarized.png)


### SPCSS

* [Repository](https://github.com/susam/spcss) ![GitHub stars](https://img.shields.io/github/stars/susam/spcss?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/susam/spcss?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/susam/spcss?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/susam/spcss?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/susam/spcss?style=flat-square)
* [Demo](https://susam.github.io/spcss/)

[![spcss.png](thumbnail/spcss.png)](screenshot/spcss.png)


### style.css

* [Repository](https://github.com/css-pkg/style.css) ![GitHub stars](https://img.shields.io/github/stars/css-pkg/style.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/css-pkg/style.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/css-pkg/style.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/css-pkg/style.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/css-pkg/style.css?style=flat-square)
* [Demo](https://css-pkg.github.io/style.css/)

[![style.css.png](thumbnail/style.css.png)](screenshot/style.css.png)


### Stylize.css

* [Repository](https://github.com/vasanthv/stylize.css) ![GitHub stars](https://img.shields.io/github/stars/vasanthv/stylize.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/vasanthv/stylize.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/vasanthv/stylize.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/vasanthv/stylize.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/vasanthv/stylize.css?style=flat-square)
* [Demo](https://vasanthv.github.io/stylize.css/demo.html)

[![stylize.css.png](thumbnail/stylize.css.png)](screenshot/stylize.css.png)


### tacit

* [Repository](https://github.com/yegor256/tacit) ![GitHub stars](https://img.shields.io/github/stars/yegor256/tacit?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/yegor256/tacit?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/yegor256/tacit?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/yegor256/tacit?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/yegor256/tacit?style=flat-square)
* [Demo](https://yegor256.github.io/tacit/)

[![tacit.png](thumbnail/tacit.png)](screenshot/tacit.png)


### Tufte CSS

* [Repository](https://github.com/edwardtufte/tufte-css) ![GitHub stars](https://img.shields.io/github/stars/edwardtufte/tufte-css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/edwardtufte/tufte-css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/edwardtufte/tufte-css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/edwardtufte/tufte-css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/edwardtufte/tufte-css?style=flat-square)
* [Demo](https://edwardtufte.github.io/tufte-css/)

[![tufte-css.png](thumbnail/tufte-css.png)](screenshot/tufte-css.png)


### W3C Core Styles

* [Website](https://www.w3.org/StyleSheets/Core/Overview)
* [Demo](https://www.w3.org/StyleSheets/Core/preview)

[![w3c-core-styles-0-oldstyle.png](thumbnail/w3c-core-styles-0-oldstyle.png)](screenshot/w3c-core-styles-0-oldstyle.png)
[![w3c-core-styles-1-modernist.png](thumbnail/w3c-core-styles-1-modernist.png)](screenshot/w3c-core-styles-1-modernist.png)
[![w3c-core-styles-2-midnight.png](thumbnail/w3c-core-styles-2-midnight.png)](screenshot/w3c-core-styles-2-midnight.png)
[![w3c-core-styles-3-ultramarine.png](thumbnail/w3c-core-styles-3-ultramarine.png)](screenshot/w3c-core-styles-3-ultramarine.png)
[![w3c-core-styles-4-swiss.png](thumbnail/w3c-core-styles-4-swiss.png)](screenshot/w3c-core-styles-4-swiss.png)
[![w3c-core-styles-5-chocolate.png](thumbnail/w3c-core-styles-5-chocolate.png)](screenshot/w3c-core-styles-5-chocolate.png)
[![w3c-core-styles-6-traditional.png](thumbnail/w3c-core-styles-6-traditional.png)](screenshot/w3c-core-styles-6-traditional.png)
[![w3c-core-styles-7-steely.png](thumbnail/w3c-core-styles-7-steely.png)](screenshot/w3c-core-styles-7-steely.png)


### water.css

* [Repository](https://github.com/kognise/water.css) ![GitHub stars](https://img.shields.io/github/stars/kognise/water.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/kognise/water.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/kognise/water.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/kognise/water.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/kognise/water.css?style=flat-square)
* [Demo](https://kognise.github.io/water.css/)

[![water.css-0-dark.png](thumbnail/water.css-0-dark.png)](screenshot/water.css-0-dark.png)
[![water.css-1-light.png](thumbnail/water.css-1-light.png)](screenshot/water.css-1-light.png)


### Writ

* [Repository](https://github.com/programble/writ) ![GitHub stars](https://img.shields.io/github/stars/programble/writ?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/programble/writ?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/programble/writ?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/programble/writ?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/programble/writ?style=flat-square)
* [Demo](https://writ.cmcenroe.me/)

[![writ.png](thumbnail/writ.png)](screenshot/writ.png)


### YoRHa

* [Repository](https://github.com/metakirby5/yorha) ![GitHub stars](https://img.shields.io/github/stars/metakirby5/yorha?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/metakirby5/yorha?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/metakirby5/yorha?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/metakirby5/yorha?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/metakirby5/yorha?style=flat-square)
* [Demo](https://metakirby5.github.io/yorha/)

[![yorha.png](thumbnail/yorha.png)](screenshot/yorha.png)


## Class-light

These are frameworks that do not force you to apply their classes to many elements but require something like `<div class="container">` or a bit of your own CSS for a page to look right.  They may offer optional classes to style your content.

### Chota

* [Repository](https://github.com/jenil/chota) ![GitHub stars](https://img.shields.io/github/stars/jenil/chota?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/jenil/chota?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/jenil/chota?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/jenil/chota?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/jenil/chota?style=flat-square)
* [Demo](https://jenil.github.io/chota/)

[![chota.png](thumbnail/chota.png)](screenshot/chota.png)


### Classless.css

* [Repository](https://github.com/emareg/classlesscss) ![GitHub stars](https://img.shields.io/github/stars/emareg/classlesscss?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/emareg/classlesscss?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/emareg/classlesscss?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/emareg/classlesscss?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/emareg/classlesscss?style=flat-square)
* [Demo](http://classless.de/)

[![classless.css.png](thumbnail/classless.css.png)](screenshot/classless.css.png)


### concrete.css

* [Repository](https://github.com/louismerlin/concrete.css) ![GitHub stars](https://img.shields.io/github/stars/louismerlin/concrete.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/louismerlin/concrete.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/louismerlin/concrete.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/louismerlin/concrete.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/louismerlin/concrete.css?style=flat-square)
* [Demo](https://concrete.style/)

[![concrete.css.png](thumbnail/concrete.css.png)](screenshot/concrete.css.png)


### Milligram

* [Repository](https://github.com/milligram/milligram) ![GitHub stars](https://img.shields.io/github/stars/milligram/milligram?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/milligram/milligram?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/milligram/milligram?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/milligram/milligram?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/milligram/milligram?style=flat-square)
* [Demo](https://milligram.io/)

[![milligram.png](thumbnail/milligram.png)](screenshot/milligram.png)


### mini.css

* [Repository](https://github.com/Chalarangelo/mini.css) ![GitHub stars](https://img.shields.io/github/stars/Chalarangelo/mini.css?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/Chalarangelo/mini.css?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/Chalarangelo/mini.css?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/Chalarangelo/mini.css?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/Chalarangelo/mini.css?style=flat-square)
* [Demo](https://minicss.org/docs)

[![minicss.png](thumbnail/minicss.png)](screenshot/minicss.png)


### Picnic CSS

* [Repository](https://github.com/franciscop/picnic) ![GitHub stars](https://img.shields.io/github/stars/franciscop/picnic?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/franciscop/picnic?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/franciscop/picnic?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/franciscop/picnic?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/franciscop/picnic?style=flat-square)
* [Demo](http://picnicss.com/)

[![picnic.png](thumbnail/picnic.png)](screenshot/picnic.png)


### Wing

* [Repository](https://github.com/kbrsh/wing) ![GitHub stars](https://img.shields.io/github/stars/kbrsh/wing?style=flat-square) ![GitHub contributors](https://img.shields.io/github/contributors-anon/kbrsh/wing?style=flat-square) ![Last commit](https://img.shields.io/github/last-commit/kbrsh/wing?style=flat-square) ![GitHub open issues](https://img.shields.io/github/issues-raw/kbrsh/wing?style=flat-square) ![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/kbrsh/wing?style=flat-square)
* [Demo](https://kbrsh.github.io/wing/)

[![wing.png](thumbnail/wing.png)](screenshot/wing.png)


## See also

* [Drop-in switcher for previewing minimal CSS frameworks](https://github.com/dohliam/dropin-minimal-css)


## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, dbohdan has waived all copyright and related or neighboring rights to this work.
