import xml.dom.minidom

class PeliculasXML:
    def __init__(self, strDoc):
        self.doc = xml.dom.minidom.parse(strDoc)
        self.pelis = self.doc.getElementsByTagName("pelicula")
        
    def __str__(self):
        return self.doc.toxml()
        
    def getPeli (self, idx):
        return Pelicula(self.pelis.item(idx))
        
    def numPelis(self):
        return len(self.pelis)

class Pelicula:
    def __init__(self, node):
        subnodes = node.childNodes
        str = ""
        i = 0
        while i < len(subnodes):
            if subnodes.item(i).nodeType == 1:
                if subnodes.item(i).nodeName == "puntuacion":
                    r = int(subnodes.item(i).childNodes.item(0).nodeValue)
                    str = str + (r * '*')
                else:
                    str = str + subnodes.item(i).childNodes.item(0).nodeValue
                str = str + ("\t" * 2)
            i = i + 1 
        self.Text = str
        
    def __str__ (self):
        return self.Text

doc = "prueba.xml"
pelis = PeliculasXML(doc)
print "NOMBRE\t\t\t\tANYO\t\tPUNTUACION";
for i in range(pelis.numPelis()):
    print pelis.getPeli(i)