from suppport import make_my_day
from fabric.api import run, env, put, get, local, execute

env.hosts = ['0.0.0.0']

def get_folder(folder, identifier):
	new_name = "{day!s}-{identifier!s}".format(day=make_my_day(), identifier=identifier)
	get(folder, new_name)
	return new_name

def compress (fname):
	ccommand = 'tar -zcvf {name!s}.tar.gz {name!s}'.format(name=fname)
	local(ccommand)

def remove (fname):
	local('rm -Rf ./{name!s}/'.format(name=fname))

def backup_folder (folder, identifier):
	fname = get_folder(folder, identifier)
	compress(fname)
	remove(fname)

def connect ():
	run('echo hi!')

def test ():
	tasks = [
		('alfred@192.168.1.20', 'Ingles:/home/alfred/Escritorio/Ingles', 'Ingles2:/home/alfred/Escritorio/Ingles2'),
		('alfred@192.168.1.10', 'Ing:/home/alfred/btsync_i386'),
		('alfred@192.168.1.106', 'Ing3:/home/alfred/Desktop/Illumination')
		]
	for task in tasks:
		execute (connect, hosts=[task[0]])
	for task in tasks:
		for subtask in task[1:]:
			args = subtask.split(':')
			folder = args[1]
			identifier = args[0]
			print task[0], folder, identifier
			execute(backup_folder, hosts=[task[0]], folder=folder, identifier=identifier)