
grammar GameLog;
 
options {
    language = Python;
}
 
tokens {
    WORLD = 'World';
    TEAM = 'Team';
    LOG = 'Log file';
    WITH = 'with';
    FWORD = 'RL';
    LPAREN = '(';
    RPAREN = ')';
    LESS = '<';
    GREAT = '>';
    RCONINI = 'rcon from';
    DOT = '.';
    TWOPOINTS = ':';
    EQUAL = '=';
    COMA = ',';
    STEAMDEF = 'STEAM_0:';
    COMS = '\"';
    REST = '-';
}
 
@header {
import sys
import traceback
 
from GameLogLexer import GameLogLexer
}

@init {
    self.line = {}
}
 
@rulecatch{
except RecognitionException, e: 
  print 'ERROR!!!!',
  raw_input()
}

@main {

def parseLine (line):
  s = line[38:]
  char_stream = ANTLRStringStream(s)
  lexer = GameLogLexer(char_stream)
  tokens = CommonTokenStream(lexer)
  parser = GameLogParser(tokens)
  return parser.logline()

def main(argv, otherArg=None):
  print '*' * 180
  f = open('test.txt')
  lines = f.readlines()
  f.close()
  for l in lines:
    print '-'*18
    print l.replace('\n','')
    print parseLine (l)
}
 
/*------------------------------------------------------------------
 * PARSER RULES
 *------------------------------------------------------------------*/

logline returns [val]
    : logbody {
            val = self.line
        }
    | EOF {
            val = None
        }
    ;

logbody 
    : globalmessage {
            self.line['type'] = u'globalmessage'
        }
    | playerinfo {
            self.line['type'] = u'playerinfo'
        }
    | vardef {
            self.line['type'] = u'vardef'
        }
    | logaction {
            self.line['type'] = u'logaction'
        }
    | rconcommand {
            self.line['type'] = u'rconcommand'
        }
    | no_treated {
            self.line['type'] = u'no_treated'
        }
    ;
 
globalmessage 
    : WORLD VERB value { 
            self.line['from'] = u'world'
            self.line['action'] = $VERB.text
            self.line['value'] = $value.text.replace('\"', '')
        }
    | TEAM identifier VERB value (.)* { 
            self.line['from'] = u'team'
            self.line['team'] = $identifier.value
            self.line['action'] = $VERB.text
            self.line['value'] = $value.text.replace('\"', '')
        }
    | GLOBALMSG value { 
            self.line['from'] = u'game'
            self.line['action'] = $GLOBALMSG.text
            self.line['value'] = $value.text.replace('\"', '')
        }
    ;

playerinfo 
    @init {
            self.line['parameters'] = {}
        }
    : p1=player VERB p2=player WITH value LPAREN ID RPAREN {
            self.line['player1'] = $p1.player
            self.line['player2'] = $p2.player
            self.line['action'] = $VERB.text
            self.line['object'] = $value.text.replace('\"', '')
            self.line['result'] = $ID.text
        }
    | p1=player VERB p2=player WITH value (parameter { self.line['parameters'][$parameter.name] = $parameter.value })* {
            self.line['player1'] = $p1.player
            self.line['player2'] = $p2.player
            self.line['action'] = $VERB.text
            self.line['object'] = $value.text.replace('\"', '')
            self.line['result'] = None
        }
    | player VERB WITH? id1=ID? (COMS val=(ID|(STRVALUE|WHITESPACE)*) COMS)? (parameter { self.line['parameters'][$parameter.name] = $parameter.value })* {
            self.line['player1'] = $player.player
            self.line['player2'] = None
            self.line['action'] = $VERB.text
            self.line['object'] = $id1.text if $id1 else None
            self.line['result'] = $val.text if $val else None
        }
    | player ID VERB {
            self.line['player1'] = $player.player
            self.line['player2'] = None
            self.line['action'] = 'validated'
            self.line['object'] = 'steam'
            self.line['result'] = None
        }
    | player VERB address {
            self.line['player1'] = $player.player
            self.line['player2'] = None
            self.line['action'] = $VERB.text
            self.line['object'] = $address.text
            self.line['result'] = None
        }
    ;

vardef
    @init {
            self.line['value'] = []
        }
    : v1=value EQUAL v2=value { 
            self.line['variable'] = $v1.text.replace('\"', '')
            self.line['value'] = $v2.text.replace('\"', '')
        }
    | ID TWOPOINTS (value {self.line['value'].append($value.text.replace('\"', ''))})+ { 
            self.line['variable'] = $ID.text
        }
    | ('server cvars start' | 'server cvars end') {
            self.line['variable'] = u'server'
            self.line['value'] = u'cvars'
        }
    ;

logaction
    : LOG VERB (parameter)* { 
            self.line['action'] = $VERB.text
        }
    ;

rconcommand
    : RCONINI address TWOPOINTS ID value { 
            self.line['from'] = $address.value
            self.line['object'] = $value.text.replace('\"', '')
        } 
    ;

no_treated
    : USELESS_MESSAGE STRVALUE
    ;

player returns [player]
    : COMS playername LESS STRVALUE GREAT (steamid | i1=identifier) i2=identifier COMS {
            $player = {}
            $player['name'] = $playername.text
            $player['team'] = $i2.value
            $player['steamid'] = $steamid.value
            $player['type'] = u'bot' if $i1.value == 'BOT' else 'unknown'
        }
    ;

steamid returns [value]
    : LESS STEAMDEF STRVALUE TWOPOINTS v=STRVALUE GREAT {
            $value = $v.text
        }
    ;

identifier returns [value]
    : LESS (ID)? GREAT {
            $value = $ID.text if $ID else None
        }
    | COMS ID COMS{
            $value = $ID.text
        }
    ;

parameter returns [name, value]
    : LPAREN STRVALUE v1=value RPAREN {
            $name = $STRVALUE.text
            $value = $v1.text.replace('\"', '')
        }
    ;

/*------------------------------------------------------------------
 * REVISAR ESTAS:
 *------------------------------------------------------------------*/
 
address returns [value]
    : COMS HOST COMS {
            $value = $HOST.text
        }
    ;

playername
    : (STRVALUE | COMS | WHITESPACE)*
    ;

value 
    : COMS (STRVALUE|WHITESPACE)* COMS
    ;

/*------------------------------------------------------------------
 * LEXER RULES
 *------------------------------------------------------------------*/

VERB : 'triggered' | 'closed' | 'started' | 'scored' | 'killed' | 'disconnected' | 'attacked' | 'entered' | 'joined' | 'connected, address' | 'validated' | 'say_team' | 'committed suicide' | 'say';

ID : 'CT' | 'T' | 'TERRORIST' | 'Unassigned' | 'headshot' | 'BOT' | 'server_cvar' | 'command' | 'the game' | 'team' | 'STEAM USERID' | 'Spectator' ;

GLOBALMSG : ('Loading map' | 'Started map')+ ;

HOST : NUMBER DOT NUMBER DOT NUMBER DOT NUMBER TWOPOINTS NUMBER ;

STRVALUE : ( 'a'..'z' | 'A'..'Z' | NUMBER | STRANGECHAR)*  ;

WHITESPACE : ( '\t' | ' ' | '\r' | '\n'| '\u000C' )+    { $channel = HIDDEN; } ;

USELESS_MESSAGE : 'Executing dedicated server config file ';

fragment DIGIT  : '0'..'9' ;
 
fragment NUMBER  : (DIGIT)+ ;

fragment STRANGECHAR : ( '/' | '.' | ',' | '_' | ';'  | '@' | REST)+ ;
