/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation.timer;

import org.antlr.xjlib.foundation.timer.XJScheduledTimerDelegate;

public class XJScheduledTimer {
    protected XJScheduledTimerDelegate delegate;
    protected long numberOfMinutes;
    protected long remainingMinutes;
    protected boolean scheduleAtStartup;

    public XJScheduledTimer(XJScheduledTimerDelegate delegate, long minutes, boolean scheduleAtStartup) {
        this.delegate = delegate;
        this.numberOfMinutes = minutes;
        this.scheduleAtStartup = scheduleAtStartup;
        this.remainingMinutes = this.numberOfMinutes;
    }

    public XJScheduledTimerDelegate getDelegate() {
        return this.delegate;
    }

    public void fire(boolean startup, long elapsedMinutes) {
        if (this.scheduleAtStartup && startup) {
            this.delegate.scheduledTimerFired(true);
            return;
        }
        if (!this.scheduleAtStartup && startup) {
            return;
        }
        this.remainingMinutes -= elapsedMinutes;
        if (this.remainingMinutes <= 0L) {
            this.delegate.scheduledTimerFired(false);
            this.remainingMinutes = this.numberOfMinutes;
        }
    }
}

