/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XJObject {
    private List<Object> observers = new ArrayList<Object>();
    private Map<Object, List<Object>> keyObservers = new HashMap<Object, List<Object>>();

    public void awake() {
    }

    public void addObserver(Object o) {
        this.observers.add(o);
    }

    public void removeObserver(Object o) {
        this.observers.remove(o);
    }

    public void addObserverForKey(Object o, String key) {
        List<Object> list = this.keyObservers.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            this.keyObservers.put(key, list);
        }
        list.add(o);
    }

    public void removeObserverForKey(Object o, String key) {
        List<Object> list = this.keyObservers.get(key);
        if (list == null) {
            return;
        }
        list.remove(o);
    }

    public void bindObserverForKey(XJObject o, String key) {
        this.addObserverForKey(o, key);
        o.addObserverForKey(this, key);
    }

    public void keyValueChanged(Object sender, String key, Object value) {
        this.keyValueChangedToObservers(this.observers, sender, key, value);
        this.keyValueChangedToObservers(this.keyObservers.get(key), sender, key, value);
    }

    private void keyValueChangedToObservers(List observers, Object sender, String key, Object value) {
        if (observers == null) {
            return;
        }
        for (Object observer : observers) {
            if (observer == sender) continue;
            try {
                XJObject object = (XJObject)observer;
                object.observeValueForKey(sender, key, value);
            }
            catch (Exception e) {
                try {
                    Method m = observer.getClass().getMethod("observeValueForKey", Object.class, String.class, Object.class);
                    m.invoke(observer, sender, key, value);
                }
                catch (Exception e2) {}
            }
        }
    }

    public void observeValueForKey(Object sender, String key, Object value) {
    }
}

