/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.xjlib.appkit.frame.XJDialog;

public class XJColorChooser
extends XJDialog {
    JColorChooser cc;
    JPanel targetPanel;
    Color oldTargetColor = Color.black;

    public XJColorChooser(Container owner, boolean modal) {
        this(owner, modal, null);
    }

    public XJColorChooser(Container owner, boolean modal, JPanel targetPanel) {
        super(owner, modal);
        this.setTitle("Choose a color");
        this.setSize(500, 400);
        if (targetPanel != null) {
            this.targetPanel = targetPanel;
            this.oldTargetColor = targetPanel.getBackground();
        }
        this.cc = new JColorChooser(this.oldTargetColor);
        this.cc.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                XJColorChooser.this.updateTargetColor();
            }
        });
        this.getContentPane().add((Component)this.cc, "Center");
        JButton cancel = new JButton("Cancel");
        this.setCancelButton(cancel);
        JButton ok = new JButton("OK");
        this.setOKButton(ok);
        this.setDefaultButton(ok);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(cancel);
        box.add(ok);
        box.add(Box.createHorizontalStrut(15));
        this.getContentPane().add((Component)box, "South");
    }

    protected void updateTargetColor() {
        this.updateTargetColor(this.cc.getColor());
    }

    protected void updateTargetColor(Color c) {
        if (this.targetPanel != null) {
            this.targetPanel.setBackground(c);
        }
    }

    public void dialogWillCloseCancel() {
        this.updateTargetColor(this.oldTargetColor);
    }

    public void dialogWillCloseOK() {
        this.updateTargetColor();
    }

    public Color getColor() {
        return this.cc.getColor();
    }
}

