/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SArrow;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public abstract class SLink
implements XJXMLSerializable {
    protected Vector2D start;
    protected Vector2D end;
    protected Vector2D startDirection;
    protected Vector2D endDirection;
    protected Vector2D startOffset;
    protected Vector2D endOffset;
    protected double startTangentOffset;
    protected double endTangentOffset;
    protected Vector2D direction;
    protected double flateness;
    protected SArrow arrow = new SArrow();
    protected SLabel label = new SLabel();
    protected boolean selfLoop = false;
    protected boolean arrowVisible = true;
    protected Color color = Color.black;
    protected transient Vector2D startWithOffset = null;
    protected transient Vector2D endWithOffset = null;

    public void setStartAnchor(Anchor2D anchor) {
        this.setStart(anchor.position);
        this.setStartDirection(anchor.direction);
    }

    public void setEndAnchor(Anchor2D anchor) {
        this.setEnd(anchor.position);
        this.setEndDirection(anchor.direction);
    }

    public void setStart(Vector2D start) {
        this.start = start.copy();
        this.computeOffsets();
    }

    public void setStart(double x, double y) {
        this.setStart(new Vector2D(x, y));
    }

    public Vector2D getStart() {
        return this.start;
    }

    public void setEnd(Vector2D end) {
        this.end = end.copy();
        this.computeOffsets();
    }

    public void setEnd(double x, double y) {
        this.setEnd(new Vector2D(x, y));
    }

    public void setEnd(Point p) {
        this.end = Vector2D.vector(p);
    }

    public Vector2D getEnd() {
        return this.end;
    }

    public void setDirection(Vector2D direction) {
        this.direction = direction;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public void setFlateness(double flatness) {
        this.flateness = flatness;
    }

    public double getFlateness() {
        return this.flateness;
    }

    public void setStartDirection(Vector2D direction) {
        this.startDirection = direction;
    }

    public Vector2D getStartDirection() {
        return this.startDirection;
    }

    public void setEndDirection(Vector2D direction) {
        this.endDirection = direction;
    }

    public Vector2D getEndDirection() {
        return this.endDirection;
    }

    public void setStartTangentOffset(double offset) {
        this.startTangentOffset = offset;
    }

    public double getStartTangentOffset() {
        return this.startTangentOffset;
    }

    public void setEndTangentOffset(double offset) {
        this.endTangentOffset = offset;
    }

    public double getEndTangentOffset() {
        return this.endTangentOffset;
    }

    public void setStartOffset(Vector2D offset) {
        this.startOffset = offset;
        this.computeOffsets();
    }

    public Vector2D getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(Vector2D offset) {
        this.endOffset = offset;
        this.computeOffsets();
    }

    public Vector2D getEndOffset() {
        return this.endOffset;
    }

    public void computeOffsets() {
        this.startWithOffset = this.start;
        this.endWithOffset = this.end;
        if (this.start != null && this.startOffset != null) {
            this.startWithOffset = this.start.add(this.startOffset);
        }
        if (this.end != null && this.endOffset != null) {
            this.endWithOffset = this.end.add(this.endOffset);
        }
    }

    public Vector2D getStartWithOffset() {
        return this.startWithOffset;
    }

    public Vector2D getEndWithOffset() {
        return this.endWithOffset;
    }

    public void setArrow(SArrow arrow) {
        this.arrow = arrow;
    }

    public SArrow getArrow() {
        return this.arrow;
    }

    public void setArrowVisible(boolean flag) {
        this.arrowVisible = flag;
    }

    public void setLabel(String label) {
        this.label.setTitle(label);
    }

    public void setLabel(SLabel label) {
        this.label = label;
    }

    public SLabel getLabel() {
        return this.label;
    }

    public void setSelfLoop(boolean selfLoop) {
        this.selfLoop = selfLoop;
    }

    public boolean isSelfLoop() {
        return this.selfLoop;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLabelColor(Color color) {
        this.label.setColor(color);
    }

    public void setLabelVisible(boolean flag) {
        this.label.setVisible(flag);
    }

    public boolean isLabelVisible() {
        return this.label.isVisible();
    }

    public Rect getFrame() {
        return new Rect(this.start, this.end);
    }

    public void setMousePosition(Vector2D position) {
    }

    public abstract boolean contains(double var1, double var3);

    public abstract void update();

    public abstract void draw(Graphics2D var1);

    public abstract void drawShape(Graphics2D var1);
}

