/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.path.GPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPath
extends GObject {
    public static int MIN_PATH_BLINK_WIDTH = 2;
    public static int MAX_PATH_BLINK_WIDTH = 4;
    protected List<GPathElement> elements;
    protected boolean disabled = false;
    protected boolean visible = false;
    protected boolean selectable = true;
    protected int currentIndex = -1;
    protected float step = 0.2f;
    protected float currentLineWidth = 1.0f;
    protected boolean showRuleLinks = true;

    public GPath() {
    }

    public GPath(List<GPathElement> elements, boolean disabled) {
        this.elements = elements;
        this.disabled = disabled;
    }

    @Override
    public void setContext(GContext context) {
        super.setContext(context);
        for (GPathElement element : this.elements) {
            element.setContext(context);
        }
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSelectable(boolean flag) {
        this.selectable = flag;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setShowRuleLinks(boolean flag) {
        this.showRuleLinks = flag;
    }

    public int getNumberOfVisibleElements() {
        int count = 0;
        for (GPathElement element : this.elements) {
            if (!element.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void draw(float width, List ignoreElements) {
        if (this.showRuleLinks) {
            this.drawElements(width, ignoreElements, true);
        }
        this.drawElements(width, ignoreElements, false);
    }

    public void drawElements(float width, List ignoreElements, boolean ruleLink) {
        this.context.linkColor = this.context.nodeColor = this.disabled ? Color.red : Color.green.darker();
        this.context.setLineWidth(width);
        for (GPathElement element : this.elements) {
            if (ignoreElements != null && ignoreElements.contains(element) || !element.isVisible() || element.isRuleLink && !ruleLink || ruleLink && !element.isRuleLink) continue;
            element.draw();
        }
    }

    public void drawSelectedElement() {
        if (this.currentIndex == -1) {
            return;
        }
        this.context.linkColor = this.context.nodeColor = this.disabled ? Color.red : Color.green.darker();
        this.context.setLineWidth(this.currentLineWidth);
        GPathElement element = this.elements.get(this.currentIndex);
        element.draw();
    }

    public Rectangle getBoundsOfSelectedElement() {
        if (this.currentIndex == -1) {
            return null;
        }
        GPathElement element = this.elements.get(this.currentIndex);
        return element.getBounds();
    }

    @Override
    public boolean containsPoint(Point p) {
        for (GPathElement element : this.elements) {
            if (!element.containsPoint(p)) continue;
            return true;
        }
        return false;
    }

    public Set<GObject> getObjects() {
        HashSet<GObject> objects = new HashSet<GObject>();
        for (GPathElement element : this.elements) {
            objects.addAll(element.getObjects());
        }
        return objects;
    }

    public boolean isCurrentElementVisible() {
        GPathElement element = this.elements.get(this.currentIndex);
        if (element.isRuleLink) {
            return this.showRuleLinks;
        }
        return element.isVisible();
    }

    public void setMaxWidth() {
        this.currentLineWidth = MAX_PATH_BLINK_WIDTH;
    }

    public void setMinWidth() {
        this.currentLineWidth = MIN_PATH_BLINK_WIDTH;
    }

    public void incrementWidth() {
        this.currentLineWidth += this.step;
        if (this.currentLineWidth >= (float)MAX_PATH_BLINK_WIDTH || this.currentLineWidth <= (float)MIN_PATH_BLINK_WIDTH) {
            this.step = -this.step;
        }
    }

    public void selectElement() {
        if (this.currentIndex == -1) {
            this.nextElement();
        }
    }

    public void deselectElement() {
        this.currentIndex = -1;
    }

    public void nextElement() {
        if (this.elements.isEmpty()) {
            this.currentIndex = -1;
            return;
        }
        int looping = this.currentIndex;
        do {
            ++this.currentIndex;
            if (this.currentIndex >= this.elements.size()) {
                this.currentIndex = 0;
            }
            if (looping == -1) {
                looping = 0;
                continue;
            }
            if (looping == this.currentIndex) break;
        } while (!this.isCurrentElementVisible());
        this.currentLineWidth = 3.0f;
        this.context.repaint();
    }

    public void previousElement() {
        if (this.elements.isEmpty()) {
            this.currentIndex = -1;
            return;
        }
        int looping = this.currentIndex;
        do {
            --this.currentIndex;
            if (this.currentIndex < 0) {
                this.currentIndex = this.elements.size() - 1;
            }
            if (looping == -1) {
                looping = 0;
                continue;
            }
            if (looping == this.currentIndex) break;
        } while (!this.isCurrentElementVisible());
        this.currentLineWidth = 3.0f;
        this.context.repaint();
    }

    public void firstElement() {
        this.currentIndex = -1;
        this.nextElement();
    }

    public void lastElement() {
        this.currentIndex = this.elements.size();
        this.previousElement();
    }
}

