/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.antlr.analysis.NFAState;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.visualization.SyntaxDiagramTab;
import org.antlr.works.visualization.graphics.GFactory;

public class VisualDrawing
extends ATEThread {
    protected SyntaxDiagramTab syntaxDiagramTab;
    protected GFactory factory = new GFactory();
    protected String text;
    protected ElementRule rule;
    protected String threadText;
    protected ElementRule threadRule;
    protected ElementRule threadLastProcessedRule;
    protected Map<ElementRule, List> cacheGraphs = new HashMap<ElementRule, List>();

    public VisualDrawing(SyntaxDiagramTab syntaxDiagramTab) {
        this.syntaxDiagramTab = syntaxDiagramTab;
        this.start();
    }

    public void stop() {
        super.stop();
        this.syntaxDiagramTab = null;
    }

    public void toggleNFAOptimization() {
        this.factory.toggleNFAOptimization();
        this.clearCacheGraphs();
    }

    public synchronized void setText(String text) {
        this.text = text;
        this.awakeThread(500);
    }

    public synchronized void setRule(ElementRule rule, boolean immediate) {
        this.rule = rule;
        this.awakeThread(immediate ? 0 : 500);
    }

    public synchronized void clearCacheGraphs() {
        this.cacheGraphs.clear();
    }

    public synchronized boolean refresh() {
        final List graphs = this.cacheGraphs.get(this.threadLastProcessedRule);
        if (graphs == null || graphs.isEmpty()) {
            return false;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualDrawing.this.refreshVisualPanel(graphs);
                }
            });
        } else {
            this.refreshVisualPanel(graphs);
        }
        return true;
    }

    private void refreshVisualPanel(List graphs) {
        this.syntaxDiagramTab.panel.setRule(this.threadLastProcessedRule);
        this.syntaxDiagramTab.panel.setGraphs(graphs);
        this.syntaxDiagramTab.panel.update();
    }

    public synchronized boolean threadShouldProcess() {
        return this.text != null || this.rule != null;
    }

    public synchronized void threadPrepareProcess() {
        this.threadText = this.text;
        this.threadRule = this.rule;
        this.text = null;
        this.rule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadProcessText() {
        if (this.threadText == null) {
            return;
        }
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        try {
            this.syntaxDiagramTab.getEngineGrammar().createGrammars();
        }
        catch (Exception exception) {
        }
        finally {
            this.clearCacheGraphs();
        }
    }

    private void threadProcessRule() throws Exception {
        if (this.threadRule == null) {
            return;
        }
        String error = null;
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        if (this.syntaxDiagramTab.getEngineGrammar().hasGrammar()) {
            NFAState startState = null;
            try {
                startState = this.syntaxDiagramTab.getEngineGrammar().getRuleStartState(this.threadRule.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (startState == null) {
                error = "Cannot display rule \"" + this.threadRule + "\" because start state not found";
            }
        } else {
            error = "Cannot display rule \"" + this.threadRule + "\" because grammar could not be generated";
        }
        if (error != null) {
            this.syntaxDiagramTab.setPlaceholder(error);
            return;
        }
        this.createGraphsForRule(this.threadRule);
        this.threadLastProcessedRule = this.threadRule;
        this.refresh();
    }

    protected synchronized void createGraphsForRule(ElementRule rule) throws Exception {
        List graphs = this.cacheGraphs.get(rule);
        if (graphs == null) {
            this.factory.setOptimize(!AWPrefs.getDebugDontOptimizeNFA());
            this.factory.setConsole(this.syntaxDiagramTab.getConsole());
            graphs = this.factory.buildGraphsForRule(this.syntaxDiagramTab.getEngineGrammar(), rule.name, rule.errors);
            if (graphs != null) {
                this.cacheGraphs.put(rule, graphs);
            }
        }
    }

    public void threadReportException(Exception e) {
        this.syntaxDiagramTab.getConsole().println(e);
    }

    public void threadRun() throws Exception {
        this.syntaxDiagramTab.getConsole().setMode(2);
        if (this.threadShouldProcess()) {
            this.threadPrepareProcess();
            this.threadProcessText();
            this.threadProcessRule();
        }
    }
}

