/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.List;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.RulesDependency;
import org.antlr.works.grammar.TokensDFA;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.decisiondfa.DecisionDFA;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;

public class GrammarMenu
implements CheckGrammarDelegate,
XJDialogProgressDelegate {
    private final GrammarWindow window;
    private CheckGrammar checkGrammar;
    private boolean checkingGrammar;

    public GrammarMenu(GrammarWindow window) {
        this.window = window;
    }

    public void showTokensSD() {
        StatisticsAW.shared().recordEvent(40);
        this.window.syntaxDiagramTab.setRule(new ElementRule("Tokens"), true);
    }

    public void showTokensDFA() {
        StatisticsAW.shared().recordEvent(41);
        TokensDFA decision = new TokensDFA(this.window);
        decision.launch();
    }

    public void showDecisionDFA() {
        DecisionDFA decision = new DecisionDFA(this.window);
        decision.launch();
    }

    public void highlightDecisionDFA() {
        StatisticsAW.shared().recordEvent(42);
        try {
            if (this.window.decisionDFAEngine.getDecisionDFACount() == 0) {
                this.window.decisionDFAEngine.discoverAllDecisions();
            } else {
                this.window.decisionDFAEngine.reset();
            }
            this.window.decisionDFAEngine.refresh();
            this.window.decisionDFAEngine.refreshMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.window.getJavaContainer(), "Error", "Cannot show the DFA:\n" + e.toString());
        }
    }

    public void showDependency() {
        StatisticsAW.shared().recordEvent(44);
        RulesDependency dependency = new RulesDependency(this.window);
        dependency.launch();
    }

    public void group() {
        List<ElementRule> rules;
        StatisticsAW.shared().recordEvent(45);
        String s = (String)JOptionPane.showInputDialog(this.window.getJavaContainer(), "Group Name:", "Group", 3, null, null, "Group");
        if (s != null && s.length() > 0 && !(rules = this.window.editorRules.getSelectedRules()).isEmpty()) {
            this.window.beginGroupChange("Group");
            ElementRule firstRule = rules.get(0);
            ElementRule lastRule = rules.get(rules.size() - 1);
            int end = lastRule.getEndIndex();
            this.window.getTextEditor().insertText(end + 1, "\n// $>\n");
            int start = firstRule.getStartIndex();
            this.window.getTextEditor().insertText(start - 1, "\n// $<" + s + "\n");
            this.window.endGroupChange();
        }
    }

    public void ungroup() {
        ATEToken t;
        StatisticsAW.shared().recordEvent(46);
        ElementGroup openGroup = this.window.editorRules.getSelectedGroup();
        if (openGroup == null && (openGroup = this.window.editorRules.findOpenGroupClosestToLocation(this.window.getTextPane().getSelectionStart())) == null) {
            XJAlert.display(this.window.getJavaContainer(), "Ungroup", "Cannot ungroup because no enclosing group has been found.");
            return;
        }
        ElementGroup closingGroup = this.window.editorRules.findClosingGroupForGroup(openGroup);
        this.window.beginGroupChange("Ungroup");
        if (closingGroup != null) {
            t = closingGroup.token;
            this.window.replaceText(t.getStartIndex() - 1, t.getEndIndex(), "");
        }
        t = openGroup.token;
        this.window.replaceText(t.getStartIndex() - 1, t.getEndIndex(), "");
        this.window.endGroupChange();
    }

    public void ignore() {
        this.window.editorRules.ignoreSelectedRules(true);
    }

    public void consider() {
        this.window.editorRules.ignoreSelectedRules(false);
    }

    public void checkGrammar() {
        this.window.showProgress("Checking Grammar...", this);
        if (AWPrefs.isClearConsoleBeforeCheckGrammar()) {
            this.window.consoleTab.clear();
        }
        this.window.saveAll();
        this.window.consoleTab.makeCurrent();
        this.window.consoleTab.println("Checking Grammar " + this.window.getGrammarFileName() + "...");
        this.checkGrammar = new CheckGrammar(this.window, this);
        this.checkGrammar.check();
        StatisticsAW.shared().recordEvent(47);
    }

    public void checkGrammarDidBegin(CheckGrammar source) {
        this.checkingGrammar = true;
    }

    public void checkGrammarDidEnd(CheckGrammar source, GrammarResult result) {
        this.checkGrammar.close();
        this.checkGrammar = null;
        this.checkingGrammar = false;
        this.window.hideProgress();
        if (result.isSuccess()) {
            if (AWPrefs.isAlertCheckGrammarSuccess()) {
                XJAlert alert = XJAlert.createInstance();
                alert.setDisplayDoNotShowAgainButton(true);
                alert.showSimple(this.window.getJavaContainer(), "Success", "Check Grammar succeeded.");
                AWPrefs.setAlertCheckGrammarSuccess(!alert.isDoNotShowAgain());
            }
        } else if (result.getErrorCount() > 0) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "Check Grammar reported some errors:\n" + result.getFirstErrorMessage() + "\nConsult the console for more information.");
        } else if (result.getWarningCount() > 0) {
            XJAlert.display(this.window.getJavaContainer(), "Warning", "Check Grammar reported some warnings:\n" + result.getFirstWarningMessage() + "\nConsult the console for more information.");
        } else {
            XJAlert.display(this.window.getJavaContainer(), "Error", "Check Grammar reported some errors.\nConsult the console for more information.");
        }
    }

    public void dialogDidCancel() {
        if (this.checkingGrammar) {
            this.checkGrammar.cancel();
            this.checkGrammar.close();
            this.checkGrammar = null;
        }
    }
}

