/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.Set;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.menu.GoToMenuDelegate;
import org.antlr.works.stats.StatisticsAW;

public class GoToMenu {
    private final GoToMenuDelegate delegate;

    public GoToMenu(GoToMenuDelegate delegate) {
        this.delegate = delegate;
    }

    public void goToRule() {
        StatisticsAW.shared().recordEvent(20);
        this.delegate.getGoToRule().display();
    }

    public void goToDeclaration() {
        this.delegate.goToDeclaration();
    }

    public void goToDeclaration(Jumpable ref) {
        StatisticsAW.shared().recordEvent(21);
        this.delegate.goToDeclaration(ref);
    }

    public void goToBreakpoint(int direction) {
        if (direction == -1) {
            StatisticsAW.shared().recordEvent(26);
        } else {
            StatisticsAW.shared().recordEvent(27);
        }
        Set<Integer> breakpoints = this.delegate.getBreakpoints();
        int line = this.delegate.getTextEditor().getLineIndexAtTextPosition(this.delegate.getCaretPosition());
        if (line == -1) {
            return;
        }
        while ((line += direction) >= 0 && line <= this.delegate.getGrammarEngine().getNumberOfLines() - 1) {
            if (!breakpoints.contains(line)) continue;
            this.moveCursorToLine(line);
            break;
        }
    }

    public void goToLine() {
        StatisticsAW.shared().recordEvent(22);
        String s = (String)JOptionPane.showInputDialog(this.delegate.getJavaContainer(), "Line number:", "Go To Line", 3, null, null, null);
        if (s != null) {
            this.moveCursorToLine(Integer.parseInt(s) - 1);
        }
    }

    public void goToCharacter() {
        StatisticsAW.shared().recordEvent(23);
        String s = (String)JOptionPane.showInputDialog(this.delegate.getJavaContainer(), "Character number:", "Go To Character", 3, null, null, null);
        if (s != null) {
            int character = Integer.parseInt(s);
            if (character < 0 || character > this.delegate.getTextPane().getDocument().getLength() - 1) {
                return;
            }
            this.delegate.goToHistoryRememberCurrentPosition();
            this.delegate.setCaretPosition(character);
        }
    }

    public void goToBackward() {
        this.delegate.goToBackward();
    }

    public void goToForward() {
        this.delegate.goToForward();
    }

    public void moveCursorToLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex > this.delegate.getLines().size() - 1) {
            return;
        }
        ATELine line = this.delegate.getLines().get(lineIndex);
        this.delegate.goToHistoryRememberCurrentPosition();
        this.delegate.setCaretPosition(line.position);
    }
}

