/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.antlr.works.editor.completion.AutoCompletionMenuDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionMenu
extends OverlayObject {
    protected AutoCompletionMenuDelegate delegate;
    protected DefaultListModel listModel;
    protected JList list;
    protected List<String> words;
    protected static List<String> recentlyUsedWords = new LinkedList<String>();
    protected int maxWordLength;
    protected int insertionStartIndex;
    protected int insertionEndIndex;
    protected int displayIndex;
    public static int visibleMatchingRules = 15;

    public AutoCompletionMenu(AutoCompletionMenuDelegate delegate, JTextComponent textComponent, XJFrame frame) {
        super(frame, textComponent);
        this.delegate = delegate;
    }

    @Override
    public void close() {
        super.close();
        this.delegate = null;
    }

    public boolean isVStyle() {
        return AWPrefs.isVStyleAutoCompletion();
    }

    public JTextComponent getTextComponent() {
        return (JTextComponent)this.parentComponent;
    }

    @Override
    public JComponent overlayCreateInterface() {
        visibleMatchingRules = this.isVStyle() ? 7 : 15;
        this.getTextComponent().addKeyListener(new MyKeyAdapter());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel){

            public int getVisibleRowCount() {
                return Math.min(AutoCompletionMenu.this.listModel.getSize(), visibleMatchingRules);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setBackground(new Color(235, 244, 254));
        this.list.addKeyListener(new MyKeyAdapter());
        this.list.setPrototypeCellValue("This is a rule name g");
        this.list.addMouseListener(new ListMouseAdapter());
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 31);
        scrollPane.setBorder(BorderFactory.createBevelBorder(0));
        return scrollPane;
    }

    @Override
    public boolean overlayWillDisplay() {
        if (this.isVStyle()) {
            int index = this.getTextComponent().getCaretPosition() + 1;
            String partialWord = "";
            this.setInsertionStartIndex(index);
            this.setInsertionEndIndex(index);
            List<String> matchingRules = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(partialWord);
            if (matchingRules.size() == 0) {
                return false;
            }
            this.list.setFont(new Font(AWPrefs.getEditorFont(), 0, 12));
            this.list.setAutoscrolls(true);
            this.setDisplayIndex(index);
            this.setWordLists(matchingRules, matchingRules);
            this.delegate.autoCompletionMenuWillDisplay();
            this.selectMostRecentlyUsedWordPosition(partialWord, matchingRules.get(0));
            return true;
        }
        int position = this.getTextComponent().getCaretPosition();
        int index = this.getPartialWordBeginsAtPosition(position);
        String partialWord = "";
        if (index < position) {
            partialWord = this.getTextComponent().getText().substring(index + 1, position);
        }
        this.setInsertionStartIndex(index + 1);
        this.setInsertionEndIndex(position);
        List<String> matchingRules = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(partialWord);
        if (matchingRules.size() == 0) {
            return false;
        }
        if (matchingRules.size() == 1) {
            this.completePartialWord(matchingRules.get(0));
            return false;
        }
        this.list.setFont(new Font(AWPrefs.getEditorFont(), 0, 12));
        this.list.setAutoscrolls(true);
        this.setDisplayIndex(index + 1);
        this.setWordLists(matchingRules, matchingRules);
        this.delegate.autoCompletionMenuWillDisplay();
        return true;
    }

    @Override
    public KeyStroke overlayDisplayKeyStroke() {
        if (this.isVStyle()) {
            return KeyStroke.getKeyStroke(32, 0);
        }
        return KeyStroke.getKeyStroke(32, 2);
    }

    @Override
    public String overlayDisplayKeyStrokeMappingName() {
        return "controlEspace";
    }

    public void setWordLists(List<String> names, List<String> words) {
        this.listModel.clear();
        for (String name : names) {
            this.listModel.addElement(name);
        }
        this.words = words;
        this.maxWordLength = 0;
        for (String word : words) {
            this.maxWordLength = Math.max(this.maxWordLength, word.length());
        }
    }

    public void setInsertionStartIndex(int startIndex) {
        this.insertionStartIndex = startIndex;
    }

    public void setInsertionEndIndex(int endIndex) {
        this.insertionEndIndex = endIndex;
    }

    public void setDisplayIndex(int index) {
        this.displayIndex = index;
    }

    public static boolean isCharIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isAlphaNumericOr_(int keyCode) {
        return keyCode >= 65 && keyCode <= 90 || keyCode == 45;
    }

    private static boolean isFunctionKey(int keyCode) {
        return keyCode >= 16 && keyCode <= 18 || keyCode == 20;
    }

    public int getPartialWordBeginsAtPosition(int pos) {
        int index;
        String t = this.getTextComponent().getText();
        for (index = pos - 1; index >= 0 && AutoCompletionMenu.isCharIdentifier(t.charAt(index)); --index) {
        }
        return index;
    }

    public void completePartialWord(String word) {
        try {
            Document doc = this.getTextComponent().getDocument();
            doc.remove(this.insertionStartIndex, this.insertionEndIndex - this.insertionStartIndex);
            doc.insertString(this.insertionStartIndex, word, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void autoComplete() {
        if (this.list.getSelectedIndex() >= 0) {
            String partialWord = this.words.get(this.list.getSelectedIndex());
            if (this.isVStyle()) {
                recentlyUsedWords.remove(partialWord);
                ((LinkedList)recentlyUsedWords).addFirst(partialWord);
            }
            this.completePartialWord(partialWord);
        }
    }

    @Override
    public void resize() {
        Rectangle rect = null;
        StatisticsAW.shared().recordEvent(133);
        try {
            rect = this.getTextComponent().getUI().modelToView(this.getTextComponent(), this.displayIndex);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (rect == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint(this.getTextComponent(), new Point(rect.x, rect.y), this.parentFrame.getRootPane());
        int height = this.list.getFixedCellHeight();
        int size = this.listModel.size();
        if (size > 0) {
            height = height * Math.min(visibleMatchingRules, size) + 5;
            this.content.setBounds(p.x - 3, p.y + rect.height, this.maxWordLength * 8 + 50, height);
        }
    }

    public void selectMostRecentlyUsedWordPosition(String partialWord, String firstWordInList) {
        String mostRecentWord = "";
        for (String recentlyUsedWord : recentlyUsedWords) {
            if (!recentlyUsedWord.toLowerCase().startsWith(partialWord) || !this.words.contains(recentlyUsedWord)) continue;
            mostRecentWord = recentlyUsedWord;
            break;
        }
        if (mostRecentWord.length() > 0) {
            this.list.setSelectedValue(mostRecentWord, true);
        } else {
            this.list.setSelectedValue(firstWordInList, true);
        }
        int selectedIndex = this.list.getSelectedIndex();
        int bottomIndex = Math.max(0, selectedIndex - 1);
        int topIndex = Math.min(this.words.size() - 1, selectedIndex + 2);
        this.list.scrollRectToVisible(this.list.getCellBounds(bottomIndex, topIndex));
    }

    public void updateAutoCompleteList() {
        List<String> matchingRules;
        if (!this.content.isVisible()) {
            return;
        }
        int position = this.getTextComponent().getCaretPosition();
        int index = this.getPartialWordBeginsAtPosition(position);
        String partialWord = "";
        if (index < position) {
            partialWord = this.getTextComponent().getText().substring(index + 1, position);
        }
        if ((matchingRules = this.delegate.autoCompletionMenuGetMatchingWordsForPartialWord(partialWord)) == null || matchingRules.size() == 0) {
            this.hide();
        } else {
            this.setInsertionEndIndex(position);
            if (!this.isVStyle()) {
                this.setWordLists(matchingRules, matchingRules);
            }
            this.selectMostRecentlyUsedWordPosition(partialWord, matchingRules.get(0));
            this.resize();
        }
    }

    public class MyKeyAdapter
    extends KeyAdapter {
        public void move(int delta) {
            if (AutoCompletionMenu.this.listModel.getSize() < 1) {
                return;
            }
            int current = AutoCompletionMenu.this.list.getSelectedIndex();
            int index = Math.max(0, Math.min(AutoCompletionMenu.this.listModel.getSize() - 1, current + delta));
            AutoCompletionMenu.this.list.setSelectionInterval(index, index);
            AutoCompletionMenu.this.list.scrollRectToVisible(AutoCompletionMenu.this.list.getCellBounds(index, index));
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (!AutoCompletionMenu.this.content.isVisible()) {
                return;
            }
            switch (keyCode) {
                case 37: 
                case 39: {
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 8: {
                    int position = AutoCompletionMenu.this.getTextComponent().getCaretPosition();
                    int index = AutoCompletionMenu.this.getPartialWordBeginsAtPosition(position);
                    if (position - 1 > index) break;
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 70: 
                case 84: {
                    if (!e.isControlDown()) break;
                    AutoCompletionMenu.this.content.setVisible(false);
                    break;
                }
                case 27: {
                    AutoCompletionMenu.this.content.setVisible(false);
                    e.consume();
                    break;
                }
                case 10: {
                    AutoCompletionMenu.this.autoComplete();
                    AutoCompletionMenu.this.content.setVisible(false);
                    e.consume();
                    break;
                }
                case 40: {
                    this.move(1);
                    e.consume();
                    break;
                }
                case 38: {
                    this.move(-1);
                    e.consume();
                    break;
                }
                case 34: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(AutoCompletionMenu.this.list.getVisibleRowCount() - 1);
                    e.consume();
                    break;
                }
                case 33: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(-(AutoCompletionMenu.this.list.getVisibleRowCount() - 1));
                    e.consume();
                    break;
                }
                case 36: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(-AutoCompletionMenu.this.listModel.getSize());
                    e.consume();
                    break;
                }
                case 35: {
                    if (AutoCompletionMenu.this.isVStyle()) {
                        AutoCompletionMenu.this.content.setVisible(false);
                        break;
                    }
                    this.move(AutoCompletionMenu.this.listModel.getSize());
                    e.consume();
                    break;
                }
                default: {
                    if (AutoCompletionMenu.isAlphaNumericOr_(keyCode) || AutoCompletionMenu.isFunctionKey(keyCode)) break;
                    AutoCompletionMenu.this.content.setVisible(false);
                }
            }
        }
    }

    public class ListMouseAdapter
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed() || !AutoCompletionMenu.this.content.isVisible()) {
                return;
            }
            AutoCompletionMenu.this.autoComplete();
            AutoCompletionMenu.this.content.setVisible(false);
            AutoCompletionMenu.this.parentComponent.requestFocusInWindow();
        }
    }
}

