/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.tree.DBASTModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBASTModel {
    public Stack<Rule> rules = new Stack();
    public Map<Integer, ASTNode> nodesMap = new HashMap<Integer, ASTNode>();
    public List<DBASTModelListener> listeners = new ArrayList<DBASTModelListener>();
    private DebuggerTab debuggerTab;

    public DBASTModel(DebuggerTab debuggerTab) {
        this.debuggerTab = debuggerTab;
    }

    public void close() {
        this.debuggerTab = null;
    }

    public void addListener(DBASTModelListener listener) {
        this.listeners.add(listener);
    }

    public void fireDataChanged() {
        for (DBASTModelListener listener : this.listeners) {
            listener.modelChanged(this);
        }
    }

    public void clear() {
        this.rules.clear();
        this.nodesMap.clear();
        this.fireDataChanged();
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public Rule getRuleAtIndex(int index) {
        if (index < 0 || index >= this.rules.size()) {
            return null;
        }
        return (Rule)this.rules.get(index);
    }

    public int getRootCount() {
        return this.getRoots().size();
    }

    public void pushRule(String name) {
        this.rules.push(new Rule(name, new Stack<ASTNode>()));
    }

    public void popRule() {
        if (this.rules.size() > 1) {
            this.rules.pop();
        }
    }

    public void pushRoot(ASTNode node) {
        this.getRoots().push(node);
    }

    public void replaceRoot(ASTNode oldRoot, ASTNode newRoot) {
        Stack<ASTNode> roots = this.getRoots();
        int index = roots.indexOf(oldRoot);
        roots.remove(index);
        roots.add(index, newRoot);
    }

    public void removeRoot(ASTNode node) {
        this.getRoots().remove(node);
    }

    public void nilNode(int id) {
        this.pushRoot(this.createNilTreeNode(id));
    }

    public void errorNode(int id, String text) {
        this.pushRoot(this.createTreeNode(id, new CommonToken(0, text)));
    }

    public void createNode(int id, Token token) {
        this.createTreeNode(id, token);
    }

    public void becomeRoot(int newRootID, int oldRootID) {
        ASTNode newRoot = this.getTreeNode(newRootID);
        ASTNode oldRoot = this.getTreeNode(oldRootID);
        if (newRoot == null) {
            this.debuggerTab.warning(this, "[becomeRoot] New root node " + newRootID + " not found, ignoring.");
            return;
        }
        if (oldRoot == null) {
            this.debuggerTab.warning(this, "[becomeRoot] Old root node " + oldRootID + " not found, ignoring.");
            return;
        }
        oldRoot.becomeParent(newRoot);
        this.replaceRoot(oldRoot, newRoot);
    }

    public void addChild(int rootID, int childID) {
        ASTNode root = this.getTreeNode(rootID);
        ASTNode child = this.getTreeNode(childID);
        if (root == null) {
            this.debuggerTab.warning(this, "[addChild] Root node " + rootID + " not found, ignoring.");
            return;
        }
        if (child == null) {
            this.debuggerTab.warning(this, "[addChild] Child node " + childID + " not found, ignoring.");
            return;
        }
        this.removeRoot(child);
        root.addChild(child);
    }

    protected ASTNode createNilTreeNode(int id) {
        ASTNode node = this.createTreeNode(id);
        node.nil = true;
        return node;
    }

    protected ASTNode createTreeNode(int id, Token token) {
        ASTNode node = this.createTreeNode(id);
        node.token = token;
        return node;
    }

    protected ASTNode createTreeNode(int id) {
        ASTNode node = new ASTNode(id);
        this.nodesMap.put(id, node);
        return node;
    }

    protected ASTNode getTreeNode(int id) {
        return this.nodesMap.get(id);
    }

    protected Stack<ASTNode> getRoots() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.peek().roots;
    }

    public class ASTNode
    extends DBTreeNode {
        public int id;
        public boolean nil = false;
        public ASTNode parentNode = null;

        public ASTNode(int id) {
            this.id = id;
            this.children = new Vector();
        }

        public void addChild(ASTNode node) {
            if (node.nil) {
                for (int i = 0; i < node.children.size(); ++i) {
                    ASTNode child = (ASTNode)node.children.get(i);
                    child.parentNode = this;
                    this.children.add(child);
                }
            } else {
                node.parentNode = this;
                this.children.add(node);
            }
        }

        public void removeChild(ASTNode node) {
            this.children.remove(node);
        }

        public void becomeParent(ASTNode node) {
            node.detach();
            if (this.parentNode != null) {
                this.parentNode.replaceChild(this, node);
            }
            node.addChild(this);
        }

        public void replaceChild(ASTNode oldNode, ASTNode newNode) {
            int index = this.children.indexOf(oldNode);
            this.children.remove(index);
            if (newNode.nil) {
                this.children.addAll(index, newNode.children);
            } else {
                this.children.add(index, newNode);
            }
        }

        public void detach() {
            if (this.parentNode != null) {
                this.parentNode.removeChild(this);
                this.parentNode = null;
            }
        }

        public String toString() {
            if (this.nil) {
                return "nil";
            }
            if (this.token == null) {
                return String.valueOf(this.id);
            }
            return this.getTokenDisplayString(this.token);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Rule {
        public String name;
        public Stack<ASTNode> roots;

        public Rule(String name, Stack<ASTNode> roots) {
            this.name = name;
            this.roots = roots;
        }

        public ASTNode getRootAtIndex(int index) {
            return (ASTNode)this.roots.get(index);
        }

        public Stack<ASTNode> getRoots() {
            return this.roots;
        }
    }
}

