/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.input;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.debugger.tree.DBTreeToken;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.awtree.AWTreePanel;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBInputProcessorTree
implements DBInputProcessor,
XJNotificationObserver {
    public AWTreePanel treePanel;
    public DebuggerTab debuggerTab;
    public InputTreeNode rootNode;
    public InputTreeNode currentNode;
    public InputTreeNode lastNode;
    public Map<Integer, NodeInfo> nodeInfoForToken = new HashMap<Integer, NodeInfo>();
    public DBEventLocation location;
    public Color nonConsumedColor;
    public Color consumedColor;
    public Color ltColor;

    public DBInputProcessorTree(AWTreePanel treePanel, DebuggerTab debuggerTab) {
        this.treePanel = treePanel;
        this.debuggerTab = debuggerTab;
        this.createColors();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.treePanel = null;
        this.debuggerTab = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void updateTreePanel() {
        this.treePanel.refresh();
        this.treePanel.scrollNodeToVisible(this.lastNode);
    }

    public void createColors() {
        this.nonConsumedColor = AWPrefs.getNonConsumedTokenColor();
        this.consumedColor = AWPrefs.getConsumedTokenColor();
        this.ltColor = AWPrefs.getLookaheadTokenColor();
    }

    public void applyColor(Color c) {
        for (NodeInfo info : this.nodeInfoForToken.values()) {
            if (info.node == null) continue;
            info.node.setColor(c);
        }
    }

    public void reset() {
        this.nodeInfoForToken.clear();
        this.rootNode = this.createNode(null);
        this.treePanel.setRoot(this.rootNode);
        this.lastNode = this.currentNode = this.rootNode;
    }

    public void removeAllLT() {
    }

    public void rewind(int i) {
    }

    public void rewindAll() {
        this.applyColor(this.nonConsumedColor);
        this.lastNode = this.currentNode = this.rootNode;
    }

    public void LT(Token token) {
        InputTreeNode node = this.processToken(token);
        if (node != null) {
            this.lastNode = node;
            node.setColor(this.ltColor);
        }
    }

    public void consumeToken(Token token, int flavor) {
        InputTreeNode node = this.processToken(token);
        if (node != null) {
            this.lastNode = node;
            node.setColor(this.consumedColor);
        }
    }

    public InputTreeNode processToken(Token token) {
        NodeInfo info = this.getNode(token);
        if (info != null) {
            this.setCurrentNode(info.currentNode);
            return info.node;
        }
        info = new NodeInfo(token);
        switch (token.getType()) {
            case 2: {
                this.setCurrentNode((InputTreeNode)this.currentNode.getLastChild());
                info.currentNode = this.currentNode;
                break;
            }
            case 3: {
                if (this.currentNode == this.rootNode) {
                    this.debuggerTab.warning(this, "UP token applied to the root node!");
                }
                if (this.currentNode == null) {
                    this.debuggerTab.warning(this, "CurrentNode is null, use rootNode instead.");
                    this.setCurrentNode(this.rootNode);
                } else {
                    this.setCurrentNode((InputTreeNode)this.currentNode.getParent());
                }
                info.currentNode = this.currentNode;
                break;
            }
            default: {
                if (this.currentNode == null) {
                    this.debuggerTab.warning(this, "CurrentNode is null, use rootNode instead.");
                    this.setCurrentNode(this.rootNode);
                }
                info.node = this.createNode(token);
                this.currentNode.add(info.node);
                info.currentNode = this.currentNode;
            }
        }
        DBTreeToken tt = (DBTreeToken)token;
        this.nodeInfoForToken.put(tt.ID, info);
        return info.node;
    }

    public void setCurrentNode(InputTreeNode node) {
        this.currentNode = node;
    }

    public InputTreeNode createNode(Token token) {
        return new InputTreeNode((DBTreeToken)token, this.location);
    }

    public NodeInfo getNode(Token token) {
        DBTreeToken tt = (DBTreeToken)token;
        NodeInfo info = this.nodeInfoForToken.get(tt.ID);
        if (info != null && !info.token.toString().equals(token.toString())) {
            this.debuggerTab.warning(this, "Duplicate token ID " + tt.ID + " for " + info.token + " <-> " + token);
        }
        return info;
    }

    public void setLocation(DBEventLocation event) {
        this.location = event;
    }

    public int getCurrentTokenIndex() {
        return 0;
    }

    public DBInputTextTokenInfo getTokenInfoAtTokenIndex(int index) {
        return null;
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return null;
    }

    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_PREFS_APPLIED")) {
            this.createColors();
        }
    }

    public boolean isBreakpointAtToken(Token token) {
        NodeInfo info = this.getNode(token);
        return info != null && info.node != null && info.node.breakpoint;
    }

    public class InputTreeNode
    extends DBTreeNode {
        public boolean breakpoint;

        public InputTreeNode(DBTreeToken token, DBEventLocation location) {
            super(token, location);
            this.breakpoint = false;
        }

        public void toggleBreakpoint() {
            this.breakpoint = !this.breakpoint;
            DBInputProcessorTree.this.treePanel.getGraphView().repaintNode(this);
        }

        public Color getColor() {
            if (this.breakpoint) {
                return Color.red;
            }
            return super.getColor();
        }

        public String toString() {
            if (this.token != null) {
                return this.token.getText();
            }
            return "nil";
        }
    }

    public static class NodeInfo {
        public Token token;
        public InputTreeNode node;
        public InputTreeNode currentNode;

        public NodeInfo(Token token) {
            this.token = token;
        }
    }
}

