/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.Container;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.debugger.api.DebuggerDelegate;
import org.antlr.works.editor.ConsoleTab;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.utils.Console;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarDebuggerDelegate
implements DebuggerDelegate {
    private final GrammarWindow window;

    public GrammarDebuggerDelegate(GrammarWindow window) {
        this.window = window;
    }

    @Override
    public GrammarEngine getGrammarEngine() {
        return this.window.getGrammarEngine();
    }

    @Override
    public String getGrammarName() {
        return XJUtils.getPathByDeletingPathExtension(this.window.getGrammarFileName());
    }

    @Override
    public void debuggerStarted() {
        this.window.selectDebuggerTab();
        ((ConsoleTab)this.getConsole()).makeCurrent();
        this.window.setEditable(false);
        this.window.refreshMainMenuBar();
    }

    @Override
    public void debuggerStopped() {
        this.window.setDebuggerLocation(-1);
        this.window.setEditable(true);
        this.window.refreshMainMenuBar();
    }

    @Override
    public void debuggerSetLocation(String grammar, int line, int column) {
        int grammarIndex = this.computeAbsoluteGrammarIndex(line, column);
        if (grammarIndex >= 0) {
            this.window.setDebuggerLocation(grammarIndex);
        }
    }

    @Override
    public void debuggerSelectText(String grammar, int line, int column) {
        int grammarIndex = this.computeAbsoluteGrammarIndex(line, column);
        if (grammarIndex >= 0) {
            this.window.selectTextRange(grammarIndex, grammarIndex + 1);
        }
    }

    @Override
    public XJDocument getDocument() {
        return this.window.getDocument();
    }

    @Override
    public List<ElementRule> getRules() {
        return this.window.getRules();
    }

    @Override
    public List<ElementRule> getSortedRules() {
        return this.window.getSortedRules();
    }

    @Override
    public boolean ensureDocumentSaved() {
        return this.window.ensureDocumentSaved();
    }

    @Override
    public CodeGenerate getCodeGenerate() {
        return new CodeGenerate(this.window, null);
    }

    @Override
    public String getTokenVocab() {
        return this.getGrammarEngine().getTokenVocab();
    }

    @Override
    public Container getContainer() {
        return this.window.getJavaContainer();
    }

    @Override
    public Console getConsole() {
        return this.window.getConsoleTab();
    }

    @Override
    public List<ElementBlock> getBlocks() {
        return this.getGrammarEngine().getBlocks();
    }

    @Override
    public Map<Integer, Set<String>> getBreakpoints() {
        HashMap<Integer, Set<String>> breakpoints = new HashMap<Integer, Set<String>>();
        for (Integer line : this.window.getBreakpoints()) {
            HashSet<String> names = (HashSet<String>)breakpoints.get(line);
            if (names == null) {
                names = new HashSet<String>();
                breakpoints.put(line, names);
            }
            names.add(XJUtils.getPathByDeletingPathExtension(this.window.getGrammarFileName()));
        }
        return breakpoints;
    }

    @Override
    public ContextualMenuFactory createContextualMenuFactory() {
        return this.window.createContextualMenuFactory();
    }

    @Override
    public void selectConsoleTab() {
        this.window.selectConsoleTab();
    }

    private int computeAbsoluteGrammarIndex(int lineIndex, int column) {
        List<ATELine> lines = this.window.getLines();
        if (lineIndex - 1 < 0 || lineIndex - 1 >= lines.size()) {
            return -1;
        }
        ATELine line = lines.get(lineIndex - 1);
        return line.position + column - 1;
    }
}

