/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.generic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.ate.syntax.generic.ATESyntaxLexer;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATESyntaxEngine {
    protected ATESyntaxEngineDelegate delegate;
    protected ATESyntaxLexer lexer = this.createLexer();
    protected ATESyntaxParser parser = this.createParser();
    protected List<ATEToken> tokens;
    protected SimpleAttributeSet commentAttr;
    protected SimpleAttributeSet stringAttr = new SimpleAttributeSet();
    protected SimpleAttributeSet keywordAttr = new SimpleAttributeSet();

    public ATESyntaxEngine() {
        this.commentAttr = new SimpleAttributeSet();
    }

    public void close() {
        this.parser.close();
        this.parser = null;
        this.lexer.close();
        this.lexer = null;
        this.delegate = null;
    }

    public void setDelegate(ATESyntaxEngineDelegate delegate) {
        this.delegate = delegate;
    }

    public synchronized List<ATEToken> getTokens() {
        return this.tokens;
    }

    public synchronized List<ATELine> getLines() {
        return this.lexer.getLines();
    }

    public synchronized int getMaxLines() {
        return this.lexer.getLineNumber();
    }

    public ATESyntaxLexer getLexer() {
        return this.lexer;
    }

    public ATESyntaxParser getParser() {
        return this.parser;
    }

    public ATESyntaxLexer createLexer() {
        return new ATESyntaxLexer();
    }

    public ATESyntaxParser createParser() {
        return null;
    }

    public AttributeSet getAttributeForToken(ATEToken token) {
        SimpleAttributeSet attr = null;
        switch (token.type) {
            case 3: 
            case 4: {
                attr = this.commentAttr;
                break;
            }
            case 1: 
            case 2: {
                attr = this.stringAttr;
                break;
            }
            default: {
                Set<String> s = this.getKeywords();
                if (s == null || !s.contains(token.getAttribute())) break;
                attr = this.keywordAttr;
            }
        }
        return attr;
    }

    public void processSyntax() {
        this.lexer.tokenize(this.delegate.getText());
        this.tokens = new ArrayList<ATEToken>(this.lexer.getTokens());
        if (this.parser != null) {
            this.parser.parse(this.tokens);
        }
    }

    public void process() {
        this.delegate.ateEngineBeforeParsing();
        this.processSyntax();
        this.delegate.ateEngineAfterParsing();
    }

    public void applyCommentAttribute(SimpleAttributeSet commentAttr) {
        StyleConstants.setForeground(commentAttr, Color.lightGray);
        StyleConstants.setItalic(commentAttr, true);
    }

    public void applyStringAttribute(SimpleAttributeSet stringAttr) {
        StyleConstants.setForeground(stringAttr, new Color(0.0f, 0.5f, 0.0f));
        StyleConstants.setBold(stringAttr, true);
    }

    public void applyKeywordAttribute(SimpleAttributeSet keywordAttr) {
        StyleConstants.setForeground(keywordAttr, new Color(0.0f, 0.0f, 0.5f));
        StyleConstants.setBold(keywordAttr, true);
    }

    public void refreshColoring() {
        this.applyCommentAttribute(this.commentAttr);
        this.applyStringAttribute(this.stringAttr);
        this.applyKeywordAttribute(this.keywordAttr);
    }

    public Set<String> getKeywords() {
        return null;
    }
}

