/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works;

import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.tool.ErrorManager;
import org.antlr.works.SplashScreen;
import org.antlr.works.components.GrammarDocument;
import org.antlr.works.components.GrammarDocumentFactory;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.dialog.AWPrefsDialog;
import org.antlr.works.dialog.DialogAbout;
import org.antlr.works.dialog.DialogPersonalInfo;
import org.antlr.works.dialog.NewWizardDialog;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.Statistics;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.stringtemplate.STDocumentFactory;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.HelpManager;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Localizable;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJApplicationDelegate;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.swing.XJLookAndFeel;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDE
extends XJApplicationDelegate
implements XJMenuItemDelegate {
    public static final String PROPERTIES_PATH = "properties/";
    public static SplashScreen sc;
    protected static ResourceBundle resourceMenusBundle;

    public static void main(String[] args) {
        XJSystem.setSystemProperties();
        XJApplication.setPropertiesPath(PROPERTIES_PATH);
        XJAlert.setDefaultAlertIcon(IconManager.shared().getIconApplication64x64());
        if (args.length >= 1 && args[0].equals("-stats")) {
            XJApplication.run(new Statistics(), args, "Statistics");
        } else {
            sc = new SplashScreen();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        sc.setVisible(true);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            XJApplication.run(new IDE(), args);
        }
    }

    public void closeSplashScreen() {
        if (sc != null) {
            sc.setVisible(false);
            sc.dispose();
            sc = null;
        }
    }

    @Override
    public void appDidLaunch(String[] args, List<String> documentsToOpenAtStartup) {
        AWPrefs.setLookAndFeel(XJLookAndFeel.applyLookAndFeel(AWPrefs.getLookAndFeel()));
        XJApplication.addDocumentFactory(new GrammarDocumentFactory(GrammarWindow.class));
        XJApplication.addDocumentFactory(new STDocumentFactory(STWindow.class));
        XJApplication.addScheduledTimer(new HelpManager(), 1L, true);
        AWPrefsDialog.applyCommonPrefs();
        this.registerUser();
        this.checkLibraries();
        this.checkEnvironment();
        if (args.length >= 2 && args[0].equals("-f")) {
            XJApplication.shared().openDocument(args[1]);
        } else if (documentsToOpenAtStartup != null && documentsToOpenAtStartup.size() > 0) {
            XJApplication.shared().openDocuments(documentsToOpenAtStartup);
        } else {
            switch (AWPrefs.getStartupAction()) {
                case 0: {
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 1: {
                    if (!XJApplication.shared().getWindows().isEmpty() || XJApplication.shared().openLastUsedDocument()) break;
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 2: {
                    if (!XJApplication.shared().getWindows().isEmpty() || XJApplication.shared().openDocument(AWPrefs.getLastSavedDocument())) break;
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 3: {
                    this.closeSplashScreen();
                    if (this.restoreAllOpenedDocuments()) break;
                    XJApplication.shared().newDocument();
                }
            }
        }
        this.closeSplashScreen();
    }

    public void registerUser() {
        if (!AWPrefs.isUserRegistered()) {
            this.closeSplashScreen();
            AWPrefs.setServerID("");
            new DialogPersonalInfo(null).runModal();
            AWPrefs.setUserRegistered(true);
        }
    }

    public void checkLibraries() {
        StringBuilder missing = new StringBuilder();
        try {
            Class.forName("org.antlr.Tool");
        }
        catch (ClassNotFoundException e) {
            missing.append("\n- ANTLR 3.x");
        }
        try {
            Class.forName("org.antlr.stringtemplate.StringTemplate");
        }
        catch (ClassNotFoundException e) {
            missing.append("\n- StringTemplate");
        }
        catch (NoClassDefFoundError e) {
            missing.append("\n- StringTemplate");
        }
        if (missing.length() > 0) {
            this.closeSplashScreen();
            missing.insert(0, "ANTLRWorks cannot find the following libraries:");
            missing.append("\nThey are required in order to use all the features of ANTLRWorks.\nDownload them from www.antlr.org and put them in the same directory as ANTLRWorks.");
            XJAlert.display(null, "Missing Libraries", missing.toString());
            System.exit(0);
        }
    }

    public void checkEnvironment() {
        ErrorListener el = ErrorListener.getThreadInstance();
        CheckStream bos = new CheckStream(System.err);
        PrintStream ps = new PrintStream(bos);
        PrintStream os = System.err;
        System.setErr(ps);
        try {
            ErrorManager.setTool(new Tool());
            ErrorManager.setErrorListener(el);
        }
        catch (Throwable e) {
            XJAlert.display(null, "Fatal Error", "ANTLRWorks will quit now because ANTLR reported an error:\n" + bos.getMessage());
            System.exit(0);
        }
        if (el.hasErrors()) {
            XJAlert.display(null, "Error", "ANTLRWorks will continue to launch but ANTLR reported an error:\n" + bos.getMessage());
        }
        el.clear();
        System.setErr(os);
        ps.close();
        ErrorManager.removeErrorListener();
    }

    public static String getApplicationPath() {
        int index;
        String p;
        Class<?> c = XJApplication.getAppDelegate().getClass();
        URL url = c.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            String name = c.getName().replace('.', '/').concat(".class");
            url = c.getClassLoader().getResource(name);
            if (url == null) {
                System.err.println("IDE: unable to get the location of the XJApplicationDelegate");
                return null;
            }
            p = url.getPath();
            p = p.substring(0, p.length() - name.length());
        } else {
            p = url.getPath();
        }
        if (p.startsWith("jar:")) {
            p = p.substring("jar:".length());
        }
        if (p.startsWith("file:")) {
            p = p.substring("file:".length());
        }
        if ((index = p.lastIndexOf("!")) != -1) {
            p = p.substring(0, index);
        }
        if (XJSystem.isWindows()) {
            if (p.charAt(0) == '/') {
                p = p.substring(1);
            }
            StringBuilder sb = new StringBuilder(p);
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != '/') continue;
                sb.replace(i, i + 1, "\\");
            }
            p = sb.toString();
        }
        p = p.replaceAll("%20", " ");
        return p;
    }

    public static void debugVerbose(Console console, Class c, String s) {
        if (AWPrefs.getDebugVerbose()) {
            String message = c.getName() + ": " + s;
            if (console != null) {
                console.println(message);
            }
            System.out.println(message);
        }
    }

    @Override
    public void customizeHelpMenu(XJMenu menu) {
        menu.insertItemAfter(new XJMenuItem("Check for Updates", 102, this), 10020);
        menu.insertItemAfter(new XJMenuItem("Send Feedback", 101, this), 10020);
        menu.insertItemAfter(new XJMenuItem("Submit Statistics...", 100, this), 10020);
        menu.insertSeparatorAfter(10020);
    }

    @Override
    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        switch (item.getTag()) {
            case 100: {
                IDE.submitStats(this.getDefaultParent());
                break;
            }
            case 101: {
                IDE.submitFeedback(this.getDefaultParent());
                break;
            }
            case 102: {
                IDE.checkUpdates(this.getDefaultParent());
            }
        }
    }

    public Container getDefaultParent() {
        return XJApplication.shared().getActiveWindow().getJavaContainer();
    }

    public static void checkUpdates(Container parent) {
        StatisticsAW.shared().recordEvent(132);
        HelpManager.checkUpdates(parent, false);
    }

    public static void submitFeedback(Container parent) {
        HelpManager.sendFeedback(parent);
    }

    public static void submitStats(Container parent) {
        HelpManager.submitStats(parent);
    }

    public static void showHelp(Container parent) {
        StatisticsAW.shared().recordEvent(131);
        String url = Localizable.getLocalizedString("DocumentationURL");
        try {
            BrowserLauncher.openURL(url);
        }
        catch (IOException e) {
            XJAlert.display(parent, "Cannot access the online help", "An error occurred when accessing the online help:\n" + e.toString() + "\n\nBrowse the online help at " + url + ".");
        }
    }

    @Override
    public void appShowHelp() {
        IDE.showHelp(this.getDefaultParent());
    }

    @Override
    public void appWillTerminate() {
        this.rememberAllOpenedDocuments();
        StatisticsAW.shared().close();
    }

    @Override
    public Class appPreferencesPanelClass() {
        return AWPrefsDialog.class;
    }

    @Override
    public XJPanel appInstanciateAboutPanel() {
        return new DialogAbout();
    }

    @Override
    public boolean appHasPreferencesMenuItem() {
        return true;
    }

    @Override
    public boolean appShouldQuitAfterLastWindowClosed() {
        return false;
    }

    @Override
    public boolean useDesktopMode() {
        return AWPrefs.getUseDesktopMode();
    }

    @Override
    public Class appPreferencesClass() {
        return IDE.class;
    }

    @Override
    public String appName() {
        return Localizable.getLocalizedString("AppName") + " " + this.appVersionShort();
    }

    @Override
    public String appVersionShort() {
        return Localizable.getLocalizedString("AppVersionShort");
    }

    @Override
    public String appVersionLong() {
        return Localizable.getLocalizedString("AppVersionLong");
    }

    @Override
    public boolean displayNewDocumentWizard(XJDocument document) {
        NewWizardDialog dialog;
        if (document != null && document instanceof GrammarDocument && (dialog = new NewWizardDialog(document.getWindow().getJavaContainer())).runModal() == 1) {
            ((GrammarWindow)document.getWindow()).loadText(dialog.getGeneratedText());
            return true;
        }
        return false;
    }

    private boolean restoreAllOpenedDocuments() {
        List<String> documents = AWPrefs.getAllOpenedDocuments();
        if (documents == null) {
            return false;
        }
        boolean success = false;
        for (String docPath : documents) {
            if (!XJApplication.shared().openDocument(docPath)) continue;
            success = true;
        }
        return success;
    }

    private void rememberAllOpenedDocuments() {
        ArrayList<String> docPath = new ArrayList<String>();
        for (XJWindow window : XJApplication.shared().getWindows()) {
            XJDocument document = window.getDocument();
            if (!XJApplication.handlesDocument(document)) continue;
            docPath.add(document.getDocumentPath());
        }
        AWPrefs.setAllOpenedDocuments(docPath);
    }

    public static ResourceBundle getMenusResourceBundle() {
        return resourceMenusBundle;
    }

    static {
        resourceMenusBundle = ResourceBundle.getBundle("properties.menus");
    }

    private class CheckStream
    extends ByteArrayOutputStream {
        private PrintStream errorStream;
        private StringBuilder sb = new StringBuilder();

        public CheckStream(PrintStream errorStream) {
            this.errorStream = errorStream;
        }

        public synchronized void write(int b) {
            super.write(b);
            this.record();
        }

        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            this.record();
        }

        public synchronized void writeTo(OutputStream out) throws IOException {
            super.writeTo(out);
            this.record();
        }

        public void write(byte[] b) throws IOException {
            super.write(b);
            this.record();
        }

        private void record() {
            this.errorStream.println(this.toString());
            this.sb.append(this.toString());
            this.reset();
        }

        public String getMessage() {
            return this.sb.toString();
        }
    }
}

