import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

@SuppressWarnings("serial")
public class Movement extends JFrame {
	private static final int CIRCLE_SIZE = 50;
	private static final int CIRCLE_MSIZE = Movement.CIRCLE_SIZE / 2;
	private static final int MOVEMENT = 1;
	
	private double angle = 0.;
	private Point pos = new Point(100, 100);
	private Point dest = new Point(this.pos.x, this.pos.y);
	private boolean touchingTheBall = false;
	
	public Movement () {
		this.setSize(500, 500);
		this.setResizable(false);
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		Toolkit tk = Toolkit.getDefaultToolkit();
		Cursor invisCursor = tk.createCustomCursor(tk.createImage(""),new Point(),null);
		setCursor(invisCursor);
		
		this.addMouseListener(new MouseListener() {
			@Override
			public void mouseReleased(MouseEvent arg0) { }
			@Override
			public void mousePressed(MouseEvent arg0) { }
			@Override
			public void mouseExited(MouseEvent arg0) { }
			@Override
			public void mouseEntered(MouseEvent arg0) { }

			@Override
			public void mouseClicked(MouseEvent arg0) {
				dest.setLocation(getMousePosition().getX(), getMousePosition().getY());
			}
		});
	}
	
	private void draw (Graphics2D g) {
		g.setBackground(Color.GRAY);
		g.clearRect(0, 0, 500, 500);

		if (this.touchingTheBall) {
			g.setColor(Color.BLACK);
			g.fillOval((int)this.pos.getX() - Movement.CIRCLE_MSIZE, (int)this.pos.getY() - Movement.CIRCLE_MSIZE, 
					Movement.CIRCLE_SIZE, Movement.CIRCLE_SIZE);
			g.setColor(Color.WHITE);
		}
		
		g.setStroke(new BasicStroke(3.f));
		g.drawOval((int)this.pos.getX() - Movement.CIRCLE_MSIZE, (int)this.pos.getY() - Movement.CIRCLE_MSIZE, 
				Movement.CIRCLE_SIZE, Movement.CIRCLE_SIZE);
		
		// Nota: Cómo dibujar una línea del tamaño CIRCLE_MSIZE orientada según el ángulo
		double radian = (this.angle * Math.PI) / 180.;
		g.drawLine((int)this.pos.getX(), (int)this.pos.getY(), 
				(int)(this.pos.getX() + (int)(Movement.CIRCLE_MSIZE * Math.cos(radian))), 
				(int)(this.pos.getY() + (int)(Movement.CIRCLE_MSIZE * Math.sin(radian))));
		
		if (this.getMousePosition() != null)
			g.fillOval((int)this.getMousePosition().getX(), (int)this.getMousePosition().getY(), 5, 5);
	}
	
	// Nota: Movimiento en una dirección
	public void movement () {
		if ((this.pos.getX() == this.dest.getX()) && (this.pos.getY() == this.dest.getY())) 
			return;
		
		double radian = (this.getAngle(this.pos, this.dest) * Math.PI) / 180.;
		
		this.pos.setLocation( 
				(this.pos.getX() + (Movement.MOVEMENT * Math.cos(radian))), 
				(this.pos.getY() + (Movement.MOVEMENT * Math.sin(radian))));
	}
	
	// Nota: Distancia euclidea
	private double getDistance (Point p1, Point p2) {
		double dist1 = p1.getX() - p2.getX();
		double dist2 = p1.getY() - p2.getY();
		return Math.sqrt(Math.pow(dist1, 2) + Math.pow(dist2, 2));
	}
	
	public void updateAngle () {
		Point mousePos = this.getMousePosition();
		if (mousePos == null)
			return;
		this.angle = getAngle(this.pos, mousePos);
	}

	// Nota: Ángulo entre dos puntos
	public double getAngle (Point p1, Point p2) {
		double catOpuesto = p1.getY() - p2.getY();
		double catContiguo = p1.getX() - p2.getX();
		double hipotenusa = this.getDistance(p1, p2);
		double value = catOpuesto / hipotenusa;
		value = Math.toDegrees(Math.asin(value));
		// Corrección del ángulo en el sistema de coordenadas de un JFrame
		value = (catContiguo > 0) ? value - 180 : 360 - value;
		return value;
	}
	
	// Nota: Colisiones en circulos
	public void updateTouchingTheBall () {
		Point mousePos = this.getMousePosition();
		if (mousePos == null) {
			this.touchingTheBall = false;
			return;
		}
		this.touchingTheBall = (this.getDistance(this.pos, mousePos) < Movement.CIRCLE_MSIZE);
	}
	
	public void paint(Graphics g1) {
		BufferedImage image = new BufferedImage(500, 500,
				BufferedImage.TYPE_INT_RGB);
		Graphics2D g = (Graphics2D) image.getGraphics();
		this.draw(g);
		Graphics2D mainGraphs = (Graphics2D) this.getRootPane().getGraphics();
		mainGraphs.drawImage(image, 0, 0, this);
	}
	
	public void run () {
		while (true) {
			try {
				this.updateTouchingTheBall();
				this.updateAngle();
				this.movement();
				this.repaint();
				Thread.sleep(10);
			} catch (InterruptedException e) {}
		}
	}
	
	public static void main(String[] args) {
		Movement m = new Movement();
		m.run();
	}
}
