#!/usr/bin/python
# -*- coding: utf-8 *-*

import tornado.ioloop
import tornado.web
import zmq.green as zmq
from zmq.eventloop import ioloop
from zmq.eventloop.zmqstream import ZMQStream
import tornado.websocket

DEBUG = True
PORT = 8888
ZPORT = 2525

context = zmq.Context()

class WebSocket(tornado.websocket.WebSocketHandler):
    clients = set()
    def open(self):
        self.clients.add(self)
        subscriber = context.socket(zmq.SUB)
        subscriber.connect("tcp://127.0.0.1:%s" % str(ZPORT))
        subscriber.setsockopt(zmq.SUBSCRIBE, '')
        self.subscribe_stream = ZMQStream(subscriber)
        self.subscribe_stream.on_recv(self.send_to_clients)
        
    def on_message (self, message):
        pass
       
    def send_to_clients(self, message):
        self.write_message(unicode(message))
    
    def on_close(self):
        self.clients.remove(self)
        self.subscribe_stream.close()

ioloop.install()
application = tornado.web.Application([
    (r"/wsock", WebSocket),
    (r'/(.*)', tornado.web.StaticFileHandler, {'path': 'static/'}),
    (r'/(.*)', tornado.web.StaticFileHandler, {'path': 'static/index.html'})
], debug=DEBUG)

if __name__ == "__main__":
    application.listen(PORT)
    tornado.ioloop.IOLoop.instance().start()
