﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Newtonsoft.Json
{
  /// <summary>
  /// Specifies type name handling options for the <see cref="JsonSerializer"/>.
  /// </summary>
  [Flags]
  public enum TypeNameHandling
  {
    /// <summary>
    /// Do not include the .NET type name when serializing types.
    /// </summary>
    None = 0,
    /// <summary>
    /// Include the .NET type name when serializing into a JSON object structure.
    /// </summary>
    Objects = 1,
    /// <summary>
    /// Include the .NET type name when serializing into a JSON array structure.
    /// </summary>
    Arrays = 2,
    /// <summary>
    /// Always include the .NET type name when serializing.
    /// </summary>
    All = Objects | Arrays
  }
}