/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta;

import com.db4o.activation.Activator;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.events.ClassEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectEventArgs;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.EmbeddedClientObjectContainer;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.ta.Activatable;
import com.db4o.ta.NotTransparentActivationEnabled;
import com.db4o.ta.TransactionalActivator;

public class TransparentActivationSupport
implements ConfigurationItem {
    static /* synthetic */ Class class$com$db4o$ta$Activatable;

    public void prepare(Configuration configuration) {
    }

    public void apply(InternalObjectContainer internalObjectContainer) {
        internalObjectContainer.configImpl().activationDepthProvider(new TransparentActivationDepthProvider());
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer(internalObjectContainer);
        eventRegistry.instantiated().addListener(new EventListener4(){

            public void onEvent(Event4 event4, EventArgs eventArgs) {
                this.bindActivatableToActivator((ObjectEventArgs)eventArgs);
            }

            private void bindActivatableToActivator(ObjectEventArgs objectEventArgs) {
                Object object = objectEventArgs.object();
                if (object instanceof Activatable) {
                    Transaction transaction = (Transaction)objectEventArgs.transaction();
                    ((Activatable)object).bind(this.activatorForObject(transaction, object));
                }
            }

            private Activator activatorForObject(Transaction transaction, Object object) {
                ObjectReference objectReference = transaction.referenceForObject(object);
                if (this.isEmbeddedClient(transaction)) {
                    return new TransactionalActivator(transaction, objectReference);
                }
                return objectReference;
            }

            private boolean isEmbeddedClient(Transaction transaction) {
                return transaction.objectContainer() instanceof EmbeddedClientObjectContainer;
            }
        });
        final TADiagnosticProcessor tADiagnosticProcessor = new TADiagnosticProcessor(internalObjectContainer);
        eventRegistry.classRegistered().addListener(new EventListener4(){

            public void onEvent(Event4 event4, EventArgs eventArgs) {
                ClassEventArgs classEventArgs = (ClassEventArgs)eventArgs;
                tADiagnosticProcessor.onClassRegistered(classEventArgs.classMetadata());
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class TADiagnosticProcessor {
        private final InternalObjectContainer _container;

        public TADiagnosticProcessor(InternalObjectContainer internalObjectContainer) {
            this._container = internalObjectContainer;
        }

        public void onClassRegistered(ClassMetadata classMetadata) {
            ReflectClass reflectClass = classMetadata.classReflector();
            if (this.activatableClass().isAssignableFrom(reflectClass)) {
                return;
            }
            if (this.hasOnlyPrimitiveFields(reflectClass)) {
                return;
            }
            NotTransparentActivationEnabled notTransparentActivationEnabled = new NotTransparentActivationEnabled(classMetadata);
            DiagnosticProcessor diagnosticProcessor = this._container.handlers()._diagnosticProcessor;
            diagnosticProcessor.onDiagnostic(notTransparentActivationEnabled);
        }

        private ReflectClass activatableClass() {
            return this._container.reflector().forClass(class$com$db4o$ta$Activatable == null ? (class$com$db4o$ta$Activatable = TransparentActivationSupport.class$("com.db4o.ta.Activatable")) : class$com$db4o$ta$Activatable);
        }

        private boolean hasOnlyPrimitiveFields(ReflectClass reflectClass) {
            for (ReflectClass reflectClass2 = reflectClass; reflectClass2 != null; reflectClass2 = reflectClass2.getSuperclass()) {
                ReflectField[] reflectFieldArray = reflectClass2.getDeclaredFields();
                if (this.hasOnlyPrimitiveFields(reflectFieldArray)) continue;
                return false;
            }
            return true;
        }

        private boolean hasOnlyPrimitiveFields(ReflectField[] reflectFieldArray) {
            for (int i = 0; i < reflectFieldArray.length; ++i) {
                if (this.isPrimitive(reflectFieldArray[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isPrimitive(ReflectField reflectField) {
            return reflectField.getFieldType().isPrimitive();
        }
    }
}

