/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.internal.Platform4;
import com.db4o.io.IoAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileAdapter
extends IoAdapter {
    private String _path;
    private RandomAccessFile _delegate;

    public RandomAccessFileAdapter() {
    }

    protected RandomAccessFileAdapter(String string, boolean bl, long l, boolean bl2) throws Db4oIOException {
        boolean bl3 = false;
        try {
            this._path = new File(string).getCanonicalPath();
            this._delegate = new RandomAccessFile(this._path, bl2 ? "r" : "rw");
            if (l > 0L) {
                this._delegate.seek(l - 1L);
                this._delegate.write(new byte[]{0});
            }
            if (bl) {
                Platform4.lockFile(this._path, this._delegate);
            }
            bl3 = true;
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
        finally {
            if (!bl3) {
                this.close();
            }
        }
    }

    public void close() throws Db4oIOException {
        try {
            if (this._delegate != null) {
                this._delegate.seek(0L);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Platform4.unlockFile(this._path, this._delegate);
        try {
            if (this._delegate != null) {
                this._delegate.close();
            }
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void delete(String string) {
        new File(string).delete();
    }

    public boolean exists(String string) {
        File file = new File(string);
        return file.exists() && file.length() > 0L;
    }

    public long getLength() throws Db4oIOException {
        try {
            return this._delegate.length();
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public IoAdapter open(String string, boolean bl, long l, boolean bl2) throws Db4oIOException {
        return new RandomAccessFileAdapter(string, bl, l, bl2);
    }

    public int read(byte[] byArray, int n) throws Db4oIOException {
        try {
            return this._delegate.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void seek(long l) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.REGULAR_SEEK.log(l);
        }
        try {
            this._delegate.seek(l);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void sync() throws Db4oIOException {
        try {
            this._delegate.getFD().sync();
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void write(byte[] byArray, int n) throws Db4oIOException {
        try {
            this._delegate.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }
}

