/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.result;

import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.LazyQueryResult;
import com.db4o.internal.query.result.SnapShotQueryResult;
import com.db4o.query.QueryComparator;

public class HybridQueryResult
extends AbstractQueryResult {
    private AbstractQueryResult _delegate;

    public HybridQueryResult(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        super(transaction);
        this._delegate = HybridQueryResult.forMode(transaction, queryEvaluationMode);
    }

    private static AbstractQueryResult forMode(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        if (queryEvaluationMode == QueryEvaluationMode.LAZY) {
            return new LazyQueryResult(transaction);
        }
        if (queryEvaluationMode == QueryEvaluationMode.SNAPSHOT) {
            return new SnapShotQueryResult(transaction);
        }
        return new IdListQueryResult(transaction);
    }

    public Object get(int n) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.get(n);
    }

    public int getId(int n) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.getId(n);
    }

    public int indexOf(int n) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.indexOf(n);
    }

    public IntIterator4 iterateIDs() {
        return this._delegate.iterateIDs();
    }

    public Iterator4 iterator() {
        return this._delegate.iterator();
    }

    public void loadFromClassIndex(ClassMetadata classMetadata) {
        this._delegate.loadFromClassIndex(classMetadata);
    }

    public void loadFromClassIndexes(ClassMetadataIterator classMetadataIterator) {
        this._delegate.loadFromClassIndexes(classMetadataIterator);
    }

    public void loadFromIdReader(BufferImpl bufferImpl) {
        this._delegate.loadFromIdReader(bufferImpl);
    }

    public void loadFromQuery(QQuery qQuery) {
        if (qQuery.requiresSort()) {
            this._delegate = new IdListQueryResult(this.transaction());
        }
        this._delegate.loadFromQuery(qQuery);
    }

    public int size() {
        this._delegate = this._delegate.supportSize();
        return this._delegate.size();
    }

    public void sort(QueryComparator queryComparator) {
        this._delegate = this._delegate.supportSort();
        this._delegate.sort(queryComparator);
    }
}

