/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.marshall.AbstractReadContext;
import com.db4o.internal.marshall.FieldListInfo;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;

public class UnmarshallingContext
extends AbstractReadContext
implements FieldListInfo,
MarshallingInfo {
    private final ObjectReference _reference;
    private Object _object;
    private ObjectHeader _objectHeader;
    private int _addToIDTree;
    private boolean _checkIDTree;

    public UnmarshallingContext(Transaction transaction, BufferImpl bufferImpl, ObjectReference objectReference, int n, boolean bl) {
        super(transaction, bufferImpl);
        this._reference = objectReference;
        this._addToIDTree = n;
        this._checkIDTree = bl;
    }

    public UnmarshallingContext(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        this(transaction, null, objectReference, n, bl);
    }

    public StatefulBuffer statefulBuffer() {
        StatefulBuffer statefulBuffer = new StatefulBuffer(this._transaction, this._buffer.length());
        statefulBuffer.setID(this.objectID());
        statefulBuffer.setInstantiationDepth(this.activationDepth());
        ((BufferImpl)this._buffer).copyTo(statefulBuffer, 0, 0, this._buffer.length());
        statefulBuffer.seek(this._buffer.offset());
        return statefulBuffer;
    }

    public int objectID() {
        return this._reference.getID();
    }

    public Object read() {
        return this.readInternal(false);
    }

    public Object readPrefetch() {
        return this.readInternal(true);
    }

    private final Object readInternal(boolean bl) {
        Object object;
        if (!this.beginProcessing()) {
            return this._object;
        }
        this.readBuffer(this.objectID());
        if (this._buffer == null) {
            this.endProcessing();
            return this._object;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            this.endProcessing();
            return this._object;
        }
        this._reference.classMetadata(classMetadata);
        this.adjustActivationDepth(bl);
        if (this._checkIDTree && (object = this._transaction.objectForIdFromCache(this.objectID())) != null) {
            this._object = object;
            this.endProcessing();
            return this._object;
        }
        this._object = this.peekPersisted() ? this.classMetadata().instantiateTransient(this) : this.classMetadata().instantiate(this);
        this.endProcessing();
        return this._object;
    }

    private void adjustActivationDepth(boolean bl) {
        if (bl) {
            this.adjustActivationDepthForPrefetch();
        } else if (UnknownActivationDepth.INSTANCE == this._activationDepth) {
            this._activationDepth = this.container().defaultActivationDepth(this.classMetadata());
        }
    }

    private void adjustActivationDepthForPrefetch() {
        this.activationDepth(this.activationDepthProvider().activationDepthFor(this.classMetadata(), ActivationMode.PREFETCH));
    }

    private ActivationDepthProvider activationDepthProvider() {
        return this.container().activationDepthProvider();
    }

    public Object readFieldValue(FieldMetadata fieldMetadata) {
        this.readBuffer(this.objectID());
        if (this._buffer == null) {
            return null;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            return null;
        }
        if (!this._objectHeader.objectMarshaller().findOffset(classMetadata, this._objectHeader._headerAttributes, (BufferImpl)this._buffer, fieldMetadata)) {
            return null;
        }
        return fieldMetadata.read(this);
    }

    private ClassMetadata readObjectHeader() {
        this._objectHeader = new ObjectHeader(this.container(), this._buffer);
        ClassMetadata classMetadata = this._objectHeader.classMetadata();
        if (classMetadata == null) {
            return null;
        }
        return classMetadata;
    }

    private void readBuffer(int n) {
        if (this._buffer == null && n > 0) {
            this._buffer = this.container().readReaderByID(this._transaction, n);
        }
    }

    public ClassMetadata classMetadata() {
        return this._reference.classMetadata();
    }

    private boolean beginProcessing() {
        return this._reference.beginProcessing();
    }

    private void endProcessing() {
        this._reference.endProcessing();
    }

    public void setStateClean() {
        this._reference.setStateClean();
    }

    public Object persistentObject() {
        return this._object;
    }

    public void setObjectWeak(Object object) {
        this._reference.setObjectWeak(this.container(), object);
    }

    protected boolean peekPersisted() {
        return this._addToIDTree == -1;
    }

    public Object readObject(TypeHandler4 typeHandler4) {
        TypeHandler4 typeHandler42 = this.correctHandlerVersion(typeHandler4);
        if (!this.isIndirected(typeHandler42)) {
            return typeHandler42.read(this);
        }
        int n = this.readInt();
        this.readInt();
        if (n == 0) {
            return null;
        }
        int n2 = this.offset();
        this.seek(n);
        Object object = typeHandler42.read(this);
        this.seek(n2);
        return object;
    }

    public Config4Class classConfig() {
        return this.classMetadata().config();
    }

    public ObjectReference reference() {
        return this._reference;
    }

    public void addToIDTree() {
        if (this._addToIDTree == 1) {
            this._reference.addExistingReferenceToIdTree(this.transaction());
        }
    }

    public void persistentObject(Object object) {
        this._object = object;
    }

    public ObjectHeaderAttributes headerAttributes() {
        return this._objectHeader._headerAttributes;
    }

    public boolean isNull(int n) {
        return this.headerAttributes().isNull(n);
    }

    public int handlerVersion() {
        return this._objectHeader.handlerVersion();
    }
}

