/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.BufferImpl;
import com.db4o.internal.Platform4;
import com.db4o.internal.marshall.MarshallingConstants0;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import java.util.Date;

public class PrimitiveMarshaller0
extends PrimitiveMarshaller {
    public boolean useNormalClassRead() {
        return true;
    }

    public Date readDate(BufferImpl bufferImpl) {
        long l = bufferImpl.readLong();
        if (l == Long.MAX_VALUE) {
            return MarshallingConstants0.NULL_DATE;
        }
        return new Date(l);
    }

    public Object readInteger(BufferImpl bufferImpl) {
        int n = bufferImpl.readInt();
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        return new Integer(n);
    }

    public Object readFloat(BufferImpl bufferImpl) {
        Float f = PrimitiveMarshaller0.unmarshallFloat(bufferImpl);
        if (f.isNaN()) {
            return null;
        }
        return f;
    }

    public Object readDouble(BufferImpl bufferImpl) {
        Double d = PrimitiveMarshaller0.unmarshalDouble(bufferImpl);
        if (d.isNaN()) {
            return null;
        }
        return d;
    }

    public Object readLong(BufferImpl bufferImpl) {
        long l = bufferImpl.readLong();
        if (l == Long.MAX_VALUE) {
            return null;
        }
        return new Long(l);
    }

    public Object readShort(BufferImpl bufferImpl) {
        short s = PrimitiveMarshaller0.unmarshallShort(bufferImpl);
        if (s == Short.MAX_VALUE) {
            return null;
        }
        return new Short(s);
    }

    public static Double unmarshalDouble(BufferImpl bufferImpl) {
        return new Double(Platform4.longToDouble(bufferImpl.readLong()));
    }

    public static Float unmarshallFloat(BufferImpl bufferImpl) {
        return new Float(Float.intBitsToFloat(bufferImpl.readInt()));
    }

    public static short unmarshallShort(BufferImpl bufferImpl) {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n = (n << 8) + (bufferImpl._buffer[bufferImpl._offset++] & 0xFF);
        }
        return (short)n;
    }
}

