/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.ObjectContainer;
import com.db4o.foundation.BitMap4;
import com.db4o.foundation.IntByRef;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.MarshallingBuffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.FieldListInfo;
import com.db4o.internal.marshall.MarshallingContextState;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.WriteContext;

public class MarshallingContext
implements FieldListInfo,
MarshallingInfo,
WriteContext {
    private static final int HEADER_LENGTH = 9;
    public static final byte HANDLER_VERSION = 2;
    private static final int NO_INDIRECTION = 3;
    private final Transaction _transaction;
    private final ObjectReference _reference;
    private int _updateDepth;
    private final boolean _isNew;
    private final BitMap4 _nullBitMap;
    private final MarshallingBuffer _writeBuffer;
    private MarshallingBuffer _currentBuffer;
    private int _fieldWriteCount;
    private BufferImpl _debugPrepend;
    private Object _currentMarshalledObject;
    private Object _currentIndexEntry;

    public MarshallingContext(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        this._transaction = transaction;
        this._reference = objectReference;
        this._nullBitMap = new BitMap4(this.fieldCount());
        this._updateDepth = this.classMetadata().adjustUpdateDepth(transaction, n);
        this._isNew = bl;
        this._currentBuffer = this._writeBuffer = new MarshallingBuffer();
    }

    private int fieldCount() {
        return this.classMetadata().fieldCount();
    }

    public ClassMetadata classMetadata() {
        return this._reference.classMetadata();
    }

    public boolean isNew() {
        return this._isNew;
    }

    public boolean isNull(int n) {
        return false;
    }

    public void isNull(int n, boolean bl) {
        this._nullBitMap.set(n, bl);
    }

    public Transaction transaction() {
        return this._transaction;
    }

    private Slot createNewSlot(int n) {
        Slot slot = new Slot(-1, n);
        if (this._transaction instanceof LocalTransaction) {
            slot = ((LocalTransaction)this._transaction).file().getSlot(n);
            this._transaction.slotFreeOnRollback(this.objectID(), slot);
        }
        this._transaction.setPointer(this.objectID(), slot);
        return slot;
    }

    private Slot createUpdateSlot(int n) {
        if (this.transaction() instanceof LocalTransaction) {
            return ((LocalTransaction)this.transaction()).file().getSlotForUpdate(this.transaction(), this.objectID(), n);
        }
        return new Slot(0, n);
    }

    public Pointer4 allocateSlot() {
        int n = this.container().blockAlignedBytes(this.marshalledLength());
        Slot slot = this.isNew() ? this.createNewSlot(n) : this.createUpdateSlot(n);
        return new Pointer4(this.objectID(), slot);
    }

    public BufferImpl ToWriteBuffer(Pointer4 pointer4) {
        BufferImpl bufferImpl = new BufferImpl(pointer4.length());
        this._writeBuffer.mergeChildren(this, pointer4.address(), this.writeBufferOffset());
        this.writeObjectClassID(bufferImpl, this.classMetadata().getID());
        bufferImpl.writeByte((byte)2);
        bufferImpl.writeInt(this.fieldCount());
        bufferImpl.writeBitMap(this._nullBitMap);
        this._writeBuffer.transferContentTo(bufferImpl);
        return bufferImpl;
    }

    private int writeBufferOffset() {
        return 9 + this._nullBitMap.marshalledLength();
    }

    private int marshalledLength() {
        int n = this.writeBufferOffset();
        this._writeBuffer.checkBlockAlignment(this, null, new IntByRef(n));
        return n + this._writeBuffer.marshalledLength() + 0;
    }

    public int requiredLength(MarshallingBuffer marshallingBuffer, boolean bl) {
        if (!bl) {
            return marshallingBuffer.length();
        }
        return this.container().blockAlignedBytes(marshallingBuffer.length());
    }

    private void writeObjectClassID(BufferImpl bufferImpl, int n) {
        bufferImpl.writeInt(-n);
    }

    public Object getObject() {
        return this._reference.getObject();
    }

    public Config4Class classConfiguration() {
        return this.classMetadata().config();
    }

    public int updateDepth() {
        return this._updateDepth;
    }

    public void updateDepth(int n) {
        this._updateDepth = n;
    }

    public int objectID() {
        return this._reference.getID();
    }

    public Object currentIndexEntry() {
        return null;
    }

    public ObjectContainerBase container() {
        return this.transaction().container();
    }

    public ObjectContainer objectContainer() {
        return this.transaction().objectContainer();
    }

    public void writeByte(byte by) {
        this.preWrite();
        this._currentBuffer.writeByte(by);
        this.postWrite();
    }

    public void writeBytes(byte[] byArray) {
        this.preWrite();
        this._currentBuffer.writeBytes(byArray);
        this.postWrite();
    }

    public void writeInt(int n) {
        this.preWrite();
        this._currentBuffer.writeInt(n);
        this.postWrite();
    }

    public void writeLong(long l) {
        this.preWrite();
        this._currentBuffer.writeLong(l);
        this.postWrite();
    }

    private void preWrite() {
        ++this._fieldWriteCount;
        if (this.isSecondWriteToField()) {
            this.createChildBuffer(true, true);
        }
    }

    private void postWrite() {
    }

    public void createChildBuffer(boolean bl, boolean bl2) {
        MarshallingBuffer marshallingBuffer = this._currentBuffer.addChild(false, bl2);
        if (bl) {
            this._currentBuffer.transferLastWriteTo(marshallingBuffer, bl2);
        }
        this._currentBuffer.reserveChildLinkSpace(bl2);
        this._currentBuffer = marshallingBuffer;
    }

    private boolean isSecondWriteToField() {
        return this._fieldWriteCount == 2;
    }

    public void nextField() {
        this._fieldWriteCount = 0;
        this._currentBuffer = this._writeBuffer;
    }

    public void fieldCount(int n) {
        this._writeBuffer.writeInt(n);
    }

    public void debugPrependNextWrite(BufferImpl bufferImpl) {
    }

    public void debugWriteEnd(byte by) {
        this._currentBuffer.writeByte(by);
    }

    public void writeObject(Object object) {
        int n = this.container().setInternal(this.transaction(), object, this._updateDepth, true);
        this.writeInt(n);
        this._currentMarshalledObject = object;
        this._currentIndexEntry = new Integer(n);
    }

    public void writeObject(TypeHandler4 typeHandler4, Object object) {
        MarshallingContextState marshallingContextState = this.currentState();
        if (object == null) {
            this.writeNullObject(typeHandler4);
        } else {
            this.createIndirection(typeHandler4);
            typeHandler4.write(this, object);
        }
        this.restoreState(marshallingContextState);
    }

    private void writeNullObject(TypeHandler4 typeHandler4) {
        if (this.handlerRegistry().isVariableLength(typeHandler4)) {
            this.doNotIndirectWrites();
            this.writeNullLink();
            return;
        }
        if (typeHandler4 instanceof PrimitiveHandler) {
            PrimitiveHandler primitiveHandler = (PrimitiveHandler)typeHandler4;
            typeHandler4.write(this, primitiveHandler.nullRepresentationInUntypedArrays());
            return;
        }
        typeHandler4.write(this, null);
    }

    private void writeNullLink() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void addIndexEntry(FieldMetadata fieldMetadata, Object object) {
        if (!this._currentBuffer.hasParent()) {
            Object object2 = object == this._currentMarshalledObject ? this._currentIndexEntry : object;
            fieldMetadata.addIndexEntry(this.transaction(), this.objectID(), object2);
            return;
        }
        this._currentBuffer.requestIndexEntry(fieldMetadata);
    }

    public ObjectReference reference() {
        return this._reference;
    }

    public void doNotIndirectWrites() {
        this._fieldWriteCount = 3;
    }

    public void prepareIndirectionOfSecondWrite() {
        this._fieldWriteCount = 0;
    }

    private HandlerRegistry handlerRegistry() {
        return this.container().handlers();
    }

    public void createIndirection(TypeHandler4 typeHandler4) {
        if (this.handlerRegistry().isVariableLength(typeHandler4)) {
            this.createChildBuffer(false, true);
            this.doNotIndirectWrites();
        }
    }

    public Buffer buffer() {
        return null;
    }

    public MarshallingContextState currentState() {
        return new MarshallingContextState(this._currentBuffer, this._fieldWriteCount);
    }

    public void restoreState(MarshallingContextState marshallingContextState) {
        this._currentBuffer = marshallingContextState._buffer;
        this._fieldWriteCount = marshallingContextState._fieldWriteCount;
    }
}

