/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.marshall.FieldMarshaller0;
import com.db4o.internal.marshall.RawFieldSpec;
import java.io.IOException;

public class FieldMarshaller1
extends FieldMarshaller0 {
    private boolean hasBTreeIndex(FieldMetadata fieldMetadata) {
        return !fieldMetadata.isVirtual();
    }

    public void write(Transaction transaction, ClassMetadata classMetadata, FieldMetadata fieldMetadata, BufferImpl bufferImpl) {
        super.write(transaction, classMetadata, fieldMetadata, bufferImpl);
        if (!this.hasBTreeIndex(fieldMetadata)) {
            return;
        }
        bufferImpl.writeIDOf(transaction, fieldMetadata.getIndex(transaction));
    }

    public RawFieldSpec readSpec(ObjectContainerBase objectContainerBase, BufferImpl bufferImpl) {
        RawFieldSpec rawFieldSpec = super.readSpec(objectContainerBase, bufferImpl);
        if (rawFieldSpec == null) {
            return null;
        }
        if (rawFieldSpec.isVirtual()) {
            return rawFieldSpec;
        }
        int n = bufferImpl.readInt();
        rawFieldSpec.indexID(n);
        return rawFieldSpec;
    }

    protected FieldMetadata fromSpec(RawFieldSpec rawFieldSpec, ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        FieldMetadata fieldMetadata2 = super.fromSpec(rawFieldSpec, objectContainerBase, fieldMetadata);
        if (rawFieldSpec == null) {
            return fieldMetadata;
        }
        if (rawFieldSpec.indexID() != 0) {
            fieldMetadata2.initIndex(objectContainerBase.systemTransaction(), rawFieldSpec.indexID());
        }
        return fieldMetadata2;
    }

    public int marshalledLength(ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        int n = super.marshalledLength(objectContainerBase, fieldMetadata);
        if (!this.hasBTreeIndex(fieldMetadata)) {
            return n;
        }
        return n + 4;
    }

    public void defrag(ClassMetadata classMetadata, FieldMetadata fieldMetadata, LatinStringIO latinStringIO, DefragmentContextImpl defragmentContextImpl) throws CorruptionException, IOException {
        super.defrag(classMetadata, fieldMetadata, latinStringIO, defragmentContextImpl);
        if (fieldMetadata.isVirtual()) {
            return;
        }
        if (fieldMetadata.hasIndex()) {
            BTree bTree = fieldMetadata.getIndex(defragmentContextImpl.systemTrans());
            int n = defragmentContextImpl.copyID();
            if (n != 0) {
                bTree.defragBTree(defragmentContextImpl.services());
            }
        } else {
            defragmentContextImpl.writeInt(0);
        }
    }
}

