/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.RawFieldSpec;
import java.io.IOException;

public class FieldMarshaller0
implements FieldMarshaller {
    public int marshalledLength(ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        int n = objectContainerBase.stringIO().shortLength(fieldMetadata.getName());
        if (fieldMetadata.needsArrayAndPrimitiveInfo()) {
            ++n;
        }
        if (fieldMetadata.needsHandlerId()) {
            n += 4;
        }
        return n;
    }

    public RawFieldSpec readSpec(ObjectContainerBase objectContainerBase, BufferImpl bufferImpl) {
        String string = StringHandler.readStringNoDebug(objectContainerBase.transaction().context(), bufferImpl);
        if (string.indexOf("v4o") == 0 && objectContainerBase._handlers.virtualFieldByName(string) != null) {
            return new RawFieldSpec(string);
        }
        int n = bufferImpl.readInt();
        byte by = bufferImpl.readByte();
        return new RawFieldSpec(string, n, by);
    }

    public final FieldMetadata read(ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata, BufferImpl bufferImpl) {
        RawFieldSpec rawFieldSpec = this.readSpec(objectContainerBase, bufferImpl);
        return this.fromSpec(rawFieldSpec, objectContainerBase, fieldMetadata);
    }

    protected FieldMetadata fromSpec(RawFieldSpec rawFieldSpec, ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        if (rawFieldSpec == null) {
            return fieldMetadata;
        }
        String string = rawFieldSpec.name();
        if (rawFieldSpec.isVirtual()) {
            return objectContainerBase._handlers.virtualFieldByName(string);
        }
        fieldMetadata.init(fieldMetadata.containingClass(), string);
        fieldMetadata.init(rawFieldSpec.handlerID(), rawFieldSpec.isPrimitive(), rawFieldSpec.isArray(), rawFieldSpec.isNArray());
        fieldMetadata.loadHandler(objectContainerBase);
        fieldMetadata.alive();
        return fieldMetadata;
    }

    public void write(Transaction transaction, ClassMetadata classMetadata, FieldMetadata fieldMetadata, BufferImpl bufferImpl) {
        fieldMetadata.alive();
        bufferImpl.writeShortString(transaction, fieldMetadata.getName());
        if (fieldMetadata.isVirtual()) {
            return;
        }
        TypeHandler4 typeHandler4 = fieldMetadata.getHandler();
        if (typeHandler4 instanceof ClassMetadata && ((ClassMetadata)typeHandler4).getID() == 0) {
            transaction.container().needsUpdate(classMetadata);
        }
        bufferImpl.writeInt(fieldMetadata.handlerID());
        BitMap4 bitMap4 = new BitMap4(3);
        bitMap4.set(0, fieldMetadata.isPrimitive());
        bitMap4.set(1, typeHandler4 instanceof ArrayHandler);
        bitMap4.set(2, typeHandler4 instanceof MultidimensionalArrayHandler);
        bufferImpl.writeByte(bitMap4.getByte(0));
    }

    public void defrag(ClassMetadata classMetadata, FieldMetadata fieldMetadata, LatinStringIO latinStringIO, DefragmentContextImpl defragmentContextImpl) throws CorruptionException, IOException {
        defragmentContextImpl.incrementStringOffset(latinStringIO);
        if (fieldMetadata.isVirtual()) {
            return;
        }
        defragmentContextImpl.copyID();
        defragmentContextImpl.incrementOffset(1);
    }
}

