/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;
import java.io.IOException;

public abstract class ClassMarshaller {
    public MarshallerFamily _family;

    public RawClassSpec readSpec(Transaction transaction, BufferImpl bufferImpl) {
        byte[] byArray = this.readName(transaction, bufferImpl);
        String string = transaction.container().stringIO().read(byArray);
        this.readMetaClassID(bufferImpl);
        int n = bufferImpl.readInt();
        bufferImpl.incrementOffset(4);
        int n2 = bufferImpl.readInt();
        return new RawClassSpec(string, n, n2);
    }

    public void write(Transaction transaction, ClassMetadata classMetadata, BufferImpl bufferImpl) {
        bufferImpl.writeShortString(transaction, classMetadata.nameToWrite());
        int n = 0;
        bufferImpl.writeInt(n);
        bufferImpl.writeIDOf(transaction, classMetadata.i_ancestor);
        this.writeIndex(transaction, classMetadata, bufferImpl);
        FieldMetadata[] fieldMetadataArray = classMetadata.i_fields;
        if (fieldMetadataArray == null) {
            bufferImpl.writeInt(0);
            return;
        }
        bufferImpl.writeInt(fieldMetadataArray.length);
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            this._family._field.write(transaction, classMetadata, fieldMetadataArray[i], bufferImpl);
        }
    }

    protected void writeIndex(Transaction transaction, ClassMetadata classMetadata, BufferImpl bufferImpl) {
        int n = classMetadata.index().write(transaction);
        bufferImpl.writeInt(this.indexIDForWriting(n));
    }

    protected abstract int indexIDForWriting(int var1);

    public byte[] readName(Transaction transaction, BufferImpl bufferImpl) {
        byte[] byArray = this.readName(transaction.container().stringIO(), bufferImpl);
        return byArray;
    }

    public int readMetaClassID(BufferImpl bufferImpl) {
        return bufferImpl.readInt();
    }

    private byte[] readName(LatinStringIO latinStringIO, BufferImpl bufferImpl) {
        int n = bufferImpl.readInt();
        byte[] byArray = new byte[n *= latinStringIO.bytesPerChar()];
        System.arraycopy(bufferImpl._buffer, bufferImpl._offset, byArray, 0, n);
        byArray = Platform4.updateClassName(byArray);
        bufferImpl.incrementOffset(n);
        return byArray;
    }

    public final void read(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, BufferImpl bufferImpl) {
        classMetadata.setAncestor(objectContainerBase.classMetadataForId(bufferImpl.readInt()));
        if (classMetadata.callConstructor()) {
            classMetadata.createConstructor(objectContainerBase, classMetadata.classReflector(), classMetadata.getName(), true);
        }
        classMetadata.checkType();
        this.readIndex(objectContainerBase, classMetadata, bufferImpl);
        classMetadata.i_fields = this.createFields(classMetadata, bufferImpl.readInt());
        this.readFields(objectContainerBase, bufferImpl, classMetadata.i_fields);
    }

    protected abstract void readIndex(ObjectContainerBase var1, ClassMetadata var2, BufferImpl var3);

    private FieldMetadata[] createFields(ClassMetadata classMetadata, int n) {
        FieldMetadata[] fieldMetadataArray = new FieldMetadata[n];
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            fieldMetadataArray[i] = new FieldMetadata(classMetadata);
            fieldMetadataArray[i].setArrayPosition(i);
        }
        return fieldMetadataArray;
    }

    private void readFields(ObjectContainerBase objectContainerBase, BufferImpl bufferImpl, FieldMetadata[] fieldMetadataArray) {
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            fieldMetadataArray[i] = this._family._field.read(objectContainerBase, fieldMetadataArray[i], bufferImpl);
        }
    }

    public int marshalledLength(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata) {
        int n = objectContainerBase.stringIO().shortLength(classMetadata.nameToWrite()) + 0 + 8 + 4;
        n += classMetadata.index().ownLength();
        if (classMetadata.i_fields != null) {
            for (int i = 0; i < classMetadata.i_fields.length; ++i) {
                n += this._family._field.marshalledLength(objectContainerBase, classMetadata.i_fields[i]);
            }
        }
        return n;
    }

    public void defrag(ClassMetadata classMetadata, LatinStringIO latinStringIO, DefragmentContextImpl defragmentContextImpl, int n) throws CorruptionException, IOException {
        this.readName(latinStringIO, defragmentContextImpl.source());
        this.readName(latinStringIO, defragmentContextImpl.target());
        int n2 = 0;
        defragmentContextImpl.writeInt(n2);
        defragmentContextImpl.copyID();
        defragmentContextImpl.writeInt(this.indexIDForWriting(n));
        defragmentContextImpl.incrementIntSize();
        FieldMetadata[] fieldMetadataArray = classMetadata.i_fields;
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            this._family._field.defrag(classMetadata, fieldMetadataArray[i], latinStringIO, defragmentContextImpl);
        }
    }
}

