/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.ext.Db4oIOException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.Comparable4;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.DeleteContext;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Null;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public abstract class StringHandler
extends VariableLengthTypeHandler
implements IndexableTypeHandler,
BuiltinTypeHandler {
    private BufferImpl i_compareTo;

    public StringHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    protected StringHandler(TypeHandler4 typeHandler4) {
        this(((StringHandler)typeHandler4).container());
    }

    public ReflectClass classReflector() {
        return this.container()._handlers.ICLASS_STRING;
    }

    public void delete(DeleteContext deleteContext) {
        deleteContext.readSlot();
    }

    byte getIdentifier() {
        return 83;
    }

    public Object indexEntryToObject(Transaction transaction, Object object) {
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            object = this.container().bufferByAddress(slot.address(), slot.length());
        }
        return StringHandler.readStringNoDebug(transaction.context(), (ReadBuffer)object);
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException, Db4oIOException {
        return marshallerFamily._string.readIndexEntry(statefulBuffer);
    }

    public Object readIndexEntry(BufferImpl bufferImpl) {
        Slot slot = new Slot(bufferImpl.readInt(), bufferImpl.readInt());
        if (this.isInvalidSlot(slot)) {
            return null;
        }
        return slot;
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot.address() == 0 && slot.length() == 0;
    }

    public void writeIndexEntry(BufferImpl bufferImpl, Object object) {
        if (object == null) {
            bufferImpl.writeInt(0);
            bufferImpl.writeInt(0);
            return;
        }
        if (object instanceof StatefulBuffer) {
            StatefulBuffer statefulBuffer = (StatefulBuffer)object;
            bufferImpl.writeInt(statefulBuffer.getAddress());
            bufferImpl.writeInt(statefulBuffer.length());
            return;
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            bufferImpl.writeInt(slot.address());
            bufferImpl.writeInt(slot.length());
            return;
        }
        throw new IllegalArgumentException();
    }

    public final void writeShort(Transaction transaction, String string, BufferImpl bufferImpl) {
        if (string == null) {
            bufferImpl.writeInt(0);
        } else {
            bufferImpl.writeInt(string.length());
            transaction.container().handlers().stringIO().write(bufferImpl, string);
        }
    }

    private BufferImpl val(Object object) {
        return this.val(object, this.container());
    }

    public BufferImpl val(Object object, ObjectContainerBase objectContainerBase) {
        if (object instanceof BufferImpl) {
            return (BufferImpl)object;
        }
        if (object instanceof String) {
            return StringHandler.writeToBuffer((InternalObjectContainer)((Object)objectContainerBase), (String)object);
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            return objectContainerBase.bufferByAddress(slot.address(), slot.length());
        }
        return null;
    }

    public Comparable4 prepareComparison(Object object) {
        if (object == null) {
            this.i_compareTo = null;
            return Null.INSTANCE;
        }
        this.i_compareTo = this.val(object);
        return this;
    }

    public int compareTo(Object object) {
        if (this.i_compareTo == null) {
            if (object == null) {
                return 0;
            }
            return 1;
        }
        return this.compare(this.i_compareTo, this.val(object));
    }

    final int compare(BufferImpl bufferImpl, BufferImpl bufferImpl2) {
        if (bufferImpl == null) {
            if (bufferImpl2 == null) {
                return 0;
            }
            return 1;
        }
        if (bufferImpl2 == null) {
            return -1;
        }
        return StringHandler.compare(bufferImpl._buffer, bufferImpl2._buffer);
    }

    public static final int compare(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i = n = 4; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray2[i] - byArray[i];
        }
        return byArray2.length - byArray.length;
    }

    public void defragIndexEntry(DefragmentContextImpl defragmentContextImpl) {
        defragmentContextImpl.copyID(false, true);
        defragmentContextImpl.incrementIntSize();
    }

    public abstract void defragment(DefragmentContext var1);

    public abstract Object read(ReadContext var1);

    public void write(WriteContext writeContext, Object object) {
        StringHandler.internalWrite((InternalObjectContainer)writeContext.objectContainer(), writeContext, (String)object);
    }

    protected static void internalWrite(InternalObjectContainer internalObjectContainer, WriteBuffer writeBuffer, String string) {
        writeBuffer.writeInt(string.length());
        StringHandler.stringIo(internalObjectContainer).write(writeBuffer, string);
    }

    public static BufferImpl writeToBuffer(InternalObjectContainer internalObjectContainer, String string) {
        BufferImpl bufferImpl = new BufferImpl(StringHandler.stringIo(internalObjectContainer).length(string));
        StringHandler.internalWrite(internalObjectContainer, bufferImpl, string);
        return bufferImpl;
    }

    protected static LatinStringIO stringIo(Context context) {
        return StringHandler.stringIo((InternalObjectContainer)context.objectContainer());
    }

    protected static LatinStringIO stringIo(InternalObjectContainer internalObjectContainer) {
        return internalObjectContainer.container().stringIO();
    }

    public static String readString(Context context, ReadBuffer readBuffer) {
        String string = StringHandler.readStringNoDebug(context, readBuffer);
        return string;
    }

    public static String readStringNoDebug(Context context, ReadBuffer readBuffer) {
        int n = readBuffer.readInt();
        if (n > 0) {
            return StringHandler.intern(context, StringHandler.stringIo(context).read(readBuffer, n));
        }
        return "";
    }

    protected static String intern(Context context, String string) {
        if (context.objectContainer().ext().configure().internStrings()) {
            return string.intern();
        }
        return string;
    }
}

