/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public class LongHandler
extends PrimitiveHandler {
    private static final Long i_primitive = new Long(0L);
    private long i_compareTo;

    public LongHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toLong(object);
    }

    public Object defaultValue() {
        return i_primitive;
    }

    protected Class primitiveJavaClass() {
        return Long.TYPE;
    }

    public int linkLength() {
        return 8;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._primitive.readLong(statefulBuffer);
    }

    Object read1(BufferImpl bufferImpl) {
        return new Long(bufferImpl.readLong());
    }

    public void write(Object object, BufferImpl bufferImpl) {
        LongHandler.writeLong(bufferImpl, (Long)object);
    }

    public static final void writeLong(WriteBuffer writeBuffer, long l) {
        for (int i = 0; i < 8; ++i) {
            writeBuffer.writeByte((byte)(l >> (7 - i) * 8));
        }
    }

    public static final long readLong(ReadBuffer readBuffer) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = (l << 8) + (long)(readBuffer.readByte() & 0xFF);
        }
        return l;
    }

    protected final long currentLong() {
        return this.i_compareTo;
    }

    long val(Object object) {
        return (Long)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    boolean isEqual1(Object object) {
        return object instanceof Long && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        return object instanceof Long && this.val(object) > this.i_compareTo;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Long && this.val(object) < this.i_compareTo;
    }

    public Object read(ReadContext readContext) {
        return new Long(readContext.readLong());
    }

    public void write(WriteContext writeContext, Object object) {
        writeContext.writeLong((Long)object);
    }
}

