/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public class DoubleHandler
extends LongHandler {
    private static final Double DEFAULT_VALUE = new Double(0.0);
    private double i_compareToDouble;

    public DoubleHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toDouble(object);
    }

    public Object defaultValue() {
        return DEFAULT_VALUE;
    }

    protected Class primitiveJavaClass() {
        return Double.TYPE;
    }

    public Object primitiveNull() {
        return DEFAULT_VALUE;
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._primitive.readDouble(statefulBuffer);
    }

    Object read1(BufferImpl bufferImpl) {
        return this.primitiveMarshaller().readDouble(bufferImpl);
    }

    public void write(Object object, BufferImpl bufferImpl) {
        bufferImpl.writeLong(Platform4.doubleToLong((Double)object));
    }

    private double dval(Object object) {
        return (Double)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareToDouble = this.dval(object);
    }

    boolean isEqual1(Object object) {
        return object instanceof Double && this.dval(object) == this.i_compareToDouble;
    }

    boolean isGreater1(Object object) {
        return object instanceof Double && this.dval(object) > this.i_compareToDouble;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Double && this.dval(object) < this.i_compareToDouble;
    }

    public Object read(ReadContext readContext) {
        Long l = (Long)super.read(readContext);
        return new Double(Platform4.longToDouble(l));
    }

    public void write(WriteContext writeContext, Object object) {
        writeContext.writeLong(Platform4.doubleToLong((Double)object));
    }
}

