/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.DTrace;
import com.db4o.MetaIndex;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IntObjectVisitor;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreespaceIxAddress;
import com.db4o.internal.freespace.FreespaceIxLength;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ix.IxTree;
import com.db4o.internal.slots.Slot;

public class FreespaceManagerIx
extends AbstractFreespaceManager {
    private int _slotAddress;
    private FreespaceIxAddress _addressIx;
    private FreespaceIxLength _lengthIx;
    private boolean _started;
    private Collection4 _xBytes;
    private final boolean _overwriteDeletedSlots;

    public FreespaceManagerIx(LocalObjectContainer localObjectContainer) {
        super(localObjectContainer);
        this._overwriteDeletedSlots = localObjectContainer.config().freespaceFiller() != null;
    }

    private void add(int n, int n2) {
        this._addressIx.add(n, n2);
        this._lengthIx.add(n, n2);
    }

    public Slot allocateTransactionLogSlot(int n) {
        return this.getSlot(n);
    }

    public void freeTransactionLogSlot(Slot slot) {
        this.free(slot);
    }

    public void beginCommit() {
        if (!this.started()) {
            return;
        }
        AbstractFreespaceManager.slotEntryToZeroes(this._file, this._slotAddress);
    }

    public void endCommit() {
        if (!this.started()) {
            return;
        }
        if (this._overwriteDeletedSlots) {
            this._xBytes = new Collection4();
        }
        this._addressIx._index.commitFreeSpace(this._lengthIx._index);
        StatefulBuffer statefulBuffer = new StatefulBuffer(this._file.systemTransaction(), this._slotAddress, AbstractFreespaceManager.slotLength());
        this._addressIx._index._metaIndex.write(statefulBuffer);
        this._lengthIx._index._metaIndex.write(statefulBuffer);
        if (this._overwriteDeletedSlots) {
            statefulBuffer.setID(-99999);
        }
        if (this._file.configImpl().flushFileBuffers()) {
            this._file.syncFiles();
        }
        statefulBuffer.writeEncrypt();
        if (this._overwriteDeletedSlots) {
            Iterator4 iterator4 = this._xBytes.iterator();
            this._xBytes = null;
            while (iterator4.moveNext()) {
                Slot slot = (Slot)iterator4.current();
                this.overwriteDeletedSlot(slot);
            }
        }
    }

    public int slotCount() {
        return this._addressIx.entryCount();
    }

    public void free(Slot slot) {
        int n = slot.address();
        int n2 = slot.length();
        if (!this.started()) {
            return;
        }
        if (n <= 0) {
            return;
        }
        if (this.canDiscard(n2)) {
            return;
        }
        if (DTrace.enabled) {
            DTrace.FREE.logLength(n, n2);
        }
        int n3 = n;
        int n4 = n2;
        this._addressIx.find(n);
        if (this._addressIx.preceding() && this._addressIx.address() + this._addressIx.length() == n) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n = this._addressIx.address();
            n2 += this._addressIx.length();
            this._addressIx.find(n3);
        }
        if (this._addressIx.subsequent() && n3 + n4 == this._addressIx.address()) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n2 += this._addressIx.length();
        }
        this.add(n, n2);
        if (this._overwriteDeletedSlots) {
            this.overwriteDeletedSlot(new Slot(n3, n4));
        }
    }

    public void freeSelf() {
        if (!this.started()) {
            return;
        }
        this._addressIx._index._metaIndex.free(this._file);
        this._lengthIx._index._metaIndex.free(this._file);
    }

    public Slot getSlot(int n) {
        if (!this.started()) {
            return null;
        }
        int n2 = 0;
        this._lengthIx.find(n);
        if (this._lengthIx.match()) {
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            n2 = this._lengthIx.address();
        } else if (this._lengthIx.subsequent()) {
            int n3 = this._lengthIx.length() - n;
            int n4 = this._lengthIx.address() + n;
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            this.add(n4, n3);
            n2 = this._lengthIx.address();
        }
        if (n2 == 0) {
            return null;
        }
        if (DTrace.enabled) {
            DTrace.GET_FREESPACE.logLength(n2, n);
        }
        return new Slot(n2, n);
    }

    public void migrateTo(FreespaceManager freespaceManager) {
        if (!this.started()) {
            return;
        }
        super.migrateTo(freespaceManager);
    }

    public void traverse(final Visitor4 visitor4) {
        if (!this.started()) {
            return;
        }
        final IntObjectVisitor intObjectVisitor = new IntObjectVisitor(){

            public void visit(int n, Object object) {
                visitor4.visit(new Slot((Integer)object, n));
            }
        };
        Tree.traverse(this._addressIx._indexTrans.getRoot(), new Visitor4(){

            public void visit(Object object) {
                IxTree ixTree = (IxTree)object;
                ixTree.visitAll(intObjectVisitor);
            }
        });
    }

    public int onNew(LocalObjectContainer localObjectContainer) {
        return localObjectContainer.ensureFreespaceSlot();
    }

    public void read(int n) {
    }

    private void remove(int n, int n2) {
        this._addressIx.remove(n, n2);
        this._lengthIx.remove(n, n2);
    }

    public void start(int n) {
        if (this.started()) {
            return;
        }
        this._slotAddress = n;
        MetaIndex metaIndex = new MetaIndex();
        MetaIndex metaIndex2 = new MetaIndex();
        BufferImpl bufferImpl = new BufferImpl(AbstractFreespaceManager.slotLength());
        bufferImpl.read(this._file, n, 0);
        metaIndex.read(bufferImpl);
        metaIndex2.read(bufferImpl);
        this._addressIx = new FreespaceIxAddress(this._file, metaIndex);
        this._lengthIx = new FreespaceIxLength(this._file, metaIndex2);
        this._started = true;
    }

    private boolean started() {
        return this._started;
    }

    public byte systemType() {
        return 3;
    }

    public int write() {
        return 0;
    }

    private void overwriteDeletedSlot(Slot slot) {
        if (this._overwriteDeletedSlots) {
            if (this._xBytes == null) {
                this._file.overwriteDeletedBlockedSlot(slot);
            } else {
                this._xBytes.add(slot);
            }
        }
    }

    public String toString() {
        String string = "FreespaceManagerIx\n" + this._lengthIx.toString();
        return string;
    }

    public void commit() {
    }
}

