/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.BTreeFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.FreespaceManagerIx;
import com.db4o.internal.freespace.RamFreespaceManager;
import com.db4o.internal.slots.Slot;

public abstract class AbstractFreespaceManager
implements FreespaceManager {
    final LocalObjectContainer _file;
    public static final byte FM_DEBUG = 127;
    public static final byte FM_DEFAULT = 0;
    public static final byte FM_LEGACY_RAM = 1;
    public static final byte FM_RAM = 2;
    public static final byte FM_IX = 3;
    public static final byte FM_BTREE = 4;
    private static final int INTS_IN_SLOT = 12;

    public AbstractFreespaceManager(LocalObjectContainer localObjectContainer) {
        this._file = localObjectContainer;
    }

    public static byte checkType(byte by) {
        if (by == 0) {
            return 2;
        }
        return by;
    }

    public static AbstractFreespaceManager createNew(LocalObjectContainer localObjectContainer) {
        return AbstractFreespaceManager.createNew(localObjectContainer, localObjectContainer.systemData().freespaceSystem());
    }

    public abstract int onNew(LocalObjectContainer var1);

    public static AbstractFreespaceManager createNew(LocalObjectContainer localObjectContainer, byte by) {
        by = AbstractFreespaceManager.checkType(by);
        switch (by) {
            case 3: {
                return new FreespaceManagerIx(localObjectContainer);
            }
            case 4: {
                return new BTreeFreespaceManager(localObjectContainer);
            }
        }
        return new RamFreespaceManager(localObjectContainer);
    }

    public static int initSlot(LocalObjectContainer localObjectContainer) {
        int n = localObjectContainer.getSlot(AbstractFreespaceManager.slotLength()).address();
        AbstractFreespaceManager.slotEntryToZeroes(localObjectContainer, n);
        return n;
    }

    public void migrateTo(final FreespaceManager freespaceManager) {
        this.traverse(new Visitor4(){

            public void visit(Object object) {
                freespaceManager.free((Slot)object);
            }
        });
    }

    static void slotEntryToZeroes(LocalObjectContainer localObjectContainer, int n) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(localObjectContainer.systemTransaction(), n, AbstractFreespaceManager.slotLength());
        for (int i = 0; i < 12; ++i) {
            statefulBuffer.writeInt(0);
        }
        statefulBuffer.writeEncrypt();
    }

    static final int slotLength() {
        return 48;
    }

    public int totalFreespace() {
        final IntByRef intByRef = new IntByRef();
        this.traverse(new Visitor4(){

            public void visit(Object object) {
                Slot slot = (Slot)object;
                intByRef.value += slot.length();
            }
        });
        return intByRef.value;
    }

    public abstract void beginCommit();

    protected final int blockedDiscardLimit() {
        return this._file.blocksToBytes(this.discardLimit());
    }

    protected int discardLimit() {
        return this._file.configImpl().discardFreeSpace();
    }

    final boolean canDiscard(int n) {
        return n == 0 || n < this.blockedDiscardLimit();
    }

    public static void migrate(FreespaceManager freespaceManager, FreespaceManager freespaceManager2) {
        freespaceManager.migrateTo(freespaceManager2);
        freespaceManager.freeSelf();
        freespaceManager2.beginCommit();
        freespaceManager2.endCommit();
    }

    public void debugCheckIntegrity() {
        final IntByRef intByRef = new IntByRef();
        final IntByRef intByRef2 = new IntByRef();
        this.traverse(new Visitor4(){

            public void visit(Object object) {
                Slot slot = (Slot)object;
                if (slot.address() <= intByRef2.value) {
                    throw new IllegalStateException();
                }
                intByRef.value = slot.address();
                intByRef2.value = slot.address() + slot.length();
            }
        });
    }

    protected final LocalTransaction transaction() {
        return (LocalTransaction)this._file.systemTransaction();
    }

    public abstract /* synthetic */ void freeTransactionLogSlot(Slot var1);

    public abstract /* synthetic */ Slot allocateTransactionLogSlot(int var1);

    public abstract /* synthetic */ void commit();

    public abstract /* synthetic */ int write();

    public abstract /* synthetic */ void traverse(Visitor4 var1);

    public abstract /* synthetic */ byte systemType();

    public abstract /* synthetic */ void start(int var1);

    public abstract /* synthetic */ void read(int var1);

    public abstract /* synthetic */ Slot getSlot(int var1);

    public abstract /* synthetic */ void freeSelf();

    public abstract /* synthetic */ void free(Slot var1);

    public abstract /* synthetic */ int slotCount();

    public abstract /* synthetic */ void endCommit();
}

