/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeaderVariablePart1;
import com.db4o.internal.fileheader.TimerFileLock;

public class FileHeader1
extends FileHeader {
    private static final byte[] SIGNATURE = new byte[]{100, 98, 52, 111};
    private static byte VERSION = 1;
    private static final int HEADER_LOCK_OFFSET = SIGNATURE.length + 1;
    private static final int OPEN_TIME_OFFSET = HEADER_LOCK_OFFSET + 4;
    private static final int ACCESS_TIME_OFFSET = OPEN_TIME_OFFSET + 8;
    private static final int TRANSACTION_POINTER_OFFSET = ACCESS_TIME_OFFSET + 8;
    public static final int LENGTH = TRANSACTION_POINTER_OFFSET + 24;
    private TimerFileLock _timerFileLock;
    private Transaction _interruptedTransaction;
    private FileHeaderVariablePart1 _variablePart;

    public void close() throws Db4oIOException {
        this._timerFileLock.close();
    }

    public void initNew(LocalObjectContainer localObjectContainer) throws Db4oIOException {
        this.commonTasksForNewAndRead(localObjectContainer);
        this._variablePart = new FileHeaderVariablePart1(0, localObjectContainer.systemData());
        this.writeVariablePart(localObjectContainer, 0);
    }

    protected FileHeader newOnSignatureMatch(LocalObjectContainer localObjectContainer, BufferImpl bufferImpl) {
        if (this.signatureMatches(bufferImpl, SIGNATURE, VERSION)) {
            return new FileHeader1();
        }
        return null;
    }

    private void newTimerFileLock(LocalObjectContainer localObjectContainer) {
        this._timerFileLock = TimerFileLock.forFile(localObjectContainer);
        this._timerFileLock.setAddresses(0, OPEN_TIME_OFFSET, ACCESS_TIME_OFFSET);
    }

    public Transaction interruptedTransaction() {
        return this._interruptedTransaction;
    }

    public int length() {
        return LENGTH;
    }

    protected void readFixedPart(LocalObjectContainer localObjectContainer, BufferImpl bufferImpl) {
        this.commonTasksForNewAndRead(localObjectContainer);
        this.checkThreadFileLock(localObjectContainer, bufferImpl);
        bufferImpl.seek(TRANSACTION_POINTER_OFFSET);
        this._interruptedTransaction = LocalTransaction.readInterruptedTransaction(localObjectContainer, bufferImpl);
        localObjectContainer.blockSizeReadFromFile(bufferImpl.readInt());
        this.readClassCollectionAndFreeSpace(localObjectContainer, bufferImpl);
        this._variablePart = new FileHeaderVariablePart1(bufferImpl.readInt(), localObjectContainer.systemData());
    }

    private void checkThreadFileLock(LocalObjectContainer localObjectContainer, BufferImpl bufferImpl) {
        bufferImpl.seek(ACCESS_TIME_OFFSET);
        long l = bufferImpl.readLong();
        if (FileHeader.lockedByOtherSession(localObjectContainer, l)) {
            this._timerFileLock.checkIfOtherSessionAlive(localObjectContainer, 0, ACCESS_TIME_OFFSET, l);
        }
    }

    private void commonTasksForNewAndRead(LocalObjectContainer localObjectContainer) {
        this.newTimerFileLock(localObjectContainer);
        localObjectContainer._handlers.oldEncryptionOff();
    }

    public void readVariablePart(LocalObjectContainer localObjectContainer) {
        this._variablePart.read(localObjectContainer.systemTransaction());
    }

    public void writeFixedPart(LocalObjectContainer localObjectContainer, boolean bl, boolean bl2, StatefulBuffer statefulBuffer, int n, int n2) {
        statefulBuffer.append(SIGNATURE);
        statefulBuffer.writeByte(VERSION);
        statefulBuffer.writeInt((int)this.timeToWrite(this._timerFileLock.openTime(), bl2));
        statefulBuffer.writeLong(this.timeToWrite(this._timerFileLock.openTime(), bl2));
        statefulBuffer.writeLong(this.timeToWrite(System.currentTimeMillis(), bl2));
        statefulBuffer.writeInt(0);
        statefulBuffer.writeInt(0);
        statefulBuffer.writeInt(n);
        statefulBuffer.writeInt(localObjectContainer.systemData().classCollectionID());
        statefulBuffer.writeInt(n2);
        statefulBuffer.writeInt(this._variablePart.getID());
        statefulBuffer.noXByteCheck();
        statefulBuffer.write();
        localObjectContainer.syncFiles();
        if (bl) {
            this._timerFileLock.start();
        }
    }

    public void writeTransactionPointer(Transaction transaction, int n) {
        this.writeTransactionPointer(transaction, n, 0, TRANSACTION_POINTER_OFFSET);
    }

    public void writeVariablePart(LocalObjectContainer localObjectContainer, int n) {
        this._variablePart.setStateDirty();
        this._variablePart.write(localObjectContainer.systemTransaction());
    }
}

