/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.MetaIndex;
import com.db4o.PBootRecord;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.OldFormatException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ConfigBlock;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;

public class FileHeader0
extends FileHeader {
    static final int LENGTH = 18;
    private ConfigBlock _configBlock;
    private PBootRecord _bootRecord;

    public void close() throws Db4oIOException {
        this._configBlock.close();
    }

    protected FileHeader newOnSignatureMatch(LocalObjectContainer localObjectContainer, BufferImpl bufferImpl) {
        byte by = bufferImpl.readByte();
        if (by != 123) {
            if (by != 4) {
                return null;
            }
            localObjectContainer.blockSizeReadFromFile(bufferImpl.readByte());
        } else if (bufferImpl.readByte() != 89) {
            return null;
        }
        return new FileHeader0();
    }

    protected void readFixedPart(LocalObjectContainer localObjectContainer, BufferImpl bufferImpl) throws OldFormatException {
        this._configBlock = ConfigBlock.forExistingFile(localObjectContainer, bufferImpl.readInt());
        this.skipConfigurationLockTime(bufferImpl);
        this.readClassCollectionAndFreeSpace(localObjectContainer, bufferImpl);
    }

    private void skipConfigurationLockTime(BufferImpl bufferImpl) {
        bufferImpl.incrementOffset(4);
    }

    public void readVariablePart(LocalObjectContainer localObjectContainer) {
        if (this._configBlock._bootRecordID <= 0) {
            return;
        }
        Object object = this.getBootRecord(localObjectContainer);
        if (!(object instanceof PBootRecord)) {
            this.initBootRecord(localObjectContainer);
            localObjectContainer.generateNewIdentity();
            return;
        }
        this._bootRecord = (PBootRecord)object;
        localObjectContainer.activate(object, Integer.MAX_VALUE);
        localObjectContainer.setNextTimeStampId(this._bootRecord.i_versionGenerator);
        localObjectContainer.systemData().identity(this._bootRecord.i_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBootRecord(LocalObjectContainer localObjectContainer) {
        localObjectContainer.showInternalClasses(true);
        try {
            Object object = localObjectContainer.getByID(localObjectContainer.systemTransaction(), this._configBlock._bootRecordID);
            return object;
        }
        finally {
            localObjectContainer.showInternalClasses(false);
        }
    }

    public void initNew(LocalObjectContainer localObjectContainer) throws Db4oIOException {
        this._configBlock = ConfigBlock.forNewFile(localObjectContainer);
        this.initBootRecord(localObjectContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBootRecord(LocalObjectContainer localObjectContainer) {
        localObjectContainer.showInternalClasses(true);
        try {
            this._bootRecord = new PBootRecord();
            localObjectContainer.setInternal(localObjectContainer.systemTransaction(), this._bootRecord, false);
            this._configBlock._bootRecordID = localObjectContainer.getID(localObjectContainer.systemTransaction(), this._bootRecord);
            this.writeVariablePart(localObjectContainer, 1);
        }
        finally {
            localObjectContainer.showInternalClasses(false);
        }
    }

    public Transaction interruptedTransaction() {
        return this._configBlock.getTransactionToCommit();
    }

    public void writeTransactionPointer(Transaction transaction, int n) {
        this.writeTransactionPointer(transaction, n, this._configBlock.address(), 21);
    }

    public MetaIndex getUUIDMetaIndex() {
        return this._bootRecord.getUUIDMetaIndex();
    }

    public int length() {
        return 18;
    }

    public void writeFixedPart(LocalObjectContainer localObjectContainer, boolean bl, boolean bl2, StatefulBuffer statefulBuffer, int n, int n2) {
        statefulBuffer.writeByte((byte)4);
        statefulBuffer.writeByte((byte)n);
        statefulBuffer.writeInt(this._configBlock.address());
        statefulBuffer.writeInt((int)this.timeToWrite(this._configBlock.openTime(), bl2));
        statefulBuffer.writeInt(localObjectContainer.systemData().classCollectionID());
        statefulBuffer.writeInt(n2);
        statefulBuffer.write();
        localObjectContainer.syncFiles();
    }

    public void writeVariablePart(LocalObjectContainer localObjectContainer, int n) {
        if (n == 1) {
            this._configBlock.write();
        } else if (n == 2) {
            this._bootRecord.write(localObjectContainer);
        }
    }
}

