/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.fieldindex.IndexedNode;
import com.db4o.internal.fieldindex.IndexedPath;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConObject;

public abstract class IndexedNodeBase
implements IndexedNode {
    private final QConObject _constraint;

    public IndexedNodeBase(QConObject qConObject) {
        if (null == qConObject) {
            throw new ArgumentNullException();
        }
        if (null == qConObject.getField()) {
            throw new IllegalArgumentException();
        }
        this._constraint = qConObject;
    }

    public TreeInt toTreeInt() {
        return IndexedNodeBase.addToTree(null, this);
    }

    public final BTree getIndex() {
        return this.getYapField().getIndex(this.transaction());
    }

    private FieldMetadata getYapField() {
        return this._constraint.getField().getYapField();
    }

    public QCon constraint() {
        return this._constraint;
    }

    public boolean isResolved() {
        QCon qCon = this.constraint().parent();
        return null == qCon || !qCon.hasParent();
    }

    public BTreeRange search(Object object) {
        return this.getYapField().search(this.transaction(), object);
    }

    public static TreeInt addToTree(TreeInt treeInt, IndexedNode indexedNode) {
        Iterator4 iterator4 = indexedNode.iterator();
        while (iterator4.moveNext()) {
            FieldIndexKey fieldIndexKey = (FieldIndexKey)iterator4.current();
            treeInt = (TreeInt)Tree.add(treeInt, new TreeInt(fieldIndexKey.parentID()));
        }
        return treeInt;
    }

    public IndexedNode resolve() {
        if (this.isResolved()) {
            return null;
        }
        return IndexedPath.newParentPath(this, this.constraint());
    }

    private Transaction transaction() {
        return this.constraint().transaction();
    }

    public abstract /* synthetic */ int resultSize();

    public abstract /* synthetic */ Iterator4 iterator();
}

