/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.cs.LazyClientObjectSetStub;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import com.db4o.internal.query.result.AbstractQueryResult;

public abstract class MsgQuery
extends MsgObject {
    private static final int ID_AND_SIZE = 2;
    private static int nextID;

    protected final void writeQueryResult(AbstractQueryResult abstractQueryResult, QueryEvaluationMode queryEvaluationMode) {
        int n = 0;
        int n2 = 0;
        if (queryEvaluationMode == QueryEvaluationMode.IMMEDIATE) {
            n2 = abstractQueryResult.size();
        } else {
            n = MsgQuery.generateID();
            n2 = this.config().prefetchObjectCount();
        }
        MsgD msgD = Msg.QUERY_RESULT.getWriterForLength(this.transaction(), this.bufferLength(n2));
        StatefulBuffer statefulBuffer = msgD.payLoad();
        statefulBuffer.writeInt(n);
        IntIterator4 intIterator4 = abstractQueryResult.iterateIDs();
        statefulBuffer.writeIDs(intIterator4, n2);
        if (n > 0) {
            ServerMessageDispatcher serverMessageDispatcher = this.serverMessageDispatcher();
            serverMessageDispatcher.mapQueryResultToID(new LazyClientObjectSetStub(abstractQueryResult, intIterator4), n);
        }
        this.write(msgD);
    }

    private int bufferLength(int n) {
        return 4 * (n + 2);
    }

    private static synchronized int generateID() {
        if (++nextID < 0) {
            nextID = 1;
        }
        return nextID;
    }

    protected AbstractQueryResult newQueryResult(QueryEvaluationMode queryEvaluationMode) {
        return this.stream().newQueryResult(this.transaction(), queryEvaluationMode);
    }
}

