/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.IntIterator4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.cs.LazyClientQueryResult;

public class LazyClientIdIterator
implements IntIterator4 {
    private final LazyClientQueryResult _queryResult;
    private int _current;
    private int[] _ids;
    private final int _batchSize;
    private int _available;

    public LazyClientIdIterator(LazyClientQueryResult lazyClientQueryResult) {
        this._queryResult = lazyClientQueryResult;
        this._batchSize = lazyClientQueryResult.config().prefetchObjectCount();
        this._ids = new int[this._batchSize];
        this._current = -1;
    }

    public int currentInt() {
        if (this._current < 0) {
            throw new IllegalStateException();
        }
        return this._ids[this._current];
    }

    public Object current() {
        return new Integer(this.currentInt());
    }

    public boolean moveNext() {
        if (this._available < 0) {
            return false;
        }
        if (this._available == 0) {
            this._queryResult.fetchIDs(this._batchSize);
            --this._available;
            this._current = 0;
            return this._available > 0;
        }
        ++this._current;
        --this._available;
        return true;
    }

    public void reset() {
        this._queryResult.reset();
        this._available = 0;
        this._current = -1;
    }

    public void loadFromIdReader(BufferImpl bufferImpl, int n) {
        for (int i = 0; i < n; ++i) {
            this._ids[i] = bufferImpl.readInt();
        }
        if (n > 0) {
            this._available = n;
            return;
        }
        this._available = -1;
    }
}

