/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.ClientSideMessage;
import com.db4o.internal.cs.messages.Msg;

class ClientMessageDispatcherImpl
extends Thread
implements ClientMessageDispatcher {
    private ClientObjectContainer i_stream;
    private Socket4 i_socket;
    private final BlockingQueue _messageQueue;
    private boolean _isClosed;

    ClientMessageDispatcherImpl(ClientObjectContainer clientObjectContainer, Socket4 socket4, BlockingQueue blockingQueue) {
        this.i_stream = clientObjectContainer;
        this._messageQueue = blockingQueue;
        this.i_socket = socket4;
    }

    public synchronized boolean isMessageDispatcherAlive() {
        return !this._isClosed;
    }

    public synchronized boolean close() {
        if (this._isClosed) {
            return true;
        }
        this._isClosed = true;
        if (this.i_socket != null) {
            try {
                this.i_socket.close();
            }
            catch (Db4oIOException db4oIOException) {
                // empty catch block
            }
        }
        this._messageQueue.stop();
        return true;
    }

    public void run() {
        this.messageLoop();
        this.close();
    }

    public void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            Msg msg = null;
            try {
                msg = Msg.readMessage(this, this.transaction(), this.i_socket);
            }
            catch (Db4oIOException db4oIOException) {
                if (DTrace.enabled) {
                    DTrace.CLIENT_MESSAGE_LOOP_EXCEPTION.log(db4oIOException.toString());
                }
                return;
            }
            if (msg == null || this.isClientSideMessage(msg) && ((ClientSideMessage)((Object)msg)).processAtClient()) continue;
            this._messageQueue.add(msg);
        }
    }

    private boolean isClientSideMessage(Msg msg) {
        return msg instanceof ClientSideMessage;
    }

    public boolean write(Msg msg) {
        this.i_stream.write(msg);
        return true;
    }

    public void setDispatcherName(String string) {
        this.setName("db4o client side message dispather for " + string);
    }

    public void startDispatcher() {
        this.start();
    }

    private Transaction transaction() {
        return this.i_stream.transaction();
    }
}

