/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.classindex;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.AbstractClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;

public class BTreeClassIndexStrategy
extends AbstractClassIndexStrategy {
    private BTree _btreeIndex;

    public BTreeClassIndexStrategy(ClassMetadata classMetadata) {
        super(classMetadata);
    }

    public BTree btree() {
        return this._btreeIndex;
    }

    public int entryCount(Transaction transaction) {
        return this._btreeIndex != null ? this._btreeIndex.size(transaction) : 0;
    }

    public void initialize(ObjectContainerBase objectContainerBase) {
        this.createBTreeIndex(objectContainerBase, 0);
    }

    public void purge() {
    }

    public void read(ObjectContainerBase objectContainerBase, int n) {
        this.readBTreeIndex(objectContainerBase, n);
    }

    public int write(Transaction transaction) {
        if (this._btreeIndex == null) {
            return 0;
        }
        this._btreeIndex.write(transaction);
        return this._btreeIndex.getID();
    }

    public void traverseAll(Transaction transaction, Visitor4 visitor4) {
        if (this._btreeIndex != null) {
            this._btreeIndex.traverseKeys(transaction, visitor4);
        }
    }

    private void createBTreeIndex(final ObjectContainerBase objectContainerBase, int n) {
        if (objectContainerBase.isClient()) {
            return;
        }
        this._btreeIndex = ((LocalObjectContainer)objectContainerBase).createBTreeClassIndex(n);
        this._btreeIndex.setRemoveListener(new Visitor4(){

            public void visit(Object object) {
                int n = (Integer)object;
                objectContainerBase.referenceSystemRegistry().removeId(n);
            }
        });
    }

    private void readBTreeIndex(ObjectContainerBase objectContainerBase, int n) {
        if (!objectContainerBase.isClient() && this._btreeIndex == null) {
            this.createBTreeIndex(objectContainerBase, n);
        }
    }

    protected void internalAdd(Transaction transaction, int n) {
        this._btreeIndex.add(transaction, new Integer(n));
    }

    protected void internalRemove(Transaction transaction, int n) {
        this._btreeIndex.remove(transaction, new Integer(n));
    }

    public void dontDelete(Transaction transaction, int n) {
    }

    public void defragReference(ClassMetadata classMetadata, DefragmentContextImpl defragmentContextImpl, int n) {
        int n2 = -n;
        defragmentContextImpl.writeInt(n2);
    }

    public int id() {
        return this._btreeIndex.getID();
    }

    public Iterator4 allSlotIDs(Transaction transaction) {
        return this._btreeIndex.allNodeIds(transaction);
    }

    public void defragIndex(DefragmentContextImpl defragmentContextImpl) {
        this._btreeIndex.defragIndex(defragmentContextImpl);
    }

    public static BTree btree(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndexStrategy = classMetadata.index();
        if (!(classIndexStrategy instanceof BTreeClassIndexStrategy)) {
            throw new IllegalStateException();
        }
        return ((BTreeClassIndexStrategy)classIndexStrategy).btree();
    }

    public static Iterator4 iterate(ClassMetadata classMetadata, Transaction transaction) {
        return BTreeClassIndexStrategy.btree(classMetadata).asRange(transaction).keys();
    }
}

