/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNode;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.Searcher;

public class BTreeNodeSearchResult {
    private final Transaction _transaction;
    private final BTree _btree;
    private final BTreePointer _pointer;
    private final boolean _foundMatch;

    BTreeNodeSearchResult(Transaction transaction, BTree bTree, BTreePointer bTreePointer, boolean bl) {
        if (null == transaction || null == bTree) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._btree = bTree;
        this._pointer = bTreePointer;
        this._foundMatch = bl;
    }

    BTreeNodeSearchResult(Transaction transaction, BufferImpl bufferImpl, BTree bTree, BTreeNode bTreeNode, int n, boolean bl) {
        this(transaction, bTree, BTreeNodeSearchResult.pointerOrNull(transaction, bufferImpl, bTreeNode, n), bl);
    }

    BTreeNodeSearchResult(Transaction transaction, BufferImpl bufferImpl, BTree bTree, Searcher searcher, BTreeNode bTreeNode) {
        this(transaction, bTree, BTreeNodeSearchResult.nextPointerIf(BTreeNodeSearchResult.pointerOrNull(transaction, bufferImpl, bTreeNode, searcher.cursor()), searcher.isGreater()), searcher.foundMatch());
    }

    private static BTreePointer nextPointerIf(BTreePointer bTreePointer, boolean bl) {
        if (null == bTreePointer) {
            return null;
        }
        if (bl) {
            return bTreePointer.next();
        }
        return bTreePointer;
    }

    private static BTreePointer pointerOrNull(Transaction transaction, BufferImpl bufferImpl, BTreeNode bTreeNode, int n) {
        return bTreeNode == null ? null : new BTreePointer(transaction, bufferImpl, bTreeNode, n);
    }

    public BTreeRange createIncludingRange(BTreeNodeSearchResult bTreeNodeSearchResult) {
        BTreePointer bTreePointer = this.firstValidPointer();
        BTreePointer bTreePointer2 = bTreeNodeSearchResult._foundMatch ? bTreeNodeSearchResult._pointer.next() : bTreeNodeSearchResult.firstValidPointer();
        return new BTreeRangeSingle(this._transaction, this._btree, bTreePointer, bTreePointer2);
    }

    public BTreePointer firstValidPointer() {
        if (null == this._pointer) {
            return null;
        }
        if (this._pointer.isValid()) {
            return this._pointer;
        }
        return this._pointer.next();
    }
}

