/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.DTrace;
import com.db4o.foundation.No4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeAdd;
import com.db4o.internal.btree.BTreeCancelledRemoval;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePatch;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRemove;
import com.db4o.internal.btree.BTreeUpdate;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.btree.Searcher;

public final class BTreeNode
extends PersistentBase {
    private static final int COUNT_LEAF_AND_3_LINK_LENGTH = 17;
    private static final int SLOT_LEADING_LENGTH = 17;
    final BTree _btree;
    private int _count;
    private boolean _isLeaf;
    private Object[] _keys;
    private Object[] _children;
    private int _parentID;
    private int _previousID;
    private int _nextID;
    private boolean _cached;
    private boolean _dead;

    public BTreeNode(BTree bTree, int n, boolean bl, int n2, int n3, int n4) {
        this._btree = bTree;
        this._parentID = n2;
        this._previousID = n3;
        this._nextID = n4;
        this._count = n;
        this._isLeaf = bl;
        this.prepareArrays();
    }

    public BTreeNode(int n, BTree bTree) {
        this._btree = bTree;
        this.setID(n);
        this.setStateDeactivated();
    }

    public BTreeNode(Transaction transaction, BTreeNode bTreeNode, BTreeNode bTreeNode2) {
        this(bTreeNode._btree, 2, false, 0, 0, 0);
        this._keys[0] = bTreeNode._keys[0];
        this._children[0] = bTreeNode;
        this._keys[1] = bTreeNode2._keys[0];
        this._children[1] = bTreeNode2;
        this.write(transaction.systemTransaction());
        bTreeNode.setParentID(transaction, this.getID());
        bTreeNode2.setParentID(transaction, this.getID());
    }

    public BTree btree() {
        return this._btree;
    }

    public BTreeNode add(Transaction transaction, Object object) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        Searcher searcher = this.search(bufferImpl);
        if (this._isLeaf) {
            this.prepareWrite(transaction);
            if (this.wasRemoved(transaction, searcher)) {
                this.cancelRemoval(transaction, object, searcher.cursor());
                return null;
            }
            if (searcher.count() > 0 && !searcher.beforeFirst()) {
                searcher.moveForward();
            }
            this.prepareInsert(searcher.cursor());
            this._keys[searcher.cursor()] = this.newAddPatch(transaction, object);
        } else {
            BTreeNode bTreeNode = this.child(bufferImpl, searcher.cursor());
            BTreeNode bTreeNode2 = bTreeNode.add(transaction, object);
            if (bTreeNode2 == null) {
                return null;
            }
            this.prepareWrite(transaction);
            this._keys[searcher.cursor()] = bTreeNode._keys[0];
            if (bTreeNode != bTreeNode2) {
                int n = searcher.cursor() + 1;
                this.prepareInsert(n);
                this._keys[n] = bTreeNode2._keys[0];
                this._children[n] = bTreeNode2;
            }
        }
        if (this.mustSplit()) {
            return this.split(transaction);
        }
        if (searcher.cursor() == 0) {
            return this;
        }
        return null;
    }

    private boolean mustSplit() {
        return this._count >= this._btree.nodeSize();
    }

    private BTreeAdd newAddPatch(Transaction transaction, Object object) {
        this.sizeIncrement(transaction);
        return new BTreeAdd(transaction, object);
    }

    private void cancelRemoval(Transaction transaction, Object object, int n) {
        BTreeUpdate bTreeUpdate = (BTreeUpdate)this.keyPatch(n);
        BTreeUpdate bTreeUpdate2 = bTreeUpdate.removeFor(transaction);
        this._keys[n] = this.newCancelledRemoval(transaction, bTreeUpdate.getObject(), object, bTreeUpdate2);
        this.sizeIncrement(transaction);
    }

    private BTreePatch newCancelledRemoval(Transaction transaction, Object object, Object object2, BTreeUpdate bTreeUpdate) {
        return new BTreeCancelledRemoval(transaction, object, object2, bTreeUpdate);
    }

    private void sizeIncrement(Transaction transaction) {
        this._btree.sizeChanged(transaction, 1);
    }

    private boolean wasRemoved(Transaction transaction, Searcher searcher) {
        if (!searcher.foundMatch()) {
            return false;
        }
        BTreePatch bTreePatch = this.keyPatch(transaction, searcher.cursor());
        return bTreePatch != null && bTreePatch.isRemove();
    }

    BTreeNodeSearchResult searchLeaf(Transaction transaction, SearchTarget searchTarget) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        Searcher searcher = this.search(bufferImpl, searchTarget);
        if (!this._isLeaf) {
            return this.child(bufferImpl, searcher.cursor()).searchLeaf(transaction, searchTarget);
        }
        if (!searcher.foundMatch() || searchTarget == SearchTarget.ANY || searchTarget == SearchTarget.HIGHEST) {
            return new BTreeNodeSearchResult(transaction, bufferImpl, this.btree(), searcher, this);
        }
        if (searchTarget == SearchTarget.LOWEST) {
            BTreeNodeSearchResult bTreeNodeSearchResult = this.findLowestLeafMatch(transaction, searcher.cursor() - 1);
            if (bTreeNodeSearchResult != null) {
                return bTreeNodeSearchResult;
            }
            return this.createMatchingSearchResult(transaction, bufferImpl, searcher.cursor());
        }
        throw new IllegalStateException();
    }

    private BTreeNodeSearchResult findLowestLeafMatch(Transaction transaction, int n) {
        return this.findLowestLeafMatch(transaction, this.prepareRead(transaction), n);
    }

    private BTreeNodeSearchResult findLowestLeafMatch(Transaction transaction, BufferImpl bufferImpl, int n) {
        BufferImpl bufferImpl2;
        BTreeNodeSearchResult bTreeNodeSearchResult;
        BTreeNode bTreeNode;
        if (n >= 0) {
            if (!this.compareEquals(bufferImpl, n)) {
                return null;
            }
            if (n > 0) {
                BTreeNodeSearchResult bTreeNodeSearchResult2 = this.findLowestLeafMatch(transaction, bufferImpl, n - 1);
                if (bTreeNodeSearchResult2 != null) {
                    return bTreeNodeSearchResult2;
                }
                return this.createMatchingSearchResult(transaction, bufferImpl, n);
            }
        }
        if ((bTreeNode = this.previousNode()) != null && (bTreeNodeSearchResult = bTreeNode.findLowestLeafMatch(transaction, bufferImpl2 = bTreeNode.prepareRead(transaction), bTreeNode.lastIndex())) != null) {
            return bTreeNodeSearchResult;
        }
        if (n < 0) {
            return null;
        }
        return this.createMatchingSearchResult(transaction, bufferImpl, n);
    }

    private boolean compareEquals(BufferImpl bufferImpl, int n) {
        if (this.canWrite()) {
            return this.compareInWriteMode(n) == 0;
        }
        return this.compareInReadMode(bufferImpl, n) == 0;
    }

    private BTreeNodeSearchResult createMatchingSearchResult(Transaction transaction, BufferImpl bufferImpl, int n) {
        return new BTreeNodeSearchResult(transaction, bufferImpl, this.btree(), this, n, true);
    }

    public boolean canWrite() {
        return this._keys != null;
    }

    BTreeNode child(int n) {
        if (this._children[n] instanceof BTreeNode) {
            return (BTreeNode)this._children[n];
        }
        return this._btree.produceNode((Integer)this._children[n]);
    }

    BTreeNode child(BufferImpl bufferImpl, int n) {
        if (this.childLoaded(n)) {
            return (BTreeNode)this._children[n];
        }
        BTreeNode bTreeNode = this._btree.produceNode(this.childID(bufferImpl, n));
        if (this._children != null && (this._cached || bTreeNode.canWrite())) {
            this._children[n] = bTreeNode;
        }
        return bTreeNode;
    }

    private int childID(BufferImpl bufferImpl, int n) {
        if (this._children == null) {
            this.seekChild(bufferImpl, n);
            return bufferImpl.readInt();
        }
        return this.childID(n);
    }

    private int childID(int n) {
        if (this.childLoaded(n)) {
            return ((BTreeNode)this._children[n]).getID();
        }
        return (Integer)this._children[n];
    }

    private boolean childLoaded(int n) {
        if (this._children == null) {
            return false;
        }
        return this._children[n] instanceof BTreeNode;
    }

    private boolean childCanSupplyFirstKey(int n) {
        if (!this.childLoaded(n)) {
            return false;
        }
        return ((BTreeNode)this._children[n]).canWrite();
    }

    void commit(Transaction transaction) {
        this.commitOrRollback(transaction, true);
    }

    void commitOrRollback(Transaction transaction, boolean bl) {
        if (DTrace.enabled) {
            DTrace.BTREE_NODE_COMMIT_OR_ROLLBACK.log(this.getID());
        }
        if (this._dead) {
            return;
        }
        this._cached = false;
        if (!this._isLeaf) {
            return;
        }
        if (!this.isDirty(transaction)) {
            return;
        }
        Object object = this._keys[0];
        Object[] objectArray = new Object[this._btree.nodeSize()];
        int n = 0;
        for (int i = 0; i < this._count; ++i) {
            Object object2 = this._keys[i];
            BTreePatch bTreePatch = this.keyPatch(i);
            if (bTreePatch != null) {
                Object object3 = object2 = bl ? bTreePatch.commit(transaction, this._btree) : bTreePatch.rollback(transaction, this._btree);
            }
            if (object2 == No4.INSTANCE) continue;
            objectArray[n] = object2;
            ++n;
        }
        this._keys = objectArray;
        this._count = n;
        if (this.freeIfEmpty(transaction)) {
            return;
        }
        this.setStateDirty();
        if (this._keys[0] != object) {
            this.tellParentAboutChangedKey(transaction);
        }
    }

    private boolean freeIfEmpty(Transaction transaction) {
        return this.freeIfEmpty(transaction, this._count);
    }

    private boolean freeIfEmpty(Transaction transaction, int n) {
        if (n > 0) {
            return false;
        }
        if (this.isRoot()) {
            return false;
        }
        this.free(transaction);
        return true;
    }

    private boolean isRoot() {
        return this._btree.root() == this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BTreeNode)) {
            return false;
        }
        BTreeNode bTreeNode = (BTreeNode)object;
        return this.getID() == bTreeNode.getID();
    }

    public int hashCode() {
        return this.getID();
    }

    public void free(Transaction transaction) {
        this._dead = true;
        if (!this.isRoot()) {
            BTreeNode bTreeNode = this._btree.produceNode(this._parentID);
            bTreeNode.removeChild(transaction, this);
        }
        this.pointPreviousTo(transaction, this._nextID);
        this.pointNextTo(transaction, this._previousID);
        super.free(transaction);
        this._btree.removeNode(this);
    }

    void holdChildrenAsIDs() {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._children[i] instanceof BTreeNode)) continue;
            this._children[i] = new Integer(((BTreeNode)this._children[i]).getID());
        }
    }

    private void removeChild(Transaction transaction, BTreeNode bTreeNode) {
        this.prepareWrite(transaction);
        int n = bTreeNode.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != n) continue;
            if (this.freeIfEmpty(transaction, this._count - 1)) {
                return;
            }
            this.remove(i);
            if (i <= 1) {
                this.tellParentAboutChangedKey(transaction);
            }
            if (this._count == 0) {
                this._isLeaf = true;
            }
            return;
        }
        throw new IllegalStateException("child not found");
    }

    private void keyChanged(Transaction transaction, BTreeNode bTreeNode) {
        this.prepareWrite(transaction);
        int n = bTreeNode.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != n) continue;
            this._keys[i] = bTreeNode._keys[0];
            this._children[i] = bTreeNode;
            this.keyChanged(transaction, i);
            return;
        }
        throw new IllegalStateException("child not found");
    }

    private void tellParentAboutChangedKey(Transaction transaction) {
        if (!this.isRoot()) {
            BTreeNode bTreeNode = this._btree.produceNode(this._parentID);
            bTreeNode.keyChanged(transaction, this);
        }
    }

    private boolean isDirty(Transaction transaction) {
        if (!this.canWrite()) {
            return false;
        }
        for (int i = 0; i < this._count; ++i) {
            if (this.keyPatch(transaction, i) == null) continue;
            return true;
        }
        return false;
    }

    private int compareInWriteMode(int n) {
        return this.keyHandler().compareTo(this.key(n));
    }

    private int compareInReadMode(BufferImpl bufferImpl, int n) {
        this.seekKey(bufferImpl, n);
        return this.keyHandler().compareTo(this.keyHandler().readIndexEntry(bufferImpl));
    }

    public int count() {
        return this._count;
    }

    private int entryLength() {
        int n = this.keyHandler().linkLength();
        if (!this._isLeaf) {
            n += 4;
        }
        return n;
    }

    public int firstKeyIndex(Transaction transaction) {
        for (int i = 0; i < this._count; ++i) {
            if (!this.indexIsValid(transaction, i)) continue;
            return i;
        }
        return -1;
    }

    public int lastKeyIndex(Transaction transaction) {
        for (int i = this._count - 1; i >= 0; --i) {
            if (!this.indexIsValid(transaction, i)) continue;
            return i;
        }
        return -1;
    }

    public boolean indexIsValid(Transaction transaction, int n) {
        if (!this.canWrite()) {
            return true;
        }
        BTreePatch bTreePatch = this.keyPatch(n);
        if (bTreePatch == null) {
            return true;
        }
        return bTreePatch.key(transaction) != No4.INSTANCE;
    }

    private Object firstKey(Transaction transaction) {
        int n = this.firstKeyIndex(transaction);
        if (-1 == n) {
            return No4.INSTANCE;
        }
        return this.key(transaction, n);
    }

    public byte getIdentifier() {
        return 66;
    }

    private void prepareInsert(int n) {
        if (n > this.lastIndex()) {
            ++this._count;
            return;
        }
        int n2 = this._count - n;
        System.arraycopy(this._keys, n, this._keys, n + 1, n2);
        if (this._children != null) {
            System.arraycopy(this._children, n, this._children, n + 1, n2);
        }
        ++this._count;
    }

    private void remove(int n) {
        if (DTrace.enabled) {
            DTrace.BTREE_NODE_REMOVE.log(this.getID());
        }
        int n2 = this._count - n;
        --this._count;
        System.arraycopy(this._keys, n + 1, this._keys, n, n2);
        this._keys[this._count] = null;
        if (this._children != null) {
            System.arraycopy(this._children, n + 1, this._children, n, n2);
            this._children[this._count] = null;
        }
    }

    Object key(int n) {
        Object object = this._keys[n];
        if (object instanceof BTreePatch) {
            return ((BTreePatch)object).getObject();
        }
        return object;
    }

    Object key(Transaction transaction, BufferImpl bufferImpl, int n) {
        if (this.canWrite()) {
            return this.key(transaction, n);
        }
        this.seekKey(bufferImpl, n);
        return this.keyHandler().readIndexEntry(bufferImpl);
    }

    Object key(Transaction transaction, int n) {
        BTreePatch bTreePatch = this.keyPatch(n);
        if (bTreePatch == null) {
            return this._keys[n];
        }
        return bTreePatch.key(transaction);
    }

    private BTreePatch keyPatch(int n) {
        Object object = this._keys[n];
        if (object instanceof BTreePatch) {
            return (BTreePatch)object;
        }
        return null;
    }

    private BTreePatch keyPatch(Transaction transaction, int n) {
        Object object = this._keys[n];
        if (object instanceof BTreePatch) {
            return ((BTreePatch)object).forTransaction(transaction);
        }
        return null;
    }

    private Indexable4 keyHandler() {
        return this._btree.keyHandler();
    }

    void markAsCached(int n) {
        this._cached = true;
        this._btree.addNode(this);
        if (this._isLeaf || this._children == null) {
            return;
        }
        if (--n < 1) {
            this.holdChildrenAsIDs();
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._children[i] instanceof BTreeNode)) continue;
            ((BTreeNode)this._children[i]).markAsCached(n);
        }
    }

    public int ownLength() {
        return 17 + this._count * this.entryLength() + 0;
    }

    BufferImpl prepareRead(Transaction transaction) {
        if (this.canWrite()) {
            return null;
        }
        if (this.isNew()) {
            return null;
        }
        if (this._cached) {
            this.read(transaction.systemTransaction());
            this._btree.addToProcessing(this);
            return null;
        }
        BufferImpl bufferImpl = ((LocalTransaction)transaction).file().readReaderByID(transaction.systemTransaction(), this.getID());
        this.readNodeHeader(bufferImpl);
        return bufferImpl;
    }

    void prepareWrite(Transaction transaction) {
        if (this._dead) {
            return;
        }
        if (this.canWrite()) {
            this.setStateDirty();
            return;
        }
        this.read(transaction.systemTransaction());
        this.setStateDirty();
        this._btree.addToProcessing(this);
    }

    private void prepareArrays() {
        if (this.canWrite()) {
            return;
        }
        this._keys = new Object[this._btree.nodeSize()];
        if (!this._isLeaf) {
            this._children = new Object[this._btree.nodeSize()];
        }
    }

    private void readNodeHeader(BufferImpl bufferImpl) {
        this._count = bufferImpl.readInt();
        byte by = bufferImpl.readByte();
        this._isLeaf = by == 1;
        this._parentID = bufferImpl.readInt();
        this._previousID = bufferImpl.readInt();
        this._nextID = bufferImpl.readInt();
    }

    public void readThis(Transaction transaction, BufferImpl bufferImpl) {
        this.readNodeHeader(bufferImpl);
        this.prepareArrays();
        boolean bl = !this._isLeaf;
        for (int i = 0; i < this._count; ++i) {
            this._keys[i] = this.keyHandler().readIndexEntry(bufferImpl);
            if (!bl) continue;
            this._children[i] = new Integer(bufferImpl.readInt());
        }
    }

    public void remove(Transaction transaction, Object object, int n) {
        if (!this._isLeaf) {
            throw new IllegalStateException();
        }
        this.prepareWrite(transaction);
        BTreePatch bTreePatch = this.keyPatch(n);
        if (bTreePatch == null) {
            this._keys[n] = this.newRemovePatch(transaction, object);
            this.keyChanged(transaction, n);
            return;
        }
        BTreePatch bTreePatch2 = bTreePatch.forTransaction(transaction);
        if (bTreePatch2 != null) {
            if (bTreePatch2.isAdd()) {
                this.cancelAdding(transaction, n);
                return;
            }
            if (bTreePatch2.isCancelledRemoval()) {
                BTreeRemove bTreeRemove = this.applyNewRemovePatch(transaction, bTreePatch2.getObject());
                this._keys[n] = ((BTreeUpdate)bTreePatch).replacePatch(bTreePatch2, bTreeRemove);
                this.keyChanged(transaction, n);
                return;
            }
        } else if (!bTreePatch.isAdd()) {
            ((BTreeUpdate)bTreePatch).append(this.newRemovePatch(transaction, object));
            return;
        }
        if (n != this.lastIndex()) {
            if (this.compareInWriteMode(n + 1) != 0) {
                return;
            }
            this.remove(transaction, object, n + 1);
            return;
        }
        BTreeNode bTreeNode = this.nextNode();
        if (bTreeNode == null) {
            return;
        }
        bTreeNode.prepareWrite(transaction);
        if (bTreeNode.compareInWriteMode(0) != 0) {
            return;
        }
        bTreeNode.remove(transaction, object, 0);
    }

    private void cancelAdding(Transaction transaction, int n) {
        this._btree.notifyRemoveListener(this.keyPatch(n).getObject());
        if (this.freeIfEmpty(transaction, this._count - 1)) {
            this.sizeDecrement(transaction);
            return;
        }
        this.remove(n);
        this.keyChanged(transaction, n);
        this.sizeDecrement(transaction);
    }

    private void sizeDecrement(Transaction transaction) {
        this._btree.sizeChanged(transaction, -1);
    }

    private int lastIndex() {
        return this._count - 1;
    }

    private BTreeRemove newRemovePatch(Transaction transaction, Object object) {
        return this.applyNewRemovePatch(transaction, object);
    }

    private BTreeRemove applyNewRemovePatch(Transaction transaction, Object object) {
        this.sizeDecrement(transaction);
        return new BTreeRemove(transaction, object);
    }

    private void keyChanged(Transaction transaction, int n) {
        if (n == 0) {
            this.tellParentAboutChangedKey(transaction);
        }
    }

    void rollback(Transaction transaction) {
        this.commitOrRollback(transaction, false);
    }

    private Searcher search(BufferImpl bufferImpl) {
        return this.search(bufferImpl, SearchTarget.ANY);
    }

    private Searcher search(BufferImpl bufferImpl, SearchTarget searchTarget) {
        Searcher searcher = new Searcher(searchTarget, this._count);
        if (this.canWrite()) {
            while (searcher.incomplete()) {
                searcher.resultIs(this.compareInWriteMode(searcher.cursor()));
            }
        } else {
            while (searcher.incomplete()) {
                searcher.resultIs(this.compareInReadMode(bufferImpl, searcher.cursor()));
            }
        }
        return searcher;
    }

    private void seekAfterKey(BufferImpl bufferImpl, int n) {
        this.seekKey(bufferImpl, n);
        bufferImpl._offset += this.keyHandler().linkLength();
    }

    private void seekChild(BufferImpl bufferImpl, int n) {
        this.seekAfterKey(bufferImpl, n);
    }

    private void seekKey(BufferImpl bufferImpl, int n) {
        bufferImpl._offset = 17 + this.entryLength() * n;
    }

    private BTreeNode split(Transaction transaction) {
        int n;
        BTreeNode bTreeNode = new BTreeNode(this._btree, this._btree._halfNodeSize, this._isLeaf, this._parentID, this.getID(), this._nextID);
        System.arraycopy(this._keys, this._btree._halfNodeSize, bTreeNode._keys, 0, this._btree._halfNodeSize);
        for (n = this._btree._halfNodeSize; n < this._keys.length; ++n) {
            this._keys[n] = null;
        }
        if (this._children != null) {
            bTreeNode._children = new Object[this._btree.nodeSize()];
            System.arraycopy(this._children, this._btree._halfNodeSize, bTreeNode._children, 0, this._btree._halfNodeSize);
            for (n = this._btree._halfNodeSize; n < this._children.length; ++n) {
                this._children[n] = null;
            }
        }
        this._count = this._btree._halfNodeSize;
        bTreeNode.write(transaction.systemTransaction());
        this._btree.addNode(bTreeNode);
        n = bTreeNode.getID();
        this.pointNextTo(transaction, n);
        this.setNextID(transaction, n);
        if (this._children != null) {
            for (int i = 0; i < this._btree._halfNodeSize && bTreeNode._children[i] != null; ++i) {
                bTreeNode.child(i).setParentID(transaction, n);
            }
        }
        return bTreeNode;
    }

    private void pointNextTo(Transaction transaction, int n) {
        if (this._nextID != 0) {
            this.nextNode().setPreviousID(transaction, n);
        }
    }

    private void pointPreviousTo(Transaction transaction, int n) {
        if (this._previousID != 0) {
            this.previousNode().setNextID(transaction, n);
        }
    }

    public BTreeNode previousNode() {
        if (this._previousID == 0) {
            return null;
        }
        return this._btree.produceNode(this._previousID);
    }

    public BTreeNode nextNode() {
        if (this._nextID == 0) {
            return null;
        }
        return this._btree.produceNode(this._nextID);
    }

    BTreePointer firstPointer(Transaction transaction) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        if (this._isLeaf) {
            return this.leafFirstPointer(transaction, bufferImpl);
        }
        return this.branchFirstPointer(transaction, bufferImpl);
    }

    private BTreePointer branchFirstPointer(Transaction transaction, BufferImpl bufferImpl) {
        for (int i = 0; i < this._count; ++i) {
            BTreePointer bTreePointer = this.child(bufferImpl, i).firstPointer(transaction);
            if (bTreePointer == null) continue;
            return bTreePointer;
        }
        return null;
    }

    private BTreePointer leafFirstPointer(Transaction transaction, BufferImpl bufferImpl) {
        int n = this.firstKeyIndex(transaction);
        if (n == -1) {
            return null;
        }
        return new BTreePointer(transaction, bufferImpl, this, n);
    }

    public BTreePointer lastPointer(Transaction transaction) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        if (this._isLeaf) {
            return this.leafLastPointer(transaction, bufferImpl);
        }
        return this.branchLastPointer(transaction, bufferImpl);
    }

    private BTreePointer branchLastPointer(Transaction transaction, BufferImpl bufferImpl) {
        for (int i = this._count - 1; i >= 0; --i) {
            BTreePointer bTreePointer = this.child(bufferImpl, i).lastPointer(transaction);
            if (bTreePointer == null) continue;
            return bTreePointer;
        }
        return null;
    }

    private BTreePointer leafLastPointer(Transaction transaction, BufferImpl bufferImpl) {
        int n = this.lastKeyIndex(transaction);
        if (n == -1) {
            return null;
        }
        return new BTreePointer(transaction, bufferImpl, this, n);
    }

    void purge() {
        if (this._dead) {
            this._keys = null;
            this._children = null;
            return;
        }
        if (this._cached) {
            return;
        }
        if (!this.canWrite()) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._keys[i] instanceof BTreePatch)) continue;
            this.holdChildrenAsIDs();
            this._btree.addNode(this);
            return;
        }
    }

    private void setParentID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._parentID = n;
    }

    private void setPreviousID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._previousID = n;
    }

    private void setNextID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._nextID = n;
    }

    public void traverseKeys(Transaction transaction, Visitor4 visitor4) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        if (this._isLeaf) {
            for (int i = 0; i < this._count; ++i) {
                Object object = this.key(transaction, bufferImpl, i);
                if (object == No4.INSTANCE) continue;
                visitor4.visit(object);
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                this.child(bufferImpl, i).traverseKeys(transaction, visitor4);
            }
        }
    }

    public boolean writeObjectBegin() {
        if (this._dead) {
            return false;
        }
        if (!this.canWrite()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeThis(Transaction transaction, BufferImpl bufferImpl) {
        int n;
        int n2 = 0;
        int n3 = bufferImpl._offset;
        bufferImpl.incrementOffset(17);
        if (this._isLeaf) {
            for (n = 0; n < this._count; ++n) {
                Object object = this.key(transaction, n);
                if (object == No4.INSTANCE) continue;
                ++n2;
                this.keyHandler().writeIndexEntry(bufferImpl, object);
            }
        } else {
            for (n = 0; n < this._count; ++n) {
                if (this.childCanSupplyFirstKey(n)) {
                    BTreeNode bTreeNode = (BTreeNode)this._children[n];
                    Object object = bTreeNode.firstKey(transaction);
                    if (object == No4.INSTANCE) continue;
                    ++n2;
                    this.keyHandler().writeIndexEntry(bufferImpl, object);
                    bufferImpl.writeIDOf(transaction, bTreeNode);
                    continue;
                }
                ++n2;
                this.keyHandler().writeIndexEntry(bufferImpl, this.key(n));
                bufferImpl.writeIDOf(transaction, this._children[n]);
            }
        }
        n = bufferImpl._offset;
        bufferImpl._offset = n3;
        bufferImpl.writeInt(n2);
        bufferImpl.writeByte(this._isLeaf ? (byte)1 : 0);
        bufferImpl.writeInt(this._parentID);
        bufferImpl.writeInt(this._previousID);
        bufferImpl.writeInt(this._nextID);
        bufferImpl._offset = n;
    }

    public String toString() {
        if (this._count == 0) {
            return "Node " + this.getID() + " not loaded";
        }
        String string = "\nBTreeNode";
        string = string + "\nid: " + this.getID();
        string = string + "\nparent: " + this._parentID;
        string = string + "\nprevious: " + this._previousID;
        string = string + "\nnext: " + this._nextID;
        string = string + "\ncount:" + this._count;
        string = string + "\nleaf:" + this._isLeaf + "\n";
        if (this.canWrite()) {
            string = string + " { ";
            boolean bl = true;
            for (int i = 0; i < this._count; ++i) {
                if (this._keys[i] == null) continue;
                if (!bl) {
                    string = string + ", ";
                }
                string = string + this._keys[i].toString();
                bl = false;
            }
            string = string + " }";
        }
        return string;
    }

    public void debugLoadFully(Transaction transaction) {
        this.prepareWrite(transaction);
        if (this._isLeaf) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (this._children[i] instanceof Integer) {
                this._children[i] = this.btree().produceNode((Integer)this._children[i]);
            }
            ((BTreeNode)this._children[i]).debugLoadFully(transaction);
        }
    }

    public static void defragIndex(DefragmentContextImpl defragmentContextImpl, Indexable4 indexable4) {
        int n = defragmentContextImpl.readInt();
        byte by = defragmentContextImpl.readByte();
        boolean bl = by == 1;
        defragmentContextImpl.copyID();
        defragmentContextImpl.copyID();
        defragmentContextImpl.copyID();
        for (int i = 0; i < n; ++i) {
            indexable4.defragIndexEntry(defragmentContextImpl);
            if (bl) continue;
            defragmentContextImpl.copyID();
        }
    }

    public boolean isFreespaceComponent() {
        return this._btree.isFreespaceComponent();
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void traverseAllNodes(Transaction transaction, Visitor4 visitor4) {
        BufferImpl bufferImpl = this.prepareRead(transaction);
        visitor4.visit(this);
        if (this._isLeaf) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            this.child(bufferImpl, i).traverseAllNodes(transaction, visitor4);
        }
    }
}

