/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthImpl;
import com.db4o.internal.activation.ActivationMode;

public class LegacyActivationDepth
extends ActivationDepthImpl {
    private final int _depth;

    public LegacyActivationDepth(int n) {
        this(n, ActivationMode.ACTIVATE);
    }

    public LegacyActivationDepth(int n, ActivationMode activationMode) {
        super(activationMode);
        this._depth = n;
    }

    public ActivationDepth descend(ClassMetadata classMetadata) {
        if (null == classMetadata) {
            throw new ArgumentNullException();
        }
        return new LegacyActivationDepth(this.descendDepth(classMetadata), this._mode);
    }

    private int descendDepth(ClassMetadata classMetadata) {
        int n = this.configuredActivationDepth(classMetadata) - 1;
        if (classMetadata.isValueType()) {
            return Math.max(1, n);
        }
        return n;
    }

    private int configuredActivationDepth(ClassMetadata classMetadata) {
        Config4Class config4Class = classMetadata.configOrAncestorConfig();
        if (config4Class != null && this._mode.isActivate()) {
            return config4Class.adjustActivationDepth(this._depth);
        }
        return this._depth;
    }

    public boolean requiresActivation() {
        return this._depth > 0;
    }
}

