/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public final class StatefulBuffer
extends BufferImpl {
    private int i_address;
    private int _addressOffset;
    private int i_cascadeDelete;
    private int i_id;
    private ActivationDepth i_instantionDepth;
    private int i_length;
    Transaction i_trans;
    private int i_updateDepth = 1;
    public int _payloadOffset;

    public StatefulBuffer(Transaction transaction, int n) {
        this.i_trans = transaction;
        this.i_length = n;
        this._buffer = new byte[this.i_length];
    }

    public StatefulBuffer(Transaction transaction, int n, int n2) {
        this(transaction, n2);
        this.i_address = n;
    }

    public StatefulBuffer(Transaction transaction, Slot slot) {
        this(transaction, slot.address(), slot.length());
    }

    public StatefulBuffer(Transaction transaction, Pointer4 pointer4) {
        this(transaction, pointer4._slot);
        this.i_id = pointer4._id;
    }

    public void debugCheckBytes() {
    }

    public int getAddress() {
        return this.i_address;
    }

    public int addressOffset() {
        return this._addressOffset;
    }

    public int getID() {
        return this.i_id;
    }

    public ActivationDepth getInstantiationDepth() {
        return this.i_instantionDepth;
    }

    public int length() {
        return this.i_length;
    }

    public ObjectContainerBase getStream() {
        return this.i_trans.container();
    }

    public ObjectContainerBase stream() {
        return this.i_trans.container();
    }

    public LocalObjectContainer file() {
        return ((LocalTransaction)this.i_trans).file();
    }

    public Transaction getTransaction() {
        return this.i_trans;
    }

    public int getUpdateDepth() {
        return this.i_updateDepth;
    }

    public byte[] getWrittenBytes() {
        byte[] byArray = new byte[this._offset];
        System.arraycopy(this._buffer, 0, byArray, 0, this._offset);
        return byArray;
    }

    public int preparePayloadRead() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this._offset;
        this._offset = n;
        this._payloadOffset += n2;
        return n3;
    }

    public void read() throws Db4oIOException {
        this.stream().readBytes(this._buffer, this.i_address, this._addressOffset, this.i_length);
    }

    public final StatefulBuffer readEmbeddedObject() throws Db4oIOException {
        int n = this.readInt();
        int n2 = this.readInt();
        if (n == 0) {
            return null;
        }
        StatefulBuffer statefulBuffer = null;
        statefulBuffer = this.stream().readWriterByAddress(this.i_trans, n, n2);
        if (statefulBuffer != null) {
            statefulBuffer.setID(n);
        }
        if (statefulBuffer != null) {
            statefulBuffer.setUpdateDepth(this.getUpdateDepth());
            statefulBuffer.setInstantiationDepth(this.getInstantiationDepth());
        }
        return statefulBuffer;
    }

    public final StatefulBuffer readYapBytes() {
        int n = this.readInt();
        if (n == 0) {
            return null;
        }
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.i_trans, n);
        System.arraycopy(this._buffer, this._offset, statefulBuffer._buffer, 0, n);
        this._offset += n;
        return statefulBuffer;
    }

    public void removeFirstBytes(int n) {
        this.i_length -= n;
        byte[] byArray = new byte[this.i_length];
        System.arraycopy(this._buffer, n, byArray, 0, this.i_length);
        this._buffer = byArray;
        this._offset -= n;
        if (this._offset < 0) {
            this._offset = 0;
        }
    }

    public void address(int n) {
        this.i_address = n;
    }

    public void setID(int n) {
        this.i_id = n;
    }

    public void setInstantiationDepth(ActivationDepth activationDepth) {
        this.i_instantionDepth = activationDepth;
    }

    public void setTransaction(Transaction transaction) {
        this.i_trans = transaction;
    }

    public void setUpdateDepth(int n) {
        this.i_updateDepth = n;
    }

    public void slotDelete() {
        this.i_trans.slotDelete(this.i_id, this.slot());
    }

    public void trim4(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        this._buffer = byArray;
        this.i_length = n2;
    }

    public void useSlot(int n) {
        this.i_address = n;
        this._offset = 0;
    }

    public void useSlot(int n, int n2) {
        this.useSlot(new Slot(n, n2));
    }

    public void useSlot(Slot slot) {
        this.i_address = slot.address();
        this._offset = 0;
        if (slot.length() > this._buffer.length) {
            this._buffer = new byte[slot.length()];
        }
        this.i_length = slot.length();
    }

    public void useSlot(int n, int n2, int n3) {
        this.i_id = n;
        this.useSlot(n2, n3);
    }

    public void write() {
        this.file().writeBytes(this, this.i_address, this._addressOffset);
    }

    public void writeEmbeddedNull() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void writeEncrypt() {
        this.file().writeEncrypt(this, this.i_address, this._addressOffset);
    }

    public void writePayload(StatefulBuffer statefulBuffer, boolean bl) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(statefulBuffer.length(), bl);
        System.arraycopy(statefulBuffer._buffer, 0, this._buffer, this._payloadOffset, statefulBuffer._buffer.length);
        this.transferPayLoadAddress(statefulBuffer, this._payloadOffset);
        this._payloadOffset += statefulBuffer._buffer.length;
    }

    private void checkMinimumPayLoadOffsetAndWritePointerAndLength(int n, boolean bl) {
        if (this._payloadOffset <= this._offset + 8) {
            this._payloadOffset = this._offset + 8;
        }
        if (bl) {
            this._payloadOffset = this.stream().blockAlignedBytes(this._payloadOffset);
        }
        this.writeInt(this._payloadOffset);
        this.writeInt(n);
    }

    public int reserveAndPointToPayLoadSlot(int n) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(n, false);
        int n2 = this._offset;
        this._offset = this._payloadOffset;
        this._payloadOffset += n;
        return n2;
    }

    public BufferImpl readPayloadWriter(int n, int n2) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.i_trans, 0, n2);
        System.arraycopy(this._buffer, n, statefulBuffer._buffer, 0, n2);
        this.transferPayLoadAddress(statefulBuffer, n);
        return statefulBuffer;
    }

    private void transferPayLoadAddress(StatefulBuffer statefulBuffer, int n) {
        int n2 = n / this.stream().blockSize();
        statefulBuffer.i_id = statefulBuffer.i_address = this.i_address + n2;
        statefulBuffer._addressOffset = this._addressOffset;
    }

    void writeShortString(String string) {
        this.writeShortString(this.i_trans, string);
    }

    public void moveForward(int n) {
        this._addressOffset += n;
    }

    public void writeForward() {
        this.write();
        this._addressOffset += this.i_length;
        this._offset = 0;
    }

    public String toString() {
        return super.toString();
    }

    public void noXByteCheck() {
    }

    public void writeIDs(IntIterator4 intIterator4, int n) {
        int n2 = this._offset;
        this.writeInt(0);
        int n3 = 0;
        while (intIterator4.moveNext()) {
            this.writeInt(intIterator4.currentInt());
            if (++n3 < n) continue;
        }
        int n4 = this._offset;
        this._offset = n2;
        this.writeInt(n3);
        this._offset = n4;
    }

    public Slot slot() {
        return new Slot(this.i_address, this.i_length);
    }

    public Pointer4 pointer() {
        return new Pointer4(this.i_id, this.slot());
    }

    public int cascadeDeletes() {
        return this.i_cascadeDelete;
    }

    public void setCascadeDeletes(int n) {
        this.i_cascadeDelete = n;
    }
}

