/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectAttribute;
import com.db4o.config.ObjectClass;
import com.db4o.config.TClass;
import com.db4o.config.THashtable;
import com.db4o.config.TNull;
import com.db4o.config.TVector;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.StackTracer;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.JDK;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PartialObjectContainer;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.Reflection4;
import com.db4o.internal.ShutDownRunnable;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.query.processor.QConEvaluation;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.types.Db4oCollections;
import java.net.Socket;
import java.util.Date;

public final class Platform4 {
    private static final String JDK_PACKAGE = "com.db4o.internal.";
    private static TernaryBool collectionCheck = TernaryBool.UNSPECIFIED;
    private static JDK jdkWrapper;
    private static TernaryBool nioCheck;
    private static TernaryBool setAccessibleCheck;
    private static TernaryBool shutDownHookCheck;
    static TernaryBool callConstructorCheck;
    static ShutDownRunnable shutDownRunnable;
    static Thread shutDownThread;
    static final String ACCESSIBLEOBJECT = "java.lang.reflect.AccessibleObject";
    static final String GETCONSTRUCTOR = "newConstructorForSerialization";
    static final String REFERENCEQUEUE = "java.lang.ref.ReferenceQueue";
    static final String REFLECTIONFACTORY = "sun.reflect.ReflectionFactory";
    static final String RUNFINALIZERSONEXIT = "runFinalizersOnExit";
    static final String UTIL = "java.util.";
    static final String DB4O_PACKAGE = "com.db4o.";
    static final String DB4O_CONFIG = "com.db4o.config.";
    static final String DB4O_ASSEMBLY = ", db4o";
    private static TernaryBool weakReferenceCheck;
    private static final Class[] SIMPLE_CLASSES;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$com$db4o$P1Collection;

    static final synchronized void addShutDownHook(PartialObjectContainer partialObjectContainer) {
        if (!Platform4.hasShutDownHook()) {
            return;
        }
        if (shutDownThread == null) {
            shutDownRunnable = new ShutDownRunnable();
            shutDownThread = Platform4.jdk().addShutdownHook(shutDownRunnable);
        }
        shutDownRunnable.ensure(partialObjectContainer);
    }

    public static final boolean canSetAccessible() {
        if (setAccessibleCheck.unspecified()) {
            if (Platform4.jdk().ver() >= 2) {
                setAccessibleCheck = TernaryBool.YES;
            } else {
                setAccessibleCheck = TernaryBool.NO;
                if (((Config4Impl)Db4o.configure()).messageLevel() >= 0) {
                    Messages.logErr(Db4o.configure(), 47, null, null);
                }
            }
        }
        return setAccessibleCheck.definiteYes();
    }

    static final boolean classIsAvailable(String string) {
        return ReflectPlatform.forName(string) != null;
    }

    static Db4oCollections collections(Transaction transaction) {
        return Platform4.jdk().collections(transaction);
    }

    static final Reflector createReflector(Object object) {
        return Platform4.jdk().createReflector(object);
    }

    static final Object createReferenceQueue() {
        return Platform4.jdk().createReferenceQueue();
    }

    public static Object createWeakReference(Object object) {
        return Platform4.jdk().createWeakReference(object);
    }

    static final Object createActiveObjectReference(Object object, Object object2, Object object3) {
        return Platform4.jdk().createActivateObjectReference(object, (ObjectReference)object2, object3);
    }

    public static Object deserialize(byte[] byArray) {
        return Platform4.jdk().deserialize(byArray);
    }

    public static final long doubleToLong(double d) {
        return Double.doubleToLongBits(d);
    }

    public static final QConEvaluation evaluationCreate(Transaction transaction, Object object) {
        if (object instanceof Evaluation) {
            return new QConEvaluation(transaction, object);
        }
        return null;
    }

    public static final void evaluationEvaluate(Object object, Candidate candidate) {
        ((Evaluation)object).evaluate(candidate);
    }

    public static Object[] collectionToArray(ObjectContainerBase objectContainerBase, Object object) {
        Collection4 collection4 = Platform4.flattenCollection(objectContainerBase, object);
        Object[] objectArray = new Object[collection4.size()];
        collection4.toArray(objectArray);
        return objectArray;
    }

    static final Collection4 flattenCollection(ObjectContainerBase objectContainerBase, Object object) {
        Collection4 collection4 = new Collection4();
        Platform4.flattenCollection1(objectContainerBase, object, collection4);
        return collection4;
    }

    public static Config4Class extendConfiguration(ReflectClass reflectClass, Configuration configuration, Config4Class config4Class) {
        return Platform4.jdk().extendConfiguration(reflectClass, configuration, config4Class);
    }

    static final void flattenCollection1(ObjectContainerBase objectContainerBase, Object object, Collection4 collection4) {
        if (object == null) {
            collection4.add(null);
        } else {
            ReflectClass reflectClass = objectContainerBase.reflector().forObject(object);
            if (reflectClass.isArray()) {
                Iterator4 iterator4 = ArrayHandler.iterator(reflectClass, object);
                while (iterator4.moveNext()) {
                    Platform4.flattenCollection1(objectContainerBase, iterator4.current(), collection4);
                }
            } else {
                Platform4.flattenCollection2(objectContainerBase, object, collection4);
            }
        }
    }

    static final void flattenCollection2(final ObjectContainerBase objectContainerBase, Object object, final Collection4 collection4) {
        GenericReflector genericReflector = objectContainerBase.reflector();
        if (genericReflector.forObject(object).isCollection()) {
            Platform4.forEachCollectionElement(object, new Visitor4(){

                public void visit(Object object) {
                    Platform4.flattenCollection1(objectContainerBase, object, collection4);
                }
            });
        } else {
            collection4.add(object);
        }
    }

    static final void forEachCollectionElement(Object object, Visitor4 visitor4) {
        Platform4.jdk().forEachCollectionElement(object, visitor4);
    }

    public static final String format(Date date, boolean bl) {
        return Platform4.jdk().format(date, bl);
    }

    public static Object getClassForType(Object object) {
        return object;
    }

    public static final void getDefaultConfiguration(Config4Impl config4Impl) {
        Platform4.jdk();
        Platform4.hasWeakReferences();
        Platform4.hasNio();
        Platform4.hasCollections();
        Platform4.hasShutDownHook();
        if (config4Impl.reflector() == null) {
            config4Impl.reflectWith(Platform4.jdk().createReflector(null));
        }
        config4Impl.objectClass("java.lang.StringBuffer").compare(new ObjectAttribute(){

            public Object attribute(Object object) {
                if (object instanceof StringBuffer) {
                    return ((StringBuffer)object).toString();
                }
                return object;
            }
        });
        Platform4.translate(config4Impl.objectClass("java.lang.Class"), "TClass");
        Platform4.translateCollection(config4Impl, "Hashtable", "THashtable", true);
        if (Platform4.jdk().ver() >= 2) {
            try {
                Platform4.translateCollection(config4Impl, "AbstractCollection", "TCollection", false);
                Platform4.translateUtilNull(config4Impl, "AbstractList");
                Platform4.translateUtilNull(config4Impl, "AbstractSequentialList");
                Platform4.translateUtilNull(config4Impl, "LinkedList");
                Platform4.translateUtilNull(config4Impl, "ArrayList");
                Platform4.translateUtilNull(config4Impl, "Vector");
                Platform4.translateUtilNull(config4Impl, "Stack");
                Platform4.translateUtilNull(config4Impl, "AbstractSet");
                Platform4.translateUtilNull(config4Impl, "HashSet");
                Platform4.translate(config4Impl, "java.util.TreeSet", "TTreeSet");
                Platform4.translateCollection(config4Impl, "AbstractMap", "TMap", true);
                Platform4.translateUtilNull(config4Impl, "HashMap");
                Platform4.translateUtilNull(config4Impl, "WeakHashMap");
                Platform4.translate(config4Impl, "java.util.TreeMap", "TTreeMap");
            }
            catch (Exception exception) {}
        } else {
            Platform4.translateCollection(config4Impl, "Vector", "TVector", false);
        }
        Platform4.netReadAsJava(config4Impl, "ext.Db4oDatabase");
        Platform4.netReadAsJava(config4Impl, "P1Object");
        Platform4.netReadAsJava(config4Impl, "P1Collection");
        Platform4.netReadAsJava(config4Impl, "P1HashElement");
        Platform4.netReadAsJava(config4Impl, "P1ListElement");
        Platform4.netReadAsJava(config4Impl, "P2HashMap");
        Platform4.netReadAsJava(config4Impl, "P2LinkedList");
        Platform4.netReadAsJava(config4Impl, "StaticClass");
        Platform4.netReadAsJava(config4Impl, "StaticField");
        Platform4.maximumActivationDepth(config4Impl, "P1ListElement", 1);
        Platform4.activationDepth(config4Impl, "P2LinkedList", 1);
        Platform4.activationDepth(config4Impl, "P2HashMap", 2);
        Platform4.activationDepth(config4Impl, "P1HashElement", 1);
    }

    private static void activationDepth(Config4Impl config4Impl, String string, int n) {
        ObjectClass objectClass = Platform4.db4oClassConfig(config4Impl, string);
        objectClass.minimumActivationDepth(n);
        objectClass.maximumActivationDepth(n);
    }

    private static void maximumActivationDepth(Config4Impl config4Impl, String string, int n) {
        Platform4.db4oClassConfig(config4Impl, string).maximumActivationDepth(n);
    }

    private static ObjectClass db4oClassConfig(Config4Impl config4Impl, String string) {
        return config4Impl.objectClass(Platform4.db4oClass(string));
    }

    public static Object getTypeForClass(Object object) {
        return object;
    }

    static final Object getYapRefObject(Object object) {
        return Platform4.jdk().getYapRefObject(object);
    }

    static final synchronized boolean hasCollections() {
        if (collectionCheck.unspecified()) {
            if (Platform4.classIsAvailable("java.util.Collection")) {
                collectionCheck = TernaryBool.YES;
                return true;
            }
            collectionCheck = TernaryBool.NO;
        }
        return collectionCheck.definiteYes();
    }

    public static final boolean hasLockFileThread() {
        return true;
    }

    public static final boolean hasNio() {
        if (nioCheck.unspecified()) {
            if (Platform4.jdk().ver() >= 4 && !Platform4.noNIO()) {
                nioCheck = TernaryBool.YES;
                return true;
            }
            nioCheck = TernaryBool.NO;
        }
        return nioCheck.definiteYes();
    }

    static final boolean hasShutDownHook() {
        if (shutDownHookCheck.unspecified()) {
            if (Platform4.jdk().ver() >= 3) {
                shutDownHookCheck = TernaryBool.YES;
                return true;
            }
            Reflection4.invoke(class$java$lang$System == null ? (class$java$lang$System = Platform4.class$("java.lang.System")) : class$java$lang$System, RUNFINALIZERSONEXIT, new Class[]{Boolean.TYPE}, new Object[]{new Boolean(true)});
            shutDownHookCheck = TernaryBool.NO;
        }
        return shutDownHookCheck.definiteYes();
    }

    static final boolean hasWeakReferences() {
        if (weakReferenceCheck.unspecified()) {
            if (Platform4.classIsAvailable(ACCESSIBLEOBJECT) && Platform4.classIsAvailable(REFERENCEQUEUE) && Platform4.jdk().ver() >= 2) {
                weakReferenceCheck = TernaryBool.YES;
                return true;
            }
            weakReferenceCheck = TernaryBool.NO;
        }
        return weakReferenceCheck.definiteYes();
    }

    static final boolean ignoreAsConstraint(Object object) {
        return false;
    }

    static final boolean isCollectionTranslator(Config4Class config4Class) {
        return Platform4.jdk().isCollectionTranslator(config4Class);
    }

    public static boolean isConnected(Socket socket) {
        return Platform4.jdk().isConnected(socket);
    }

    public static final boolean isValueType(ReflectClass reflectClass) {
        return false;
    }

    public static JDK jdk() {
        if (jdkWrapper == null) {
            Platform4.createJdk();
        }
        return jdkWrapper;
    }

    private static void createJdk() {
        if (Platform4.classIsAvailable("java.lang.reflect.Method")) {
            jdkWrapper = (JDK)ReflectPlatform.createInstance("com.db4o.internal.JDKReflect");
        }
        if (Platform4.classIsAvailable(ACCESSIBLEOBJECT)) {
            jdkWrapper = Platform4.createJDKWrapper("1_2");
        }
        Class[] classArray = new Class[1];
        Class clazz = classArray[0] = class$java$lang$Thread == null ? (class$java$lang$Thread = Platform4.class$("java.lang.Thread")) : class$java$lang$Thread;
        if (Platform4.jdk().methodIsAvailable("java.lang.Runtime", "addShutdownHook", classArray)) {
            jdkWrapper = Platform4.createJDKWrapper("1_3");
        }
        if (Platform4.classIsAvailable("java.nio.channels.FileLock")) {
            jdkWrapper = Platform4.createJDKWrapper("1_4");
        }
        if (Platform4.classIsAvailable("java.lang.Enum")) {
            jdkWrapper = Platform4.createJDKWrapper("5");
        }
    }

    private static JDK createJDKWrapper(String string) {
        JDK jDK = (JDK)ReflectPlatform.createInstance("com.db4o.internal.JDK_" + string);
        if (jDK != null) {
            return jDK;
        }
        return jdkWrapper;
    }

    public static boolean isSimple(Class clazz) {
        for (int i = 0; i < SIMPLE_CLASSES.length; ++i) {
            if (clazz != SIMPLE_CLASSES[i]) continue;
            return true;
        }
        return false;
    }

    static final void killYapRef(Object object) {
        Platform4.jdk().killYapRef(object);
    }

    public static void link() {
        new TClass();
        new TVector();
        new THashtable();
        new TNull();
    }

    public static final void lockFile(String string, Object object) {
        if (!Platform4.hasNio()) {
            return;
        }
        String string2 = System.getProperty("java.fullversion");
        if (string2 != null && string2.indexOf("GNU libgcj") >= 0) {
            System.err.println("Warning: Running in libgcj 3.x--not locking database file!");
            return;
        }
        Platform4.jdk().lockFile(string, object);
    }

    public static final void unlockFile(String string, Object object) {
        if (Platform4.hasNio()) {
            Platform4.jdk().unlockFile(string, object);
        }
    }

    public static final double longToDouble(long l) {
        return Double.longBitsToDouble(l);
    }

    static void markTransient(String string) {
    }

    static boolean callConstructor() {
        if (callConstructorCheck.unspecified()) {
            if (Platform4.jdk().methodIsAvailable(REFLECTIONFACTORY, GETCONSTRUCTOR, new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = Platform4.class$("java.lang.Class")) : class$java$lang$Class, Platform4.jdk().constructorClass()})) {
                callConstructorCheck = TernaryBool.NO;
                return false;
            }
            callConstructorCheck = TernaryBool.YES;
        }
        return callConstructorCheck.definiteYes();
    }

    private static final void netReadAsJava(Config4Impl config4Impl, String string) {
        Config4Class config4Class = (Config4Class)config4Impl.objectClass(Platform4.db4oClass(string) + DB4O_ASSEMBLY);
        if (config4Class == null) {
            return;
        }
        config4Class.maintainMetaClass(false);
        config4Class.readAs(Platform4.db4oClass(string));
    }

    private static String db4oClass(String string) {
        return DB4O_PACKAGE + string;
    }

    private static final boolean noNIO() {
        try {
            return Platform4.propertyIs("java.vendor", "Sun") && Platform4.propertyIs("java.version", "1.4.0") && (Platform4.propertyIs("os.name", "Linux") || Platform4.propertyIs("os.name", "Windows 95") || Platform4.propertyIs("os.name", "Windows 98"));
        }
        catch (Exception exception) {
            return true;
        }
    }

    static final void pollReferenceQueue(Object object, Object object2) {
        Platform4.jdk().pollReferenceQueue((ObjectContainerBase)object, object2);
    }

    public static void postOpen(ObjectContainer objectContainer) {
    }

    static void preClose(ObjectContainer objectContainer) {
    }

    private static final boolean propertyIs(String string, String string2) {
        String string3 = System.getProperty(string);
        return string3 != null && string3.indexOf(string2) == 0;
    }

    public static void registerCollections(GenericReflector genericReflector) {
        Platform4.registerDeprecatedCollection(genericReflector);
        Platform4.jdk().registerCollections(genericReflector);
    }

    private static void registerDeprecatedCollection(GenericReflector genericReflector) {
        genericReflector.registerCollection(class$com$db4o$P1Collection == null ? (class$com$db4o$P1Collection = Platform4.class$("com.db4o.P1Collection")) : class$com$db4o$P1Collection);
    }

    static final synchronized void removeShutDownHook(PartialObjectContainer partialObjectContainer) {
        if (!Platform4.hasShutDownHook() || shutDownRunnable == null) {
            return;
        }
        shutDownRunnable.remove(partialObjectContainer);
        if (shutDownRunnable.size() == 0) {
            if (!Platform4.shutDownRunnable.dontRemove) {
                try {
                    Platform4.jdk().removeShutdownHook(shutDownThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            shutDownThread = null;
            shutDownRunnable = null;
        }
    }

    public static final byte[] serialize(Object object) throws Exception {
        return Platform4.jdk().serialize(object);
    }

    public static final void setAccessible(Object object) {
        if (setAccessibleCheck == TernaryBool.UNSPECIFIED) {
            Platform4.canSetAccessible();
        }
        if (setAccessibleCheck == TernaryBool.YES) {
            Platform4.jdk().setAccessible(object);
        }
    }

    public static boolean storeStaticFieldValues(Reflector reflector, ReflectClass reflectClass) {
        return Platform4.isEnum(reflector, reflectClass);
    }

    public static boolean isEnum(Reflector reflector, ReflectClass reflectClass) {
        return Platform4.jdk().isEnum(reflector, reflectClass);
    }

    private static final void translate(ObjectClass objectClass, String string) {
        ((Config4Class)objectClass).translateOnDemand(DB4O_CONFIG + string);
    }

    private static final void translate(Config4Impl config4Impl, String string, String string2) {
        Platform4.translate(config4Impl.objectClass(string), string2);
    }

    private static final void translateCollection(Config4Impl config4Impl, String string, String string2, boolean bl) {
        ObjectClass objectClass = config4Impl.objectClass(UTIL + string);
        objectClass.updateDepth(3);
        if (bl) {
            objectClass.cascadeOnDelete(true);
        }
        Platform4.translate(objectClass, string2);
    }

    private static final void translateUtilNull(Config4Impl config4Impl, String string) {
        Platform4.translate(config4Impl, UTIL + string, "TNull");
    }

    static final NetTypeHandler[] types(ObjectContainerBase objectContainerBase) {
        return Platform4.jdk().types(objectContainerBase);
    }

    public static byte[] updateClassName(byte[] byArray) {
        return byArray;
    }

    public static Object weakReferenceTarget(Object object) {
        return Platform4.jdk().weakReferenceTarget(object);
    }

    public static Object wrapEvaluation(Object object) {
        return object;
    }

    public static boolean isDb4oClass(String string) {
        if (string.indexOf(".test.") > 0) {
            return false;
        }
        if (string.indexOf(".db4ounit.") > 0) {
            return false;
        }
        return string.indexOf("com.db4o") == 0;
    }

    public static boolean isTransient(ReflectClass reflectClass) {
        return false;
    }

    public static Reflector reflectorForType(Class clazz) {
        return Platform4.jdk().reflectorForType(clazz);
    }

    public static String stackTrace() {
        return StackTracer.stackTrace();
    }

    public static Date now() {
        return new Date();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nioCheck = TernaryBool.UNSPECIFIED;
        setAccessibleCheck = TernaryBool.UNSPECIFIED;
        shutDownHookCheck = TernaryBool.UNSPECIFIED;
        callConstructorCheck = TernaryBool.UNSPECIFIED;
        weakReferenceCheck = TernaryBool.UNSPECIFIED;
        SIMPLE_CLASSES = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = Platform4.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Platform4.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = Platform4.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Platform4.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Double == null ? (class$java$lang$Double = Platform4.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Byte == null ? (class$java$lang$Byte = Platform4.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = Platform4.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Short == null ? (class$java$lang$Short = Platform4.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = Platform4.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = Platform4.class$("java.util.Date")) : class$java$util$Date};
    }
}

